package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.engine.api.enums.DeepTfServer;
import cn.com.duiba.nezha.engine.api.enums.InteractAdvertAlgEnum;
import cn.com.duiba.nezha.engine.api.enums.ModelKeyEnum;
import cn.com.duiba.nezha.engine.api.enums.PredictCorrectType;
import cn.com.duiba.nezha.engine.biz.enums.RecommendMaterialType;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertStatDimWeightVo;
import org.springframework.stereotype.Service;

import static cn.com.duiba.nezha.engine.biz.vo.advert.AdvertStatDimWeightVo.advertStatDimWeightVoA;
import static cn.com.duiba.nezha.engine.biz.vo.advert.AdvertStatDimWeightVo.advertStatDimWeightVoB;

@Service
public class InteractAdvertRecommendService extends AbstractAdvertRecommendService {
    @Override
    public void prepareStrategyParameter(AdvertRecommendRequestVo advertRecommendRequestVo) {
        // 算法类型
        InteractAdvertAlgEnum interactAdvertAlgEnum = (InteractAdvertAlgEnum) advertRecommendRequestVo.getAdvertAlgEnum();

        //CTR预估模型Key
        ModelKeyEnum ctrModelKey = null;

        //CVR预估模型Key
        ModelKeyEnum cvrModelKey = null;

        // 深度学习ctr模型key
        DeepTfServer deepCtrModelKey = null;

        // 深度学习cvr模型key
        DeepTfServer deepCvrModelKey = null;

        // 广告融合权重参数对象
        AdvertStatDimWeightVo advertStatDimWeightVo = advertStatDimWeightVoB;

        //素材推荐方式
        RecommendMaterialType recommendMaterialType = RecommendMaterialType.NONE;

        PredictCorrectType predictCorrectType = PredictCorrectType.NONE;

        //广告多维度质量分是否启用
        boolean advertMultiDimScoreEffective = false;

        boolean needPredict = true;

        boolean invokeWeakFilter = false;

        MutModelType mutModelType = MutModelType.NORMAL;

        switch (interactAdvertAlgEnum) {
            case BTM_AND_SC_6:
                needPredict = false;
                invokeWeakFilter = true;
                break;
            case BTM_AND_SC_7:
                needPredict = false;
                recommendMaterialType = RecommendMaterialType.STATIC;
                invokeWeakFilter = true;
                break;
            case BTM_AND_PC_6:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                predictCorrectType = PredictCorrectType.CORRECT;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_7:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                predictCorrectType = PredictCorrectType.CORRECT_REFACTOR;
                break;
            case BTM_AND_PC_10:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v010;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v010;
                recommendMaterialType = RecommendMaterialType.STATIC;
                break;
            case BTM_AND_PC_13:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                advertMultiDimScoreEffective = true;
                break;
            case BTM_AND_PC_17:
                ctrModelKey = ModelKeyEnum.FM_CTR_MODEL_v003;
                cvrModelKey = ModelKeyEnum.FM_BCVR_MODEL_v003;
                break;
            case BTM_AND_PC_20:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v611;
                cvrModelKey = ModelKeyEnum.FTRL_FM_CVR_MODEL_v611;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_23:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v002;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v002;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_27:
                ctrModelKey = ModelKeyEnum.FM_CTR_MODEL_v603;
                cvrModelKey = ModelKeyEnum.FM_BCVR_MODEL_v603;
                break;
            case BTM_AND_PC_28:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v612;
                cvrModelKey = ModelKeyEnum.FTRL_FM_CVR_MODEL_v612;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_29:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_31:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_35:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                predictCorrectType = PredictCorrectType.CORRECT_NEW1;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_36:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                predictCorrectType = PredictCorrectType.CORRECT_NEW2;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_41:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.FNN_CTR_002;
                deepCvrModelKey = DeepTfServer.FNN_BCVR_002;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP;
                break;
            case BTM_AND_PC_42:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.DEEP_FM_CTR_002;
                deepCvrModelKey = DeepTfServer.DEEP_FM_BCVR_002;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP;
                break;
            case BTM_AND_PC_44:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.DCN_CTR_002;
                deepCvrModelKey = DeepTfServer.DCN_BCVR_002;
                mutModelType = MutModelType.DEEP;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_45:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.DCN_CTR_003;
                deepCvrModelKey = DeepTfServer.DCN_BCVR_003;
                mutModelType = MutModelType.DEEP;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_46:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.XDEEP_FM_CTR_002;
                deepCvrModelKey = DeepTfServer.XDEEP_FM_CVR_002;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP;
                break;
            case BTM_AND_PC_47:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.XDEEP_FM_CTR_003;
                deepCvrModelKey = DeepTfServer.XDEEP_FM_CVR_003;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP;
                break;
            case BTM_AND_PC_48:
                ctrModelKey = ModelKeyEnum.FFM_CTR_MODEL_V002;
                cvrModelKey = ModelKeyEnum.FFM_BCVR_MODEL_V002;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_50:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v004;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v004;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_51:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v011;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v011;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_52:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v010;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v010;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                recommendMaterialType = RecommendMaterialType.PREDICT;
                break;
            case BTM_AND_PC_53:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.XDEEP_FM_CTR_004;
                deepCvrModelKey = DeepTfServer.XDEEP_FM_BCVR_004;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP;
                break;
            case BTM_AND_PC_54:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v004;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v004;
                deepCtrModelKey = DeepTfServer.ESMM_001;
                deepCvrModelKey = DeepTfServer.ESMM_001;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP_ESMM;
                break;
            case BTM_AND_PC_55:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v004;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v004;
                deepCtrModelKey = DeepTfServer.ESMM_002;
                deepCvrModelKey = DeepTfServer.ESMM_002;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP_ESMM;
                break;
            case BTM_AND_PC_56:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v004;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v004;
                deepCtrModelKey = DeepTfServer.ESMM_B003;
                deepCvrModelKey = DeepTfServer.ESMM_B003;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP_ESMM;
                break;
            case BTM_AND_PC_57:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v004;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v004;
                deepCtrModelKey = DeepTfServer.ESMM_B004;
                deepCvrModelKey = DeepTfServer.ESMM_B004;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP_ESMM;
                break;
            case BTM_AND_PC_58:
                ctrModelKey = ModelKeyEnum.FFM_CTR_MODEL_V001;
                cvrModelKey = ModelKeyEnum.FFM_BCVR_MODEL_V001;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_59:
                ctrModelKey = ModelKeyEnum.FFM_CTR_MODEL_V004;
                cvrModelKey = ModelKeyEnum.FFM_BCVR_MODEL_V004;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_60:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v012;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_61:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.XDEEP_FM_CTR_005;
                deepCvrModelKey = DeepTfServer.XDEEP_FM_BCVR_005;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP;
                break;
            case BTM_AND_PC_62:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v007;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007;
                deepCtrModelKey = DeepTfServer.XDEEP_FM_CTR_006;
                deepCvrModelKey = DeepTfServer.XDEEP_FM_BCVR_006;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                mutModelType = MutModelType.DEEP;
                break;
            case BTM_AND_PC_63:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v701;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v701;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            case BTM_AND_PC_64:
                ctrModelKey = ModelKeyEnum.FTRL_FM_CTR_MODEL_v702;
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v702;
                advertStatDimWeightVo = advertStatDimWeightVoA;
                break;
            default:
                throw new RuntimeException();
        }

        advertRecommendRequestVo.setNeedPredict(needPredict);
        advertRecommendRequestVo.setAdvertStatDimWeightVo(advertStatDimWeightVo);
        advertRecommendRequestVo.setCtrModelKey(ctrModelKey);
        advertRecommendRequestVo.setCvrModelKey(cvrModelKey);
        advertRecommendRequestVo.setRecommendMaterialType(recommendMaterialType);
        advertRecommendRequestVo.setPredictCorrectType(predictCorrectType);
        advertRecommendRequestVo.setAdvertMultiDimScoreEffective(advertMultiDimScoreEffective);
        advertRecommendRequestVo.setInvokeWeakFilter(invokeWeakFilter);
        advertRecommendRequestVo.setDeepCtrModelKey(deepCtrModelKey);
        advertRecommendRequestVo.setDeepCvrModelKey(deepCvrModelKey);
        advertRecommendRequestVo.setMutModelType(mutModelType);
    }
}
