package cn.com.duiba.nezha.engine.biz.service.advert.ctr;

import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.mergeData.MergeData;
import cn.com.duiba.nezha.engine.biz.enums.MergeDataType;
import cn.com.duiba.nezha.engine.biz.service.CacheService;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Created by pc on 2017/2/27.
 */
public interface AdvertMergeStatService {

    List<MergeData> getMaterialDataInApp(Long advertId, Long appId, List<Long> materialIds);

    Map<MergeDataType, List<MergeData>> getAdvertAndAppData(Collection<Advert> adverts, Long appId);

    Map<String, CacheService.CacheInfo> getCacheInfo();

    class AdvertMergeDataQuery {

        private Long advertId;
        private Long materialId;
        private Long appId;
        private Long times;

        public Long getAdvertId() {
            return advertId;
        }

        public Long getMaterialId() {
            return materialId;
        }

        public Long getAppId() {
            return appId;
        }

        public Long getTimes() {
            return times;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AdvertMergeDataQuery that = (AdvertMergeDataQuery) o;
            return Objects.equals(advertId, that.advertId) &&
                    Objects.equals(materialId, that.materialId) &&
                    Objects.equals(appId, that.appId) &&
                    Objects.equals(times, that.times);
        }

        @Override
        public int hashCode() {
            return Objects.hash(advertId, materialId, appId, times);
        }

        private AdvertMergeDataQuery(Builder builder) {
            advertId = builder.advertId;
            materialId = builder.materialId;
            appId = builder.appId;
            times = builder.times;
        }

        public static Builder newBuilder() {
            return new Builder();
        }


        public static final class Builder {
            private Long advertId;
            private Long materialId;
            private Long appId;
            private Long times;

            private Builder() {
            }

            public Builder advertId(Long val) {
                advertId = val;
                return this;
            }

            public Builder materialId(Long val) {
                materialId = val;
                return this;
            }

            public Builder appId(Long val) {
                appId = val;
                return this;
            }

            public Builder times(Long val) {
                times = val;
                return this;
            }

            public AdvertMergeDataQuery build() {
                return new AdvertMergeDataQuery(this);
            }
        }
    }



}
