package cn.com.duiba.nezha.engine.biz.service.advert.feature.impl;

import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ResourceFeatureService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.collect.Lists;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class ResourceFeatureServiceImpl implements ResourceFeatureService {

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");

    private static final String TABLE_NAME = "consumer_resource_feature";

    private static final byte[] FAMILY = "cf".getBytes();

    @Autowired
    private HbaseTemplate hbaseTemplate;

    private String dayKey(Long consumerId) {
        return this.key(consumerId) + "-" +
                LocalDate.now().format(DATE_TIME_FORMATTER);
    }

    private String key(Long consumerId) {
        return DigestUtils.md5DigestAsHex(consumerId.toString().getBytes()).substring(0, 4) + "-" + consumerId;
    }

    @Override
    @SuppressWarnings("squid:S3776")
    public void get(Long consumerId, FeatureDo featureDo) {


        Map<String, Long> dayResourceOrderRank = new HashMap<>();
        Map<String, Long> dayResourceChargeCnt = new HashMap<>();
        Map<String, Long> dayResourceConvertCnt = new HashMap<>();
        Map<String, String> resourceLastGmtCreateTime = new HashMap<>();
        Map<String, String> resourceLastLaunchOrderId = new HashMap<>();
        Map<String, String> resourceLastClickOrderId = new HashMap<>();
        Map<String, String> resourceLastConvertOrderId = new HashMap<>();


        String dayKey = dayKey(consumerId);
        String newDayKey = dayKey + "-str";
        List<String> keys = Lists.newArrayList(newDayKey, dayKey);

        hbaseTemplate.execute(TABLE_NAME, table -> {

            List<Get> gets = keys.stream().map(key -> new Get(key.getBytes()).addFamily(FAMILY)).collect(Collectors.toList());

            DBTimeProfile.enter("hbaseResourceGet");
            Result[] results = table.get(gets);
            DBTimeProfile.release();

            for (int i = 0; i < keys.size(); i++) {
                String key = keys.get(i);
                Result result = results[i];
                Cell[] cells = result.rawCells();
                for (Cell cell : cells) {
                    String column = Bytes.toString(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    if (key.equals(newDayKey)) {
                        String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                        if (column.contains("770201")) {
                            resourceLastGmtCreateTime.put(column, value);
                        }
                        if (column.contains("770301_1")) {
                            resourceLastLaunchOrderId.put(column, value);
                        }
                        if (column.contains("770301_2")) {
                            resourceLastClickOrderId.put(column, value);
                        }
                        if (column.contains("770301_3")) {
                            resourceLastConvertOrderId.put(column, value);
                        }
                        if (column.contains("770501")) {
                            featureDo.setLastOperatingResource(value);
                        }

                    } else {
                        long count = Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                        if (column.contains("770101")) {
                            dayResourceOrderRank.put(column, count);
                        }
                        if (column.contains("770401")) {
                            dayResourceChargeCnt.put(column, count);
                        }
                        if (column.contains("770402")) {
                            dayResourceConvertCnt.put(column, count);
                        }

                    }
                }

            }

            featureDo.setDayResourceOrderRank(dayResourceOrderRank);
            featureDo.setDayResourceChargeCnt(dayResourceChargeCnt);
            featureDo.setDayResourceConvertCnt(dayResourceConvertCnt);
            featureDo.setResourceLastGmtCreateTime(resourceLastGmtCreateTime);
            featureDo.setResourceLastLaunchOrderId(resourceLastLaunchOrderId);
            featureDo.setResourceLastClickOrderId(resourceLastClickOrderId);
            featureDo.setResourceLastConvertOrderId(resourceLastConvertOrderId);

            return null;
        });

    }
}
