/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.domain.advert;

import cn.com.duiba.nezha.engine.api.dto.AdvertNewDto;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.domain.advert.StatisticDataGetter;
import cn.com.duiba.nezha.engine.biz.domain.mergeData.MergeData;
import cn.com.duiba.nezha.engine.biz.enums.AdvertType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Advert
implements StatisticDataGetter {
    private Long id;
    private AdvertType type;
    private Long accountId;
    private Set<String> spreadTags;
    private Set<OrientationPackage> orientationPackages;
    private Long launchCountToUser;
    private Double weight;
    private String industryTag;
    private Set<Long> backupAdvertIds;
    private String matchTags;
    private Double discountRate;
    private String resourceTagNum;
    private MergeData appMergeData;
    private MergeData globalMergeData;
    private Integer canReplaceLowArpu;
    private StatisticData hourStatisticData;
    private StatisticData todayStatisticData;
    private StatisticData recently7DayStatisticData;
    private StatisticData hourAppStatisticData;
    private StatisticData todayAppStatisticData;
    private StatisticData recently7DayAppStatisticData;

    public static Advert convert(AdvertNewDto advertDto, AdvertType advertType) {
        Advert newAdvert = new Advert();
        newAdvert.setId(advertDto.getAdvertId());
        newAdvert.setType(advertType);
        newAdvert.setAccountId(Long.parseLong(advertDto.getAccountId()));
        newAdvert.setSpreadTags(advertDto.getSpreadTags());
        newAdvert.setLaunchCountToUser(advertDto.getLaunchCountToUser());
        newAdvert.setWeight(Optional.ofNullable(advertDto.getWeight()).orElse(1.0));
        newAdvert.setIndustryTag(advertDto.getIndustryTagNew());
        newAdvert.setBackupAdvertIds(advertDto.getBackupAdvertIds());
        newAdvert.setMatchTags(advertDto.getMatchTagNums());
        newAdvert.setDiscountRate(advertDto.getDiscountRate());
        newAdvert.setCanReplaceLowArpu(Optional.ofNullable(advertDto.getCanReplaceLowArpu()).orElse(0));
        newAdvert.setResourceTagNum(advertDto.getResourceTagNum());
        return newAdvert;
    }

    public String getResourceTagNum() {
        return this.resourceTagNum;
    }

    public void setResourceTagNum(String resourceTagNum) {
        this.resourceTagNum = resourceTagNum;
    }

    @Override
    public StatisticData getHourAppStatisticData() {
        return this.hourAppStatisticData;
    }

    public void setHourAppStatisticData(StatisticData hourAppStatisticData) {
        this.hourAppStatisticData = hourAppStatisticData;
    }

    @Override
    public StatisticData getTodayAppStatisticData() {
        return this.todayAppStatisticData;
    }

    public void setTodayAppStatisticData(StatisticData todayAppStatisticData) {
        this.todayAppStatisticData = todayAppStatisticData;
    }

    @Override
    public StatisticData getRecently7DayAppStatisticData() {
        return this.recently7DayAppStatisticData;
    }

    public void setRecently7DayAppStatisticData(StatisticData recently7DayAppStatisticData) {
        this.recently7DayAppStatisticData = recently7DayAppStatisticData;
    }

    public AdvertType getType() {
        return this.type;
    }

    public void setType(AdvertType type) {
        this.type = type;
    }

    @Override
    public StatisticData getHourStatisticData() {
        return this.hourStatisticData;
    }

    public void setHourStatisticData(StatisticData hourStatisticData) {
        this.hourStatisticData = hourStatisticData;
    }

    @Override
    public StatisticData getTodayStatisticData() {
        return this.todayStatisticData;
    }

    public void setTodayStatisticData(StatisticData todayStatisticData) {
        this.todayStatisticData = todayStatisticData;
    }

    @Override
    public StatisticData getRecently7DayStatisticData() {
        return this.recently7DayStatisticData;
    }

    public void setRecently7DayStatisticData(StatisticData recently7DayStatisticData) {
        this.recently7DayStatisticData = recently7DayStatisticData;
    }

    public Optional<MergeData> getAppMergeData() {
        return Optional.ofNullable(this.appMergeData);
    }

    public void setAppMergeData(MergeData appMergeData) {
        this.appMergeData = appMergeData;
    }

    public Optional<MergeData> getGlobalMergeData() {
        return Optional.ofNullable(this.globalMergeData);
    }

    public void setGlobalMergeData(MergeData globalMergeData) {
        this.globalMergeData = globalMergeData;
    }

    public Double getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public String getMatchTags() {
        return this.matchTags;
    }

    public void setMatchTags(String matchTags) {
        this.matchTags = matchTags;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Set<String> getSpreadTags() {
        return Optional.ofNullable(this.spreadTags).orElseGet(HashSet::new);
    }

    public void setSpreadTags(Set<String> spreadTags) {
        this.spreadTags = spreadTags;
    }

    public Set<OrientationPackage> getOrientationPackages() {
        return Optional.ofNullable(this.orientationPackages).orElseGet(HashSet::new);
    }

    public void setOrientationPackages(Set<OrientationPackage> orientationPackages) {
        this.orientationPackages = orientationPackages;
    }

    public Long getLaunchCountToUser() {
        return this.launchCountToUser;
    }

    public void setLaunchCountToUser(Long launchCountToUser) {
        this.launchCountToUser = launchCountToUser;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public String getIndustryTag() {
        return this.industryTag;
    }

    public void setIndustryTag(String industryTag) {
        this.industryTag = industryTag;
    }

    public Set<Long> getBackupAdvertIds() {
        return this.backupAdvertIds;
    }

    public void setBackupAdvertIds(Set<Long> backupAdvertIds) {
        this.backupAdvertIds = backupAdvertIds;
    }

    public Integer getCanReplaceLowArpu() {
        return this.canReplaceLowArpu;
    }

    public void setCanReplaceLowArpu(Integer canReplaceLowArpu) {
        this.canReplaceLowArpu = canReplaceLowArpu;
    }

    public Long getCurrentCount() {
        long currentCount = Optional.ofNullable(this.launchCountToUser).orElse(0L) + 1L;
        if (currentCount > 10L) {
            currentCount = 10L;
        }
        return currentCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Advert advert = (Advert)o;
        return Objects.equals(this.id, advert.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Boolean hasCvrData() {
        return this.orientationPackages.stream().anyMatch(OrientationPackage::isCpa) || this.globalMergeData != null && this.globalMergeData.getExposureCount() != null && this.globalMergeData.getExposureCount() > 0L;
    }

    public Boolean isNew() {
        return Optional.ofNullable(this.globalMergeData).map(MergeData::getLaunchCount).orElse(0L) <= 1000L;
    }
}

