/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.message.advert.ons;

import cn.com.duiba.nezha.alg.common.model.RoiPidController;
import cn.com.duiba.nezha.alg.common.model.StatInfo;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertStatAssociationBo;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.CpaFactorEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.RoiLogEntity;
import cn.com.duiba.nezha.engine.biz.log.BaseInnerLog;
import cn.com.duiba.nezha.engine.biz.message.advert.ons.AbstractMessageResultHandler;
import cn.com.duiba.nezha.engine.biz.message.advert.ons.OnsRoiControllerMessageTag;
import cn.com.duiba.nezha.engine.biz.message.advert.ons.RocketMqMessageListener;
import cn.com.duiba.nezha.engine.common.utils.MultiStringUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.RoiHashKeyUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RoiClickMessageHandler
extends AbstractMessageResultHandler {
    private static final String CLICK = "click";
    private static final String TIME = "time";
    private static final int THRESHOLD = 100;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private StringRedisTemplate nezhaStringRedisTemplate;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AdvertStatAssociationBo advertStatAssociationBo;

    @Override
    public String getListenTag() {
        return OnsRoiControllerMessageTag.ROI_CLICK.getTag();
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank((String)message)) {
            JSONObject json = JSONObject.parseObject((String)message);
            String advertId = json.getString("adid");
            String targetCpaString = json.getString("targetCpa");
            String appTargetCpaString = json.getString("appTargetCpa");
            appTargetCpaString = appTargetCpaString == null || appTargetCpaString.equals("null") ? targetCpaString : appTargetCpaString;
            String packageId = json.getString("packageId");
            String budgetPerDayString = json.getString("budgetPerDay");
            String appId = json.getString("appId");
            String slotId = json.getString("slotId");
            String activityId = json.getString("activityId");
            String materialId = json.getString("materialId");
            Integer trusteeship = json.getInteger("trusteeship");
            Integer cvrType = json.getInteger("cvrType");
            Integer releaseTarget = Optional.ofNullable(json.getInteger("releaseTarget")).orElse(3);
            if (MultiStringUtils.isAnyBlank((String[])new String[]{advertId, targetCpaString, packageId, appId, slotId, activityId})) {
                this.logger.warn("conusmer message:{} error,illegal argument", (Object)message);
                return;
            }
            Cat.logMetricForCount((String)"roiClick");
            String appKey = RoiHashKeyUtil.getAppKey((Object)appId, (Integer)cvrType);
            String slotKey = RoiHashKeyUtil.getSlotKey((Object)slotId, (Integer)cvrType);
            String activityKey = RoiHashKeyUtil.getActivityKey((Object)appId, (String)activityId, (Integer)cvrType);
            String recentlyClickKey = RedisKeyUtil.recentlyClickKey((String)advertId, (String)packageId);
            this.stringRedisTemplate.executePipelined(connection -> {
                StringRedisConnection stringRedisConn = (StringRedisConnection)connection;
                stringRedisConn.zIncrBy(recentlyClickKey, 1.0, appKey);
                stringRedisConn.zIncrBy(recentlyClickKey, 1.0, slotKey);
                stringRedisConn.zIncrBy(recentlyClickKey, 1.0, activityKey);
                stringRedisConn.expire(recentlyClickKey, 86400L);
                return null;
            });
            String clickKey = RedisKeyUtil.roiClickKey((String)advertId, (String)packageId);
            double targetCpa = Double.parseDouble(targetCpaString);
            double appTargetCpa = Double.parseDouble(appTargetCpaString);
            long budgetPerDay = StringUtils.isNotBlank((String)budgetPerDayString) ? Long.parseLong(budgetPerDayString) : -1L;
            String lockKey = RedisKeyUtil.roiClickLockKey((String)advertId, (String)packageId);
            try {
                this.spinLock(lockKey);
                this.stringRedisTemplate.expire((Object)lockKey, 5L, TimeUnit.SECONDS);
                long clickTimes = this.stringRedisTemplate.opsForHash().increment((Object)clickKey, (Object)CLICK, 1L);
                if (clickTimes == 1L) {
                    this.stringRedisTemplate.opsForHash().put((Object)clickKey, (Object)TIME, (Object)String.valueOf(Instant.now().getEpochSecond()));
                    this.stringRedisTemplate.expire((Object)clickKey, (long)DateUtils.getToTomorrowSeconds() + (long)new Random().nextInt(100), TimeUnit.SECONDS);
                }
                if (clickTimes < 100L) {
                    return;
                }
                Instant instant = Instant.ofEpochSecond(Long.parseLong((String)this.stringRedisTemplate.opsForHash().get((Object)clickKey, (Object)TIME)));
                LocalDateTime createTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                if (createTime.plusMinutes(2L).isBefore(LocalDateTime.now())) {
                    List waitUpdate;
                    this.stringRedisTemplate.delete((Object)clickKey);
                    String feeKey = RedisKeyUtil.roiFeeKey((String)advertId, (String)packageId, (LocalDate)LocalDate.now());
                    String cvrKey = RedisKeyUtil.roiCvrKey((String)advertId, (String)packageId, (LocalDate)LocalDate.now());
                    Set dimClickTimes = this.stringRedisTemplate.opsForZSet().reverseRangeWithScores((Object)recentlyClickKey, 0L, 48L);
                    HashMap<String, Long> dimClickTimesMap = new HashMap<String, Long>(dimClickTimes.size());
                    dimClickTimes.forEach(tuple -> dimClickTimesMap.put((String)tuple.getValue(), (long)tuple.getScore().doubleValue()));
                    dimClickTimesMap.put(RoiHashKeyUtil.getDefault((Integer)cvrType), clickTimes);
                    ArrayList<String> recentlyKeys = new ArrayList<String>(dimClickTimesMap.keySet());
                    Map<String, Double> superNodeFactor = this.getSuperNodeFactor(advertId, packageId, recentlyKeys, cvrType);
                    List feeList = this.stringRedisTemplate.opsForHash().multiGet((Object)feeKey, recentlyKeys);
                    List cvrList = this.stringRedisTemplate.opsForHash().multiGet((Object)cvrKey, recentlyKeys);
                    HashMap<String, Long> feeMap = new HashMap<String, Long>();
                    HashMap<String, Long> cvrMap = new HashMap<String, Long>();
                    for (int i = 0; i < recentlyKeys.size(); ++i) {
                        String key2 = (String)recentlyKeys.get(i);
                        String feeString = (String)feeList.get(i);
                        String cvrString = (String)cvrList.get(i);
                        if (StringUtils.isNotBlank((String)feeString)) {
                            feeMap.put(key2, Long.parseLong(feeString));
                        }
                        if (!StringUtils.isNotBlank((String)cvrString)) continue;
                        cvrMap.put(key2, Long.parseLong(cvrString));
                    }
                    List mongoIds = recentlyKeys.stream().map(key -> this.getKey(advertId, packageId, (String)key)).collect(Collectors.toList());
                    List factors = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(mongoIds)), CpaFactorEntity.class, "cpa_factor");
                    ImmutableMap factorMap = Maps.uniqueIndex((Iterable)factors, CpaFactorEntity::getId);
                    ArrayList<StatInfo> statInfos = new ArrayList<StatInfo>(recentlyKeys.size());
                    HashMap<String, Boolean> isToday = new HashMap<String, Boolean>(statInfos.size());
                    Map<String, StatisticData> statDataMap = this.getStatData(Long.parseLong(advertId), recentlyKeys);
                    for (String key3 : recentlyKeys) {
                        StatisticData statDto;
                        Date gmtCreate;
                        LocalDate localDate;
                        String mongoId = this.getKey(advertId, packageId, key3);
                        CpaFactorEntity entity = (CpaFactorEntity)factorMap.get(mongoId);
                        isToday.put(mongoId, false);
                        double lastCvr = 0.0;
                        double lastFee = 0.0;
                        if (entity != null && (localDate = (gmtCreate = entity.getGmtCreate()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).isEqual(LocalDate.now())) {
                            lastCvr = entity.getCvr() == null ? 0.0 : (double)entity.getCvr().longValue();
                            lastFee = entity.getFee() == null ? 0.0 : (double)entity.getFee().longValue();
                            isToday.put(mongoId, true);
                        }
                        double lastFactor = entity == null || entity.getFactor() == null || entity.getFactor().isNaN() ? 1.0 : entity.getFactor();
                        Long cvr = (Long)cvrMap.get(key3);
                        cvr = cvr == null ? 0L : cvr;
                        Long fee = (Long)feeMap.get(key3);
                        fee = fee == null ? 0L : fee;
                        Long click = (Long)dimClickTimesMap.get(key3);
                        click = click == null ? 0L : click;
                        StatInfo statInfo = new StatInfo();
                        statInfo.setId(key3);
                        statInfo.setSumFee((double)fee.longValue());
                        statInfo.setSumConv((double)cvr.longValue());
                        statInfo.setSumClick((double)click.longValue());
                        statInfo.setLastSumFee(lastFee);
                        statInfo.setLastSumConv(lastCvr);
                        statInfo.setFactor(lastFactor);
                        Double superFactor = superNodeFactor.get(key3);
                        if (superFactor != null) {
                            statInfo.setParentFactor(superFactor.doubleValue());
                        }
                        if ((statDto = statDataMap.get(key3)) != null) {
                            statInfo.setConv7d((double)Optional.ofNullable(statDto.getConvertCount()).orElse(0L).longValue());
                            statInfo.setFee7d((double)Optional.ofNullable(statDto.getTotalConsume()).orElse(0L).longValue());
                            statInfo.setClick7d((double)Optional.ofNullable(statDto.getChargeClickCount()).orElse(0L).longValue());
                        }
                        statInfos.add(statInfo);
                    }
                    RoiPidController roiPidController = new RoiPidController();
                    if (appId.equals("57078") || appId.equals("57173")) {
                        appTargetCpa *= 1.3;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(waitUpdate = roiPidController.getPriceFactor(statInfos, targetCpa, appTargetCpa, (double)budgetPerDay, releaseTarget.intValue())))) {
                        this.stringRedisTemplate.opsForZSet().remove((Object)recentlyClickKey, waitUpdate.stream().map(StatInfo::getId).distinct().toArray());
                    }
                    this.updateFactor(advertId, packageId, dimClickTimesMap, feeMap, cvrMap, isToday, waitUpdate, appId, slotId, materialId, trusteeship);
                }
            }
            catch (Exception e) {
                this.logger.error("click handle error,advertId:{} packageId:{},error:{}", new Object[]{advertId, packageId, e});
                throw new RecommendEngineException("click handle error", e);
            }
            finally {
                this.stringRedisTemplate.delete((Object)lockKey);
            }
        }
    }

    private void updateFactor(String advertId, String packageId, Map<String, Long> dimClickTimesMap, Map<String, Long> feeMap, Map<String, Long> cvrMap, Map<String, Boolean> isToday, List<StatInfo> waitUpdate, String appId, String slotId, String materialId, Integer trusteeship) {
        for (StatInfo statInfo : waitUpdate) {
            String key = statInfo.getId();
            String mongoId = this.getKey(advertId, packageId, key);
            Long cvr = cvrMap.get(key);
            cvr = cvr == null ? 0L : cvr;
            Long fee = feeMap.get(key);
            fee = fee == null ? 0L : fee;
            Long click = dimClickTimesMap.get(key);
            click = click == null ? 0L : click;
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)mongoId));
            Update update = new Update();
            update.set("advertId", (Object)advertId);
            update.set("packageId", (Object)packageId);
            update.set("cvr", (Object)cvr);
            update.set("fee", (Object)fee);
            update.set(CLICK, (Object)click);
            Double factor = statInfo.getFactor();
            if (factor.isNaN()) {
                factor = 1.0;
            }
            update.set("factor", (Object)factor);
            Boolean today = isToday.get(mongoId);
            if (today == null || !today.booleanValue()) {
                update.set("gmtCreate", (Object)new Date());
            }
            update.set("gmtModified", (Object)new Date());
            update.setOnInsert("expireAt", (Object)this.getNextMorningTime());
            this.mongoTemplate.upsert(query, update, "cpa_factor");
            String redisKey = RedisKeyUtil.factorKey((Long)Long.parseLong(advertId), (Long)Long.parseLong(packageId), (String)key);
            this.nezhaStringRedisTemplate.opsForValue().set((Object)redisKey, (Object)String.valueOf(factor), 1L, TimeUnit.DAYS);
            RoiLogEntity roiLogEntity = new RoiLogEntity();
            roiLogEntity.setId(mongoId);
            roiLogEntity.setAdvertId(advertId);
            roiLogEntity.setPackageId(packageId);
            roiLogEntity.setFactor(statInfo.getFactor());
            roiLogEntity.setFeeSum(fee);
            roiLogEntity.setCvrSum(cvr);
            roiLogEntity.setAppId(appId);
            roiLogEntity.setSlotId(slotId);
            roiLogEntity.setMaterialId(materialId);
            roiLogEntity.setTrusteeship(trusteeship);
            BaseInnerLog.log(roiLogEntity);
            this.logger.info("trigger pid,id:{} advertId:{} packageId:{} factor:{} feeSum:{} cvrSum:{}", new Object[]{mongoId, advertId, packageId, statInfo.getFactor(), fee, cvr});
        }
    }

    private void spinLock(String lockKey) {
        while (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"").booleanValue()) {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                this.logger.error("get redis roi click lock failure", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }

    private String getKey(String advertId, String packageId, String suffix) {
        Joiner joiner = Joiner.on((String)"_");
        return joiner.join((Object)advertId, (Object)packageId, new Object[]{suffix});
    }

    private Date getNextMorningTime() {
        LocalDateTime tomorrow = LocalDateTime.now().plusDays(1L);
        LocalDateTime morning = LocalDateTime.of(tomorrow.getYear(), tomorrow.getMonth(), tomorrow.getDayOfMonth(), 0, 0, 0);
        return Date.from(morning.atZone(ZoneId.systemDefault()).toInstant());
    }

    private Map<String, Double> getSuperNodeFactor(String advertId, String packageId, Collection<String> dimKeys, Integer cvrType) {
        HashMap<String, Double> superFactorMap = new HashMap<String, Double>(dimKeys.size());
        LinkedListMultimap superKeyMap = LinkedListMultimap.create();
        HashSet allSuperKeys = new HashSet();
        dimKeys.stream().filter(StringUtils::isNotBlank).forEach(arg_0 -> this.lambda$getSuperNodeFactor$3(advertId, packageId, cvrType, superFactorMap, allSuperKeys, (Multimap)superKeyMap, arg_0));
        List factors = this.mongoTemplate.find(Query.query((CriteriaDefinition)new Criteria("_id").in(allSuperKeys)), CpaFactorEntity.class, "cpa_factor");
        ImmutableMap factorMap = Maps.uniqueIndex((Iterable)factors, CpaFactorEntity::getId);
        Set entries = superKeyMap.asMap().entrySet();
        for (Map.Entry entry : entries) {
            String dimKey = (String)entry.getKey();
            Collection keys = (Collection)entry.getValue();
            Double factor = null;
            for (String superKey : keys) {
                CpaFactorEntity entity = (CpaFactorEntity)factorMap.get((Object)superKey);
                if (entity == null || entity.getFactor() == null || entity.getFactor().isNaN()) continue;
                factor = entity.getFactor();
                break;
            }
            superFactorMap.put(dimKey, factor != null ? factor : 1.0);
        }
        return superFactorMap;
    }

    private Map<String, StatisticData> getStatData(Long advertId, Collection<String> dimKeys) {
        Map<Long, StatisticData> appId2StatMap;
        HashSet<Long> appIds = new HashSet<Long>();
        Splitter splitter = Splitter.on((String)"_").omitEmptyStrings().trimResults();
        HashMap<String, Long> keyAppMap = new HashMap<String, Long>(dimKeys.size());
        for (String key : dimKeys) {
            Long appId = null;
            if (key.contains("APP")) {
                Iterable split = splitter.split((CharSequence)key);
                ArrayList<String> strings = new ArrayList<String>();
                for (String s : split) {
                    strings.add(s);
                }
                if (strings.size() == 2) {
                    appId = Long.parseLong((String)strings.get(1));
                    appIds.add(appId);
                }
            }
            keyAppMap.put(key, appId);
        }
        if (appIds.isEmpty()) {
            appIds.add(-1L);
        }
        if (MapUtils.isEmpty(appId2StatMap = this.advertStatAssociationBo.get7DayStat(appIds, advertId, null))) {
            return MapUtils.EMPTY_MAP;
        }
        HashMap<String, StatisticData> record = new HashMap<String, StatisticData>(dimKeys.size());
        for (String dimKey : dimKeys) {
            record.put(dimKey, appId2StatMap.get(keyAppMap.get(dimKey)));
        }
        return record;
    }

    private /* synthetic */ void lambda$getSuperNodeFactor$3(String advertId, String packageId, Integer cvrType, Map superFactorMap, Set allSuperKeys, Multimap superKeyMap, String dimKey) {
        String defaultKey = this.getKey(advertId, packageId, RoiHashKeyUtil.getDefault((Integer)cvrType));
        if (defaultKey.equals(dimKey)) {
            superFactorMap.put(dimKey, 1.0);
            return;
        }
        if (dimKey.contains("ACTIVITY")) {
            String appId = dimKey.substring("ACTIVITY".length() + 1).split("_")[0];
            String appKey = this.getKey(advertId, packageId, RoiHashKeyUtil.getAppKey((Object)appId, (Integer)cvrType));
            allSuperKeys.add(appKey);
            superKeyMap.put((Object)dimKey, (Object)appKey);
        }
        allSuperKeys.add(defaultKey);
        superKeyMap.put((Object)dimKey, (Object)defaultKey);
    }
}

