/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.remoteservice.impl.advert;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.nezha.alg.alg.vo.BiddingRateDo;
import cn.com.duiba.nezha.alg.alg.vo.BiddingStatDo;
import cn.com.duiba.nezha.alg.alg.vo.NezhaStatDto;
import cn.com.duiba.nezha.engine.api.dto.AdvertActivityDto;
import cn.com.duiba.nezha.engine.api.dto.AdvertNewDto;
import cn.com.duiba.nezha.engine.api.dto.AppDto;
import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.nezha.engine.api.dto.FusingOrientationPackageDto;
import cn.com.duiba.nezha.engine.api.dto.RcmdAdvertDto;
import cn.com.duiba.nezha.engine.api.dto.ReqAdvertNewDto;
import cn.com.duiba.nezha.engine.api.dto.RequestDto;
import cn.com.duiba.nezha.engine.api.enums.AdvertAlgEnum;
import cn.com.duiba.nezha.engine.api.enums.InteractAdvertAlgEnum;
import cn.com.duiba.nezha.engine.api.enums.ModelKeyEnum;
import cn.com.duiba.nezha.engine.api.enums.ModelType;
import cn.com.duiba.nezha.engine.api.enums.RecommendType;
import cn.com.duiba.nezha.engine.api.enums.ResultCodeEnum;
import cn.com.duiba.nezha.engine.api.enums.ShowAdvertAlgEnum;
import cn.com.duiba.nezha.engine.api.remoteservice.advert.RemoteAdvertRecommendService;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.ActivityDo;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatFeatureDo;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerDo;
import cn.com.duiba.nezha.engine.biz.domain.FeatureIndex;
import cn.com.duiba.nezha.engine.biz.domain.RequestDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.advert.Material;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.domain.advert.SmoothFusePackage;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.BizLogEntity;
import cn.com.duiba.nezha.engine.biz.enums.AdvertType;
import cn.com.duiba.nezha.engine.biz.enums.RecommendMaterialType;
import cn.com.duiba.nezha.engine.biz.log.BaseInnerLog;
import cn.com.duiba.nezha.engine.biz.service.advert.AbstractAdvertRecommendService;
import cn.com.duiba.nezha.engine.biz.service.advert.DataHandleBo;
import cn.com.duiba.nezha.engine.biz.service.advert.InteractAdvertRecommendService;
import cn.com.duiba.nezha.engine.biz.service.advert.ShowAdvertRecommendService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.NewAdvertSupportService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.DateUtils;
import com.dianping.cat.Cat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteAdvertRecommendServiceImpl
implements RemoteAdvertRecommendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAdvertRecommendServiceImpl.class);
    @Autowired
    private ShowAdvertRecommendService showAdvertRecommendService;
    @Autowired
    private InteractAdvertRecommendService interactAdvertRecommendService;
    @Autowired
    private DataHandleBo dataHandleBo;
    @Autowired
    private NewAdvertSupportService newAdvertSupportService;
    @Resource
    private StringRedisTemplate nezhaStringRedisTemplate;
    private static String ip;

    public DubboResult<RcmdAdvertDto> recommend(ReqAdvertNewDto reqAdvertNewDto, String strategyId) {
        AdvertAlgEnum interactAdvertAlgEnum = Objects.requireNonNull(InteractAdvertAlgEnum.get((String)strategyId), "STRATEGY_ID_NOT_EXIST:" + strategyId);
        List<RcmdAdvertDto> rcmdAdvertDtos = this.doRecommend(reqAdvertNewDto, interactAdvertAlgEnum);
        if (!rcmdAdvertDtos.isEmpty()) {
            return DubboResult.successResult((Object)rcmdAdvertDtos.get(0));
        }
        return DubboResult.successResult(null);
    }

    public List<RcmdAdvertDto> batchRecommend(ReqAdvertNewDto reqAdvertNewDto, String strategyId) {
        AdvertAlgEnum advertAlgEnum = Optional.ofNullable(InteractAdvertAlgEnum.get((String)strategyId)).orElse(ShowAdvertAlgEnum.get((String)strategyId));
        Objects.requireNonNull(advertAlgEnum, "STRATEGY_ID_NOT_EXIST:" + strategyId);
        return this.doRecommend(reqAdvertNewDto, advertAlgEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RcmdAdvertDto> doRecommend(ReqAdvertNewDto reqAdvertNewDto, AdvertAlgEnum advertAlgEnum) {
        try {
            AdvertType advertType;
            AbstractAdvertRecommendService abstractAdvertRecommendService;
            RecommendType recommendType;
            this.checkParam(reqAdvertNewDto);
            if (!(advertAlgEnum instanceof ShowAdvertAlgEnum)) {
                recommendType = RecommendType.INTERACT;
                abstractAdvertRecommendService = this.interactAdvertRecommendService;
                advertType = AdvertType.INTERACT;
            } else {
                recommendType = RecommendType.SHOW;
                abstractAdvertRecommendService = this.showAdvertRecommendService;
                advertType = AdvertType.SHOW;
            }
            DBTimeProfile.enter((String)(recommendType.getDesc() + "Recommend:" + advertAlgEnum.getType()));
            Cat.logMetricForCount((String)advertAlgEnum.toString());
            AdvertRecommendRequestVo advertRecommendRequestVo = new AdvertRecommendRequestVo();
            advertRecommendRequestVo.setIp(ip);
            advertRecommendRequestVo.setAdvertAlgEnum(advertAlgEnum);
            abstractAdvertRecommendService.prepareStrategyParameter(advertRecommendRequestVo);
            List advertList = reqAdvertNewDto.getAdvertList();
            Boolean invokeWeakFilter = advertRecommendRequestVo.getInvokeWeakFilter();
            RecommendMaterialType recommendMaterialType = advertRecommendRequestVo.getRecommendMaterialType();
            HashMap<Long, Advert> advertMap = new HashMap<Long, Advert>(advertList.size());
            HashSet<OrientationPackage> orientationPackages = new HashSet<OrientationPackage>(advertList.size());
            AppDo appDo = AppDo.convert(reqAdvertNewDto.getAppDto());
            Long slotId = appDo.getSlotId();
            this.handleData(advertList, advertType, invokeWeakFilter, recommendMaterialType, advertMap, orientationPackages, slotId);
            if (orientationPackages.isEmpty()) {
                ArrayList<RcmdAdvertDto> arrayList = new ArrayList<RcmdAdvertDto>();
                return arrayList;
            }
            Collection<Advert> adverts = advertMap.values();
            advertRecommendRequestVo.setAdvertMap(advertMap);
            advertRecommendRequestVo.setAdvertOrientationPackages(orientationPackages);
            this.ffmHandle(advertRecommendRequestVo);
            ConsumerDo consumerDo = ConsumerDo.convert(reqAdvertNewDto.getConsumerDto());
            RequestDo requestDo = RequestDo.convert(reqAdvertNewDto.getRequestDto());
            ActivityDo activityDo = ActivityDo.convert(reqAdvertNewDto.getAdvertActivityDto());
            Long appId = appDo.getId();
            this.dataHandleBo.handleMergeData(adverts, appId);
            this.dataHandleBo.handleAdjustPriceFactor(orientationPackages, slotId, appId);
            this.dataHandleBo.handleStatisticData(adverts, orientationPackages, appId);
            this.dataHandleBo.handleHourlyData(adverts, appId);
            this.dataHandleBo.handleTagData(adverts, appId);
            advertRecommendRequestVo.setCommonInfo(appDo, consumerDo, requestDo, activityDo);
            advertRecommendRequestVo.setLowArpuThresholdValue(requestDo.getLowArpuThresholdValue());
            List<OrientationPackage> orientationPackageList = abstractAdvertRecommendService.recommend(advertRecommendRequestVo);
            List<RcmdAdvertDto> list = this.returnHandle(orientationPackageList, advertRecommendRequestVo);
            return list;
        }
        catch (Exception e) {
            LOGGER.error("advert recommend happened error :{},strategy:{}", (Object)e.getStackTrace(), (Object)advertAlgEnum.toString());
            ArrayList<RcmdAdvertDto> arrayList = new ArrayList<RcmdAdvertDto>();
            return arrayList;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private void ffmHandle(AdvertRecommendRequestVo advertRecommendRequestVo) {
        Set<OrientationPackage> advertOrientationPackages = advertRecommendRequestVo.getAdvertOrientationPackages();
        if (advertOrientationPackages.size() <= 50) {
            return;
        }
        ModelKeyEnum ctrModelKey = advertRecommendRequestVo.getCtrModelKey();
        ModelKeyEnum cvrModelKey = advertRecommendRequestVo.getCvrModelKey();
        if (ctrModelKey != null && ctrModelKey.getModelType().equals((Object)ModelType.FFM)) {
            advertRecommendRequestVo.setCtrModelKey(ModelKeyEnum.FTRL_FM_CTR_MODEL_v007);
        }
        if (cvrModelKey != null && cvrModelKey.getModelType().equals((Object)ModelType.FFM)) {
            advertRecommendRequestVo.setCvrModelKey(ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007);
        }
    }

    public void handleData(Collection<AdvertNewDto> advertList, AdvertType advertType, Boolean invokeWeakFilter, RecommendMaterialType recommendMaterialType, Map<Long, Advert> advertMap, Set<OrientationPackage> advertOrientationPackages, Long slotId) {
        HashMap<NewAdvertSupportService.BiddingKey, Long> countMap = new HashMap<NewAdvertSupportService.BiddingKey, Long>();
        advertList.forEach(advertDto -> {
            Long advertId = advertDto.getAdvertId();
            String newTradeTagNum = advertDto.getNewTradeTagNum();
            if (advertDto.getFee() <= 0L) {
                return;
            }
            OrientationPackage orientationPackage = OrientationPackage.convert(advertDto);
            if (invokeWeakFilter.booleanValue() && orientationPackage.isWeakTarget().booleanValue()) {
                return;
            }
            Advert advert = Optional.ofNullable(advertMap.get(advertId)).orElse(Advert.convert(advertDto, advertType));
            Set<Material> materials = recommendMaterialType.equals((Object)RecommendMaterialType.NONE) ? new HashSet<Material>() : Material.convert(advertDto);
            orientationPackage.setMaterials(materials);
            if (StringUtils.isNotEmpty((String)newTradeTagNum)) {
                BiddingStatDo biddingStatDo = this.getBiddingStatDo(slotId, countMap, advertId, newTradeTagNum, orientationPackage);
                orientationPackage.setBiddingStatDo(biddingStatDo);
            }
            Set<OrientationPackage> orientationPackages = advert.getOrientationPackages();
            orientationPackages.add(orientationPackage);
            advert.setOrientationPackages(orientationPackages);
            advertOrientationPackages.add(orientationPackage);
            advertMap.put(advertId, advert);
        });
        countMap.forEach((biddingKey, count) -> this.newAdvertSupportService.incrBidingCount((NewAdvertSupportService.BiddingKey)biddingKey, (long)count));
    }

    private BiddingStatDo getBiddingStatDo(Long slotId, Map<NewAdvertSupportService.BiddingKey, Long> countMap, Long advertId, String newTradeTagNum, OrientationPackage orientationPackage) {
        NewAdvertSupportService.BiddingKey advertKey = NewAdvertSupportService.BiddingKey.getAdvertKey(advertId, slotId);
        Long packageId = orientationPackage.getId();
        NewAdvertSupportService.BiddingKey advertAndOrientationKey = NewAdvertSupportService.BiddingKey.getAdvertAndOrientationKey(advertId, packageId, slotId);
        NewAdvertSupportService.BiddingKey slotKey = NewAdvertSupportService.BiddingKey.getSlotKey(slotId);
        NewAdvertSupportService.BiddingKey tradeAndSlotKey = NewAdvertSupportService.BiddingKey.getTradeAndSlotKey(slotId, newTradeTagNum);
        BiddingStatDo biddingStatDo = new BiddingStatDo();
        biddingStatDo.setAdvertId(advertId);
        biddingStatDo.setPlanId(packageId);
        biddingStatDo.setSlotId(slotId);
        BiddingRateDo advertBiddingRate = this.newAdvertSupportService.getBiddingRate(advertKey);
        BiddingRateDo advertAndOrientationBiddingRate = this.newAdvertSupportService.getBiddingRate(advertAndOrientationKey);
        BiddingRateDo slotBiddingRate = this.newAdvertSupportService.getBiddingRate(slotKey);
        BiddingRateDo tradeAndSlotBiddingRate = this.newAdvertSupportService.getBiddingRate(tradeAndSlotKey);
        biddingStatDo.setAdvertBiddingRateDo(advertBiddingRate);
        biddingStatDo.setAdvertAndPlanBiddingRateDo(advertAndOrientationBiddingRate);
        biddingStatDo.setTradeBiddingBiddingRateDo(tradeAndSlotBiddingRate);
        biddingStatDo.setGlobalBiddingBiddingRateDo(slotBiddingRate);
        Long advertCount = countMap.getOrDefault(advertKey, 0L);
        Long advertAndOrientationCount = countMap.getOrDefault(advertAndOrientationKey, 0L);
        Long slotCount = countMap.getOrDefault(slotKey, 0L);
        Long tradeAndSlotCount = countMap.getOrDefault(tradeAndSlotKey, 0L);
        Long l = advertCount;
        Long l2 = advertCount = Long.valueOf(advertCount + 1L);
        l = advertAndOrientationCount;
        l2 = advertAndOrientationCount = Long.valueOf(advertAndOrientationCount + 1L);
        l = slotCount;
        l2 = slotCount = Long.valueOf(slotCount + 1L);
        l = tradeAndSlotCount;
        l2 = tradeAndSlotCount = Long.valueOf(tradeAndSlotCount + 1L);
        countMap.put(advertKey, advertCount);
        countMap.put(advertAndOrientationKey, advertAndOrientationCount);
        countMap.put(slotKey, slotCount);
        countMap.put(tradeAndSlotKey, tradeAndSlotCount);
        return biddingStatDo;
    }

    private void checkParam(ReqAdvertNewDto req) {
        boolean pass = true;
        try {
            AppDto appDto = req.getAppDto();
            ConsumerDto consumerDto = req.getConsumerDto();
            AdvertActivityDto advertActivityDto = req.getAdvertActivityDto();
            RequestDto requestDto = req.getRequestDto();
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{appDto, consumerDto, advertActivityDto, requestDto})) {
                LOGGER.warn(" paramCheck 0 error, req = [{}], please check the req ", (Object)req);
                pass = false;
            }
            Long appId = appDto.getAppId();
            Long consumerId = consumerDto.getConsumerId();
            Long operatingActivityId = advertActivityDto.getOperatingActivityId();
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{consumerId, appId, operatingActivityId})) {
                LOGGER.warn(" paramCheck 1 error, req = [{}], please check the req ", (Object)req);
                pass = false;
            }
            String ua = requestDto.getUa();
            String ip = requestDto.getIp();
            List orderIds = requestDto.getOrderIds();
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{ua, ip, orderIds})) {
                LOGGER.warn("paramCheck 2 error, req = [{}], please check the req ", (Object)req);
                pass = false;
            }
        }
        catch (Exception e) {
            LOGGER.error("paramCheck happened error :{}", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            LOGGER.warn("req is invalid", (Object)ResultCodeEnum.PARAMS_INVALID.getDesc());
            throw new RecommendEngineException("req is invalid");
        }
    }

    private List<RcmdAdvertDto> returnHandle(List<OrientationPackage> orientationPackages, AdvertRecommendRequestVo advertRecommendRequestVo) {
        Map<Long, Advert> advertMap = advertRecommendRequestVo.getAdvertMap();
        Boolean interactAdvert = advertRecommendRequestVo.getAdvertAlgEnum() instanceof InteractAdvertAlgEnum;
        RequestDo requestDo = advertRecommendRequestVo.getRequestDo();
        Double lowArpuThresholdValue = advertRecommendRequestVo.getLowArpuThresholdValue();
        List<String> orderIds = requestDo.getOrderIds();
        Long needCount = requestDo.getNeedCount();
        Long startCount = requestDo.getStartCount();
        if (interactAdvert.booleanValue()) {
            needCount = needCount + 9L;
        }
        Map<Boolean, List<OrientationPackage>> orientationPackageMap = orientationPackages.stream().collect(Collectors.partitioningBy(OrientationPackage::getGiveUp));
        List giveUpOrientationPackageList = orientationPackageMap.getOrDefault(true, new ArrayList());
        List onTargetOrientationPackageList = orientationPackageMap.getOrDefault(false, new ArrayList());
        if (onTargetOrientationPackageList.isEmpty()) {
            return new ArrayList<RcmdAdvertDto>();
        }
        List selectOrientationPackages = onTargetOrientationPackageList.stream().collect(Collectors.groupingBy(OrientationPackage::getRankScore, Collectors.collectingAndThen(Collectors.toList(), this::getRandomOne))).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey).reversed()).limit(needCount).map(Map.Entry::getValue).collect(Collectors.toList());
        Double topOneRankScore = ((OrientationPackage)selectOrientationPackages.get(0)).getRankScore();
        Optional<OrientationPackage> giveUpTopOneOrientationPackage = giveUpOrientationPackageList.stream().filter(advertResortVo -> advertResortVo.getFlowTag().equals(1L)).filter(advertResortVo -> advertResortVo.getRankScore() >= topOneRankScore).max(Comparator.comparing(OrientationPackage::getRankScore));
        ArrayList<OrientationPackage> needLogPackageList = new ArrayList<OrientationPackage>(selectOrientationPackages.size() + 1);
        SmoothFusePackage smoothFusePackage = null;
        if (giveUpTopOneOrientationPackage.isPresent()) {
            OrientationPackage giveOrientationPackage2 = giveUpTopOneOrientationPackage.get();
            needLogPackageList.add(giveOrientationPackage2);
            if (giveOrientationPackage2.getSmoothFuse().booleanValue()) {
                smoothFusePackage = new SmoothFusePackage();
                Long finalFee = giveOrientationPackage2.getFinalFee();
                Double ctr = giveOrientationPackage2.getCtr();
                double arpu = BigDecimal.valueOf((double)finalFee.longValue() * ctr).setScale(2, RoundingMode.HALF_UP).doubleValue();
                smoothFusePackage.setAdvertId(giveOrientationPackage2.getAdvertId());
                smoothFusePackage.setArpu(arpu);
            }
        }
        giveUpTopOneOrientationPackage.ifPresent(giveOrientationPackage -> {});
        Map<FeatureIndex, Map<String, String>> featureMap = advertRecommendRequestVo.getFeatureMap();
        ArrayList<RcmdAdvertDto> adverts = new ArrayList<RcmdAdvertDto>();
        int advertSize = selectOrientationPackages.size();
        if (interactAdvert.booleanValue() && advertSize >= 2) {
            advertSize = 1;
        }
        for (int i = 0; i < advertSize; ++i) {
            Integer finalLowArpu;
            OrientationPackage orientationPackage2 = (OrientationPackage)selectOrientationPackages.get(i);
            RcmdAdvertDto rcmdAdvertDto = new RcmdAdvertDto();
            Long advertId = orientationPackage2.getAdvertId();
            Long packageId = orientationPackage2.getId();
            rcmdAdvertDto.setOriginalAdvertId(advertId);
            Advert advert = advertMap.get(advertId);
            Set<Long> backupAdvertIds = advert.getBackupAdvertIds();
            if (!backupAdvertIds.isEmpty()) {
                rcmdAdvertDto.setNeedReplace(Boolean.valueOf(true));
                Long backupAdvertId = new ArrayList<Long>(backupAdvertIds).get(0);
                orientationPackage2 = orientationPackages.stream().filter(orientationPackage1 -> orientationPackage1.getAdvertId().equals(backupAdvertId)).findAny().orElse(orientationPackage2);
            }
            Integer chargeType = orientationPackage2.getChargeType();
            String orderId = orderIds.get(i);
            orientationPackage2.setOrderId(orderId);
            needLogPackageList.add(orientationPackage2);
            Long materialId = orientationPackage2.getMaterials().stream().findAny().map(Material::getId).orElse(null);
            FeatureIndex featureIndex = new FeatureIndex(advertId, packageId, materialId);
            rcmdAdvertDto.setOrderId(orderId);
            rcmdAdvertDto.setAdvertId(advertId);
            rcmdAdvertDto.setPackageId(packageId);
            rcmdAdvertDto.setMaterialId(materialId);
            rcmdAdvertDto.setCtr(orientationPackage2.getCtr());
            rcmdAdvertDto.setStatCtr(orientationPackage2.getStatCtr());
            rcmdAdvertDto.setPreCtr(orientationPackage2.getPreCtr());
            rcmdAdvertDto.setCvr(orientationPackage2.getCvr());
            rcmdAdvertDto.setStatCvr(orientationPackage2.getStatCvr());
            rcmdAdvertDto.setPreCvr(orientationPackage2.getPreCvr());
            rcmdAdvertDto.setFee(orientationPackage2.getFinalFee());
            rcmdAdvertDto.setTag(orientationPackage2.getFlowTag());
            rcmdAdvertDto.setRecommendApps(advertRecommendRequestVo.getRecommendApps());
            rcmdAdvertDto.setFusingOrientationPackages(new HashSet<FusingOrientationPackageDto>(advertRecommendRequestVo.getFusingOrientationPackages()));
            rcmdAdvertDto.setSupportSuccess(orientationPackage2.getSupportSuccess());
            rcmdAdvertDto.setSupportWeight(orientationPackage2.getSupportWeight());
            rcmdAdvertDto.setAdjustPriceFactor(orientationPackage2.getAdjustPriceFactor());
            if (orientationPackage2.getSmoothResultDo() != null && orientationPackage2.getSmoothResultDo().getSmoothFactor() != null) {
                rcmdAdvertDto.setSmoothFactor(orientationPackage2.getSmoothResultDo().getSmoothFactor());
            }
            if (advert.getCanReplaceLowArpu().equals(1)) {
                finalLowArpu = this.isFanlLowArpu(orientationPackage2, lowArpuThresholdValue);
                if (finalLowArpu.equals(1)) {
                    rcmdAdvertDto.setFinalLowArpu(finalLowArpu);
                    adverts.add(rcmdAdvertDto);
                    continue;
                }
            } else {
                finalLowArpu = 0;
            }
            rcmdAdvertDto.setFinalLowArpu(finalLowArpu);
            adverts.add(rcmdAdvertDto);
            this.incrSupportCount(orientationPackage2);
            if (PerfTestContext.isCurrentInPerfTestMode()) continue;
            long finalStartCount = startCount + (long)i;
            Optional.ofNullable(featureMap.get(featureIndex)).ifPresent(feature -> {
                feature.put("time", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
                feature.put("orderId", orderId);
                feature.put("advertId", String.valueOf(advertId));
                feature.put("f8807", Long.toString(finalStartCount));
                feature.put("chargeType", Long.toString(chargeType.intValue()));
                BaseInnerLog.log(feature);
            });
        }
        if (selectOrientationPackages.size() > 0) {
            OrientationPackage orientationPackage3 = (OrientationPackage)selectOrientationPackages.get(0);
            this.newAdvertSupportService.insertOutGoing(orientationPackage3, advertRecommendRequestVo.getAppDo().getSlotId());
        }
        if (interactAdvert.booleanValue() && selectOrientationPackages.size() >= 2) {
            List otherAdverts = selectOrientationPackages.stream().skip(1L).limit(9L).map(orientationPackage1 -> {
                RcmdAdvertDto otherAdvert = new RcmdAdvertDto();
                otherAdvert.setAdvertId(orientationPackage1.getAdvertId());
                otherAdvert.setPackageId(orientationPackage1.getId());
                otherAdvert.setCtr(orientationPackage1.getCtr());
                otherAdvert.setCvr(orientationPackage1.getCvr());
                otherAdvert.setFee(orientationPackage1.getFinalFee());
                return otherAdvert;
            }).collect(Collectors.toList());
            adverts.addAll(otherAdverts);
        }
        Map<Long, NezhaStatDto> nezhaStatDtoMap = advertRecommendRequestVo.getNezhaStatDtoMap();
        Map<Long, Double> ctrReconstructionFactorMap = advertRecommendRequestVo.getCtrReconstructionFactorMap();
        Map<Long, Double> cvrReconstructionFactorMap = advertRecommendRequestVo.getCvrReconstructionFactorMap();
        Map<Long, Double> ctrCorrectionFactorMap = advertRecommendRequestVo.getCtrCorrectionFactorMap();
        Map<Long, Double> cvrCorrectionFactorMap = advertRecommendRequestVo.getCvrCorrectionFactorMap();
        Map<Long, AdvertStatFeatureDo> advertStatFeatureMap = advertRecommendRequestVo.getAdvertStatFeatureMap();
        needLogPackageList.forEach(orientationPackage -> {
            Integer finalLowArpu;
            BizLogEntity bizLogEntity = new BizLogEntity();
            bizLogEntity.setIp(advertRecommendRequestVo.getIp());
            bizLogEntity.setPredictCost(advertRecommendRequestVo.getPredictCost());
            bizLogEntity.setReleaseTarget(orientationPackage.getReleaseTarget());
            Long advertId = orientationPackage.getAdvertId();
            Advert advert = (Advert)advertMap.get(advertId);
            if (advert.getCanReplaceLowArpu() == 1 && (finalLowArpu = this.isFanlLowArpu((OrientationPackage)orientationPackage, lowArpuThresholdValue)).equals(1)) {
                return;
            }
            Long packageId = orientationPackage.getId();
            Long materialId = orientationPackage.getMaterials().stream().findAny().map(Material::getId).orElse(null);
            Double ctr = orientationPackage.getCtr();
            Long finalFee = orientationPackage.getFinalFee();
            bizLogEntity.setTime(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            String orderId = Optional.ofNullable(orientationPackage.getOrderId()).orElse(requestDo.getOrderId());
            bizLogEntity.setOrderId(orderId);
            bizLogEntity.setAlgType(advertRecommendRequestVo.getAdvertAlgEnum().getType());
            bizLogEntity.setAdvertId(advertId);
            bizLogEntity.setPackageId(packageId);
            bizLogEntity.setPackageType(orientationPackage.getPackageType());
            bizLogEntity.setTargetAppLimit(orientationPackage.getTargetAppLimit());
            bizLogEntity.setMaterialId(materialId);
            bizLogEntity.setFee(finalFee);
            bizLogEntity.setOriginalFee(orientationPackage.getOriginalFee());
            bizLogEntity.setNew(advert.isNew());
            bizLogEntity.setCount(advert.getCurrentCount());
            bizLogEntity.setChargeType(orientationPackage.getChargeType());
            bizLogEntity.setDiscountRate(advert.getDiscountRate());
            bizLogEntity.setAdvertWeight(advert.getWeight());
            AppDo appDo = advertRecommendRequestVo.getAppDo();
            bizLogEntity.setAppId(appDo.getId());
            bizLogEntity.setSlotIndustryTagId(appDo.getSlotIndustryTagId());
            bizLogEntity.setSlotIndustryTagPid(appDo.getSlotIndustryTagPid());
            bizLogEntity.setAppIndustryTagId(appDo.getIndustryTagId());
            bizLogEntity.setAppIndustryTagPid(appDo.getIndustryTagPid());
            bizLogEntity.setTrafficTagId(appDo.getTrafficTagId());
            bizLogEntity.setTrafficTagPid(appDo.getTrafficTagPid());
            bizLogEntity.setFactor(orientationPackage.getAdjustPriceFactor());
            bizLogEntity.setStatCtr(orientationPackage.getStatCtr());
            bizLogEntity.setStatCvr(orientationPackage.getStatCvr());
            bizLogEntity.setPreCtr(orientationPackage.getPreCtr());
            bizLogEntity.setPreCvr(orientationPackage.getPreCvr());
            bizLogEntity.setBackendType(orientationPackage.getCvrType().toString());
            bizLogEntity.setCtr(ctr);
            bizLogEntity.setCvr(orientationPackage.getCvr());
            bizLogEntity.setArpu(BigDecimal.valueOf((double)finalFee.longValue() * ctr).setScale(2, RoundingMode.HALF_UP).doubleValue());
            bizLogEntity.setNotFreeAdvertNum(advertMap.size());
            bizLogEntity.setBiddingAdvertNum(advertMap.size());
            bizLogEntity.setTagWeight(advert.getWeight());
            bizLogEntity.setTag(orientationPackage.getFlowTag());
            bizLogEntity.setQualityLevel(orientationPackage.getQualityLevel());
            bizLogEntity.setSimpleSupportType(orientationPackage.getSimpleSupportType());
            bizLogEntity.setRankScore(orientationPackage.getRankScore());
            bizLogEntity.setqScore(orientationPackage.getqScore());
            bizLogEntity.setRank(orientationPackage.getRank());
            if (orientationPackage.getSmoothResultDo() != null && orientationPackage.getSmoothResultDo().getSmoothFactor() != null) {
                bizLogEntity.setSmoothFactor(orientationPackage.getSmoothResultDo().getSmoothFactor());
            }
            bizLogEntity.setBiddingStatDo(orientationPackage.getBiddingStatDo());
            bizLogEntity.setActivityId(advertRecommendRequestVo.getActivityDo().getOperatingId());
            Integer activityUseType = advertRecommendRequestVo.getActivityDo().getUseType();
            Long slotId = appDo.getSlotId();
            if (activityUseType.equals(0) || activityUseType.equals(1)) {
                bizLogEntity.setDuibaSlotId(slotId);
            } else {
                bizLogEntity.setSlotId(slotId);
            }
            bizLogEntity.setCtrCorrectionFactor((Double)ctrCorrectionFactorMap.get(advertId));
            bizLogEntity.setCvrCorrectionFactor((Double)cvrCorrectionFactorMap.get(advertId));
            bizLogEntity.setCtrReconstructionFactor((Double)ctrReconstructionFactorMap.get(advertId));
            bizLogEntity.setCvrReconstructionFactor((Double)cvrReconstructionFactorMap.get(advertId));
            Optional.ofNullable(nezhaStatDtoMap.get(advertId)).ifPresent(nezhaStatDto -> {
                bizLogEntity.setPreCtrAvg(nezhaStatDto.getPreCtrAvg());
                bizLogEntity.setPreCvrAvg(nezhaStatDto.getPreCvrAvg());
                bizLogEntity.setStatCtrAvg(nezhaStatDto.getStatCtrAvg());
                bizLogEntity.setStatCvrAvg(nezhaStatDto.getStatCvrAvg());
            });
            Optional.ofNullable(advertStatFeatureMap.get(advertId)).ifPresent(statFeatureDo -> {
                bizLogEntity.setAdvertCtr(statFeatureDo.getAdvertCtr());
                bizLogEntity.setAdvertCvr(statFeatureDo.getAdvertCvr());
                bizLogEntity.setAdvertAppCtr(statFeatureDo.getAdvertAppCtr());
                bizLogEntity.setAdvertAppCvr(statFeatureDo.getAdvertAppCvr());
                bizLogEntity.setAdvertSlotCtr(statFeatureDo.getAdvertSlotCtr());
                bizLogEntity.setAdvertSlotCvr(statFeatureDo.getAdvertSlotCvr());
                bizLogEntity.setAdvertActivityCtr(statFeatureDo.getAdvertActivityCtr());
                bizLogEntity.setAdvertActivityCvr(statFeatureDo.getAdvertActivityCvr());
            });
            if (PerfTestContext.isCurrentInPerfTestMode()) {
                return;
            }
            BaseInnerLog.log(bizLogEntity);
        });
        return adverts;
    }

    public Integer isFanlLowArpu(OrientationPackage orientationPackage, Double lowArpuThresholdValue) {
        BigDecimal arpu = BigDecimal.valueOf((double)orientationPackage.getFinalFee().longValue() * orientationPackage.getCtr()).setScale(2, RoundingMode.HALF_UP);
        Integer finalLowArpu = arpu.compareTo(BigDecimal.valueOf(lowArpuThresholdValue)) < 0 ? Integer.valueOf(1) : Integer.valueOf(0);
        return finalLowArpu;
    }

    private <T> T getRandomOne(List<T> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(new Random().nextInt(list.size()));
    }

    private void incrSupportCount(OrientationPackage orientationPackage) {
        if (orientationPackage.getRank().equals(orientationPackage.getReRank())) {
            return;
        }
        Long advertId = orientationPackage.getAdvertId();
        String supportCountKey = RedisKeyUtil.getSupportCount((Long)advertId);
        Long increment = this.nezhaStringRedisTemplate.opsForValue().increment((Object)supportCountKey, 1L);
        LOGGER.info("advert :{}, support count :{}", (Object)advertId, (Object)increment);
        if (increment.equals(1L)) {
            this.nezhaStringRedisTemplate.expire((Object)supportCountKey, (long)DateUtils.getToTomorrowSeconds() + (long)new Random().nextInt(100), TimeUnit.SECONDS);
        }
    }

    static {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (!networkInterface.getName().equals("eth0")) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!(inetAddress instanceof Inet4Address)) continue;
                ipList.add(inetAddress.getHostAddress());
            }
        }
        if (!ipList.isEmpty()) {
            ip = (String)ipList.get(0);
        }
    }
}

