/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service;

import cn.com.duiba.nezha.engine.biz.service.BaseService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

public abstract class CacheService
extends BaseService {
    protected static final DateTimeFormatter HOUR_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHH");
    protected static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    @Resource
    protected StringRedisTemplate nezhaStringRedisTemplate;
    @Autowired
    protected ExecutorService executorService;
    protected LoadingCache<String, List<String>> last6DayTimestampCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(60L).build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(String key) throws Exception {
            return Stream.iterate(LocalDate.now(), day -> day.minusDays(1L)).skip(1L).limit(6L).map(localDate -> localDate.format(DAY_FORMATTER)).collect(Collectors.toList());
        }
    });
    protected LoadingCache<String, List<String>> hourlyTimestampCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(48L).build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(String key) throws Exception {
            return Stream.iterate(LocalDateTime.of(LocalDate.now(), LocalTime.MIN), time -> time.plusHours(1L)).limit(24L).map(localDateTime -> localDateTime.format(HOUR_FORMATTER)).collect(Collectors.toList());
        }
    });

    public static class CacheInfo {
        private Long size;
        private Double hitRate;
        private Double averageLoadPenalty;

        public CacheInfo(Long size, Double hitRate, Double averageLoadPenalty) {
            this.size = size;
            this.hitRate = hitRate;
            this.averageLoadPenalty = averageLoadPenalty;
        }

        public Long getSize() {
            return this.size;
        }

        public Double getHitRate() {
            return this.hitRate;
        }

        public Double getAverageLoadPenalty() {
            return this.averageLoadPenalty;
        }

        public static CacheInfo generate(LoadingCache cache) {
            return new CacheInfo(cache.size(), cache.stats().hitRate(), cache.stats().averageLoadPenalty() * 1.0E-5);
        }
    }

    public static class CacheDuration {
        private Long duration;
        private TimeUnit timeUnit;

        public CacheDuration(Long duration, TimeUnit timeUnit) {
            this.duration = duration;
            this.timeUnit = timeUnit;
        }

        public Long getDuration() {
            return this.duration;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }
    }
}

