/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr.impl;

import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.mergeData.MergeData;
import cn.com.duiba.nezha.engine.biz.enums.MergeDataType;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertMergeStatService;
import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertMergeStatServiceImpl
extends CacheService
implements AdvertMergeStatService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertMergeStatService.class);
    private static final Long TIMES_GLOBAL = 1L;
    private LoadingCache<AdvertMergeStatService.AdvertMergeDataQuery, MergeData> advertMergeStatCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).recordStats().build((CacheLoader)new CacheLoader<AdvertMergeStatService.AdvertMergeDataQuery, MergeData>(){

        public MergeData load(AdvertMergeStatService.AdvertMergeDataQuery key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<AdvertMergeStatService.AdvertMergeDataQuery, MergeData> loadAll(Iterable<? extends AdvertMergeStatService.AdvertMergeDataQuery> queries) {
            Map queryKeyMap = StreamSupport.stream(queries.spliterator(), false).collect(Collectors.toMap(Function.identity(), query -> RedisKeyUtil.advertMergeStatKey((Long)query.getAppId(), (Long)query.getAdvertId(), (Long)query.getMaterialId(), (Long)query.getTimes())));
            Map keyDataMap = StringRedisHelper.of((StringRedisTemplate)AdvertMergeStatServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(queryKeyMap.values(), MergeData.class, MergeData::new);
            Map queryMergeDataMap = MapUtils.translate(queryKeyMap, (Map)keyDataMap);
            queryMergeDataMap.forEach((query, data) -> {
                data.setAdvertId(query.getAdvertId());
                data.setAppId(query.getAppId());
                data.setMaterialId(query.getMaterialId());
                data.setTimes(query.getTimes());
            });
            return queryMergeDataMap;
        }
    });

    @Override
    public List<MergeData> getMaterialDataInApp(Long advertId, Long appId, List<Long> materialIds) {
        try {
            DBTimeProfile.enter((String)"getMaterialDataInApp");
            if (AssertUtil.isEmpty(materialIds)) {
                ArrayList<MergeData> arrayList = new ArrayList<MergeData>();
                return arrayList;
            }
            List queries = materialIds.stream().map(materialId -> AdvertMergeStatService.AdvertMergeDataQuery.newBuilder().advertId(advertId).materialId((Long)materialId).appId(appId).times(TIMES_GLOBAL).build()).collect(Collectors.toList());
            ArrayList arrayList = Lists.newArrayList((Iterable)this.advertMergeStatCache.getAll(queries).values());
            return arrayList;
        }
        catch (Exception e) {
            throw new RecommendEngineException("get materialDataInApp error", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Map<MergeDataType, List<MergeData>> getAdvertAndAppData(Collection<Advert> adverts, Long appId) {
        try {
            ArrayList queries = new ArrayList(adverts.size() * 2);
            ArrayList appQueries = new ArrayList(adverts.size());
            ArrayList globalQueries = new ArrayList(adverts.size());
            adverts.forEach(advert -> {
                Long id = advert.getId();
                Long launchCountToUser = advert.getCurrentCount();
                AdvertMergeStatService.AdvertMergeDataQuery advertAppStatQuery = AdvertMergeStatService.AdvertMergeDataQuery.newBuilder().advertId(id).appId(appId).times(launchCountToUser).build();
                AdvertMergeStatService.AdvertMergeDataQuery advertGlobalStatQuery = AdvertMergeStatService.AdvertMergeDataQuery.newBuilder().advertId(id).times(launchCountToUser).build();
                queries.add(advertAppStatQuery);
                queries.add(advertGlobalStatQuery);
                appQueries.add(advertAppStatQuery);
                globalQueries.add(advertGlobalStatQuery);
            });
            ImmutableMap all = this.advertMergeStatCache.getAll(queries);
            EnumMap<MergeDataType, List<MergeData>> map = new EnumMap<MergeDataType, List<MergeData>>(MergeDataType.class);
            List appStatDoList = appQueries.stream().map(arg_0 -> ((ImmutableMap)all).get(arg_0)).collect(Collectors.toList());
            List globalStatDoList = globalQueries.stream().map(arg_0 -> ((ImmutableMap)all).get(arg_0)).collect(Collectors.toList());
            map.put(MergeDataType.APP, appStatDoList);
            map.put(MergeDataType.GLOBAL, globalStatDoList);
            return map;
        }
        catch (Exception e) {
            this.logger.error("advertMergeData error :{}", (Throwable)e);
            throw new RecommendEngineException("get advertMergeData error", e);
        }
    }

    @Override
    public Map<String, CacheService.CacheInfo> getCacheInfo() {
        HashMap<String, CacheService.CacheInfo> cacheInfoMap = new HashMap<String, CacheService.CacheInfo>();
        cacheInfoMap.put("advertMergeDataCache", CacheService.CacheInfo.generate(this.advertMergeStatCache));
        return cacheInfoMap;
    }
}

