/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.feature.impl;

import cn.com.duiba.nezha.engine.biz.domain.ActivityFeatureDo;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ActivityFeatureService;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ActivityFeatureServiceImpl
implements ActivityFeatureService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityFeatureService.class);
    @Resource
    private StringRedisTemplate nezhaStringRedisTemplate;
    private LoadingCache<Long, ActivityFeatureDo> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<Long, ActivityFeatureDo>(){

        public ActivityFeatureDo load(Long key) throws Exception {
            return ActivityFeatureServiceImpl.this.getFromRedis(key);
        }
    });

    private ActivityFeatureDo getFromRedis(Long activityId) {
        String activityFeatureKey = RedisKeyUtil.getActivityFeatureKey((Long)activityId);
        return Optional.ofNullable(this.nezhaStringRedisTemplate.opsForValue().get((Object)activityFeatureKey)).map(json -> (ActivityFeatureDo)JSON.parseObject((String)json, ActivityFeatureDo.class)).orElse(ActivityFeatureDo.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityFeatureDo get(Long activityId) {
        try {
            DBTimeProfile.enter((String)"getActivityFeature");
            ActivityFeatureDo activityFeatureDo = (ActivityFeatureDo)this.cache.get((Object)activityId);
            return activityFeatureDo;
        }
        catch (Exception e) {
            logger.error("get activityFeature happened:{}", (Throwable)e);
            ActivityFeatureDo activityFeatureDo = ActivityFeatureDo.DEFAULT;
            return activityFeatureDo;
        }
        finally {
            DBTimeProfile.release();
        }
    }
}

