/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.material.impl;

import cn.com.duiba.nezha.engine.biz.service.advert.material.AdvertMaterialService;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertMaterialServiceImpl
implements AdvertMaterialService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertMaterialServiceImpl.class);
    @Resource(name="nezhaStringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;
    private LoadingCache<String, List<Long>> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, List<Long>>(){

        public List<Long> load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, List<Long>> loadAll(Iterable<? extends String> keys) throws Exception {
            return AdvertMaterialServiceImpl.this.loadAllRecord(keys);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, List<Long>> getMaterialRankList(Long appId, Collection<Long> advertIds) {
        try {
            DBTimeProfile.enter((String)"getMaterialRankList");
            Map advertKeyMap = advertIds.stream().collect(Collectors.toMap(Function.identity(), advertId -> RedisKeyUtil.materialRankList((Long)appId, (Long)advertId)));
            Map map = MapUtils.translate(advertKeyMap, (Map)this.cache.getAll(advertKeyMap.values()));
            return map;
        }
        catch (Exception e) {
            LOGGER.error("load material rank list error:{}", (Throwable)e);
            HashMap<Long, List<Long>> hashMap = new HashMap<Long, List<Long>>();
            return hashMap;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<String, List<Long>> loadAllRecord(Iterable<? extends String> ks) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        ArrayList keys = Lists.newArrayList(ks);
        List record = this.stringRedisTemplate.opsForValue().multiGet((Collection)keys);
        if (CollectionUtils.isEmpty((Collection)record)) {
            return map;
        }
        map = new HashMap(record.size());
        for (int index = 0; index < record.size(); ++index) {
            String key = (String)keys.get(index);
            String value = (String)record.get(index);
            if (StringUtils.isNotBlank((String)value)) {
                map.put(key, JSON.parseArray((String)value, Long.class));
                continue;
            }
            map.put(key, Collections.emptyList());
        }
        return map;
    }
}

