/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.rerank;

import cn.com.duiba.nezha.engine.api.enums.AdvertMaterialGroupTypeEnum;
import cn.com.duiba.nezha.engine.api.enums.ResultCodeEnum;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.support.advert.ComparatorAdvertMaterialResortVo;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertMaterialResortGroupVo;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertMaterialResortVo;
import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdvertMaterialReRankService {
    private static final Logger logger = LoggerFactory.getLogger(AdvertMaterialReRankService.class);

    public List<AdvertMaterialResortGroupVo> reRank(List<AdvertMaterialResortGroupVo> inputVoList, Long oldMaterialTraffic, Long oldMaterialRatio) {
        List<AdvertMaterialResortGroupVo> retVoList = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{inputVoList, oldMaterialTraffic, oldMaterialRatio})) {
            logger.warn("reRank param cheak invalid", (Object)ResultCodeEnum.PARAMS_INVALID.getDesc());
            return retVoList;
        }
        try {
            for (AdvertMaterialResortGroupVo resortGroupVo : inputVoList) {
                if (resortGroupVo.getMaterialGroupId() == AdvertMaterialGroupTypeEnum.WITH_WEIGHT_MATERIAL_TYPE.getIndex()) {
                    resortGroupVo.setMaterialGroupTraffic(oldMaterialTraffic);
                    resortGroupVo.getMaterialResortVoList().sort(new ComparatorAdvertMaterialResortVo());
                    Double threshold = resortGroupVo.getMaterialResortVoList().get(0).getRankScore() * (double)oldMaterialRatio.longValue() / 100.0;
                    this.assignRank(resortGroupVo, threshold);
                }
                if (resortGroupVo.getMaterialGroupId() != AdvertMaterialGroupTypeEnum.WITHOUT_WEIGHT_MATERIAL_TYPE.getIndex()) continue;
                resortGroupVo.setMaterialGroupTraffic(100L - oldMaterialTraffic);
                for (AdvertMaterialResortVo vo : resortGroupVo.getMaterialResortVoList()) {
                    vo.setWeight(1.0);
                }
            }
            retVoList = inputVoList;
        }
        catch (Exception e) {
            logger.error("reRank happen error:{}", (Throwable)e);
            throw new RecommendEngineException("reRank happen error", e);
        }
        return retVoList;
    }

    private void assignRank(AdvertMaterialResortGroupVo resortGroupVo, Double threshold) {
        long rank = 0L;
        for (AdvertMaterialResortVo vo : resortGroupVo.getMaterialResortVoList()) {
            vo.setRank(rank++);
            if (!(vo.getRankScore() >= threshold)) continue;
            vo.setWeight(vo.getRankScore());
        }
    }
}

