/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.support;

import cn.com.duiba.nezha.alg.alg.alg.NewAdvertSupportAlg;
import cn.com.duiba.nezha.alg.alg.vo.AdvertSupportInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.BiddingStatDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SupportDo;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertSupportService
extends CacheService {
    private LoadingCache<String, AdvertStatDo> packageDataCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, AdvertStatDo>(){

        public AdvertStatDo load(String s) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)AdvertSupportService.this.nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
        }
    });
    private LoadingCache<String, AdvertStatDo> slotPackageDataCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, AdvertStatDo>(){

        public AdvertStatDo load(String s) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)AdvertSupportService.this.nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
        }
    });

    public void support(Collection<OrientationPackage> orientationPackages, Long slotId) {
        try {
            Collection supportOrientationPackages = orientationPackages.stream().filter(OrientationPackage::getNeedSupportWeight).collect(Collectors.toList());
            HashMap<OrientationPackage, String> packageKeyMap = new HashMap<OrientationPackage, String>(supportOrientationPackages.size());
            HashMap<OrientationPackage, String> slotKeyMap = new HashMap<OrientationPackage, String>(supportOrientationPackages.size());
            for (OrientationPackage orientationPackage2 : supportOrientationPackages) {
                Long advertId = orientationPackage2.getAdvertId();
                Long packageId = orientationPackage2.getId();
                String today = LocalDate.now().format(DAY_FORMATTER);
                String packageKey = RedisKeyUtil.getOrientationPackageSupportData((Long)advertId, (Long)packageId, (String)today);
                String slotKey = RedisKeyUtil.getOrientationPackageSlotSupportData((Long)slotId, (Long)advertId, (Long)packageId, (String)today);
                packageKeyMap.put(orientationPackage2, packageKey);
                slotKeyMap.put(orientationPackage2, slotKey);
            }
            Map packageData = MapUtils.translate(packageKeyMap, (Map)this.packageDataCache.getAll(packageKeyMap.values()));
            Map slotPackageData = MapUtils.translate(slotKeyMap, (Map)this.slotPackageDataCache.getAll(slotKeyMap.values()));
            supportOrientationPackages.forEach(orientationPackage -> {
                AdvertSupportInfoDo advertSupportInfoDo = new AdvertSupportInfoDo();
                advertSupportInfoDo.setAdvertId(orientationPackage.getAdvertId());
                advertSupportInfoDo.setPlanId(orientationPackage.getId());
                advertSupportInfoDo.setaFee(orientationPackage.getAssessCost());
                Optional.ofNullable(packageData.get(orientationPackage)).ifPresent(advertStatDo -> {
                    advertSupportInfoDo.setConsume(advertStatDo.getChargeFees());
                    advertSupportInfoDo.setLandingPageClickPV(advertStatDo.getActClickCnt());
                });
                Optional.ofNullable(slotPackageData.get(orientationPackage)).ifPresent(advertStatDo -> {
                    advertSupportInfoDo.setSlotConsume(advertStatDo.getChargeFees());
                    advertSupportInfoDo.setSlotLandingPageClickPV(advertStatDo.getActClickCnt());
                });
                SupportDo supportDo = NewAdvertSupportAlg.circuitBreakerNew((AdvertSupportInfoDo)advertSupportInfoDo);
                if (supportDo == null || supportDo.getCircuitBreakerFactor() == null) {
                    orientationPackage.setSmoothFuse(true);
                    return;
                }
                Double supportWeight = NewAdvertSupportAlg.biddingFactor((SupportDo)supportDo, (BudgetSmoothDo)orientationPackage.getBudgetSmoothDo(), (BiddingStatDo)orientationPackage.getBiddingStatDo());
                orientationPackage.setSupportWeight(supportWeight);
            });
        }
        catch (Exception e) {
            this.logger.error("support error", (Throwable)e);
        }
    }
}

