/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.support;

import cn.com.duiba.nezha.engine.biz.support.Standardize;
import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Roulette {
    private static final Logger logger = LoggerFactory.getLogger(Roulette.class);
    private static Random rand = new Random();

    private Roulette() {
        throw new IllegalAccessError("Roulette class");
    }

    public static <T> T doubleMap(Map<T, Double> map) {
        if (AssertUtil.isEmpty(map)) {
            logger.warn("mapSample param is invalid", (Object)"params invalid");
            return null;
        }
        Double mapValueSum = 0.0;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            mapValueSum = mapValueSum + Math.max(entry.getValue(), 0.0);
        }
        Map<T, Double> mapStd = Standardize.mapValueNormalized(map);
        double r = rand.nextDouble();
        double w = 0.0;
        try {
            for (Map.Entry<T, Double> entry : mapStd.entrySet()) {
                if (!(r <= (w += entry.getValue().doubleValue()))) continue;
                return entry.getKey();
            }
        }
        catch (Exception e) {
            logger.error("mapSample happened error:{}", (Throwable)e);
        }
        return null;
    }

    public static <T> T longMap(Map<T, Long> map) {
        T ret = null;
        if (AssertUtil.isEmpty(map)) {
            logger.warn("mapSample param is invalid", (Object)"params invalid");
            return ret;
        }
        try {
            Map<T, Double> mapCopy = Standardize.mapValueLong2Double(map);
            ret = Roulette.doubleMap(mapCopy);
        }
        catch (Exception e) {
            logger.error("mapSample happened error:{}", (Throwable)e);
        }
        return ret;
    }
}

