/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.bo.advert;

import cn.com.duiba.nezha.alg.alg.alg.AutoBiddingAlg;
import cn.com.duiba.nezha.alg.alg.vo.AutoBiddingDo;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.AutoBiddingFactorIndex;
import cn.com.duiba.nezha.engine.biz.domain.OrientationPackageAdjustDiDO;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.HBaseResultCreater;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class AdvertAutoBiddingFactorService
extends CacheService {
    private static final String TABLE_NAME = "tuia_orientation_package_app_backend_adjust_di";
    private static final byte[] FAMILY = "cf".getBytes();
    @Autowired
    private HbaseTemplate hbaseTemplate;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private LoadingCache<AutoBiddingFactorIndex, AutoBiddingDo> autoBiddingFactorCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<AutoBiddingFactorIndex, AutoBiddingDo>(){

        public AutoBiddingDo load(AutoBiddingFactorIndex key) throws Exception {
            return (AutoBiddingDo)AdvertAutoBiddingFactorService.this.getAllAutoBiddingFactor(Lists.newArrayList((Object[])new AutoBiddingFactorIndex[]{key})).get(key);
        }

        public Map<AutoBiddingFactorIndex, AutoBiddingDo> loadAll(Iterable<? extends AutoBiddingFactorIndex> keys) {
            return AdvertAutoBiddingFactorService.this.getAllAutoBiddingFactor(keys);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<AutoBiddingFactorIndex, AutoBiddingDo> getOrientationPackageAdjustDis(Iterable<? extends AutoBiddingFactorIndex> keys) {
        Map<Boolean, List<String>> isAdvertRowkeysMap = this.getRowKeys(keys);
        List<String> advertRowKeys = isAdvertRowkeysMap.get(true);
        List<String> appRowKeys = isAdvertRowkeysMap.get(false);
        ArrayList allKeys = Lists.newArrayListWithCapacity((int)(advertRowKeys.size() + appRowKeys.size()));
        allKeys.addAll(advertRowKeys);
        allKeys.addAll(appRowKeys);
        ArrayList advertAdjustDiDOS = Lists.newArrayListWithCapacity((int)advertRowKeys.size());
        ArrayList advertAppAdjustDiDOS = Lists.newArrayListWithCapacity((int)appRowKeys.size());
        try {
            this.hbaseTemplate.execute(TABLE_NAME, table -> {
                List gets = allKeys.stream().map(rowKey -> new Get(rowKey.getBytes())).collect(Collectors.toList());
                DBTimeProfile.enter((String)"hbaseResourceGet");
                Result[] results = table.get(gets);
                for (int i = 0; i < results.length; ++i) {
                    Result result = results[i];
                    String rowKey2 = (String)allKeys.get(i);
                    Optional optionalDo = HBaseResultCreater.of((Result)result, OrientationPackageAdjustDiDO.class).build();
                    if (advertRowKeys.contains(rowKey2)) {
                        optionalDo.ifPresent(orientationPackageAdjustDiDO -> advertAdjustDiDOS.add(orientationPackageAdjustDiDO));
                        continue;
                    }
                    optionalDo.ifPresent(orientationPackageAdjustDiDO -> advertAppAdjustDiDOS.add(orientationPackageAdjustDiDO));
                }
                return null;
            });
            Map<AutoBiddingFactorIndex, AutoBiddingDo> map = this.handleOrientationPackageAdjustDis(keys, advertAdjustDiDOS, advertAppAdjustDiDOS);
            return map;
        }
        catch (Exception e) {
            this.logger.error("getOrientationPackageAdjustDis feature error:{} ", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
        return Maps.newHashMap();
    }

    private Map<AutoBiddingFactorIndex, AutoBiddingDo> handleOrientationPackageAdjustDis(Iterable<? extends AutoBiddingFactorIndex> keys, List<OrientationPackageAdjustDiDO> advertAdjustDiDOS, List<OrientationPackageAdjustDiDO> advertAppAdjustDiDOS) {
        HashMap resultMap = Maps.newHashMap();
        keys.forEach(index -> {
            Long advertId = index.getAdvertId();
            Long packageId = index.getPackageId();
            Long appId = index.getAppId();
            Long cvrType = index.getCvrType();
            Long depthCvrType = index.getDepthCvrType();
            Long convertCost = index.getConvertCost();
            OrientationPackageAdjustDiDO advertAppDOKey = OrientationPackageAdjustDiDO.newBuilder().advertId(advertId).appId(appId).baseType(cvrType).secondSubType(depthCvrType).build();
            OrientationPackageAdjustDiDO advertDOKey = OrientationPackageAdjustDiDO.newBuilder().advertId(advertId).appId(0L).baseType(cvrType).secondSubType(depthCvrType).build();
            AutoBiddingDo autoBiddingDo = new AutoBiddingDo();
            autoBiddingDo.setAdvertId(advertId);
            autoBiddingDo.setPlanId(packageId);
            autoBiddingDo.setAppId(appId);
            autoBiddingDo.setBaseType(cvrType);
            autoBiddingDo.setSecondSubType(depthCvrType);
            autoBiddingDo.setaFee(convertCost);
            Integer advertAppIndex = advertAppAdjustDiDOS.indexOf(advertAppDOKey);
            Integer advertIndex = advertAdjustDiDOS.indexOf(advertDOKey);
            if (-1 != advertAppIndex) {
                OrientationPackageAdjustDiDO advertAppPackageAdjustDiDO = (OrientationPackageAdjustDiDO)advertAppAdjustDiDOS.get(advertAppIndex);
                autoBiddingDo.setAdAndappBCvr(advertAppPackageAdjustDiDO.getbCvr());
                autoBiddingDo.setAdAndappBasePv(advertAppPackageAdjustDiDO.getBasePv());
            }
            if (-1 != advertIndex) {
                OrientationPackageAdjustDiDO advertPackageAdjustDiDO = (OrientationPackageAdjustDiDO)advertAdjustDiDOS.get(advertIndex);
                autoBiddingDo.setAdBCvr(advertPackageAdjustDiDO.getbCvr());
                autoBiddingDo.setAdBasePv(advertPackageAdjustDiDO.getBasePv());
            }
            resultMap.put(index, autoBiddingDo);
        });
        return resultMap;
    }

    private Map<Boolean, List<String>> getRowKeys(Iterable<? extends AutoBiddingFactorIndex> indexs) {
        ArrayList advertRowKeys = Lists.newArrayList();
        ArrayList appRowKeys = Lists.newArrayList();
        HashMap isAdvertRowkeysMap = Maps.newHashMap();
        for (AutoBiddingFactorIndex autoBiddingFactorIndex : indexs) {
            String advertAppkey = autoBiddingFactorIndex.getAdvertId() + "_" + autoBiddingFactorIndex.getAppId() + "_" + autoBiddingFactorIndex.getCvrType() + "_" + autoBiddingFactorIndex.getDepthCvrType();
            String appRowKey = DigestUtils.md5DigestAsHex((byte[])advertAppkey.getBytes()).substring(0, 4) + "-" + advertAppkey;
            appRowKeys.add(appRowKey);
            String advertkey = autoBiddingFactorIndex.getAdvertId() + "_0_" + autoBiddingFactorIndex.getCvrType() + "_" + autoBiddingFactorIndex.getDepthCvrType();
            String advertRowKey = DigestUtils.md5DigestAsHex((byte[])advertkey.getBytes()).substring(0, 4) + "-" + advertkey;
            advertRowKeys.add(advertRowKey);
        }
        isAdvertRowkeysMap.put(true, advertRowKeys);
        isAdvertRowkeysMap.put(false, appRowKeys);
        return isAdvertRowkeysMap;
    }

    public static void main(String[] args) {
        String advertAppkey = "38722_0_2_10";
        String appRowKey = DigestUtils.md5DigestAsHex((byte[])advertAppkey.getBytes()).substring(0, 4) + "-" + advertAppkey;
        System.out.println(appRowKey);
    }

    private Map<AutoBiddingFactorIndex, AutoBiddingDo> getAllAutoBiddingFactor(Iterable<? extends AutoBiddingFactorIndex> keys) {
        try {
            Map<AutoBiddingFactorIndex, AutoBiddingDo> autoBiddingDoMap = this.getOrientationPackageAdjustDis(keys);
            List autoBiddingDos = AutoBiddingAlg.getFactorBatch((List)Lists.newArrayList(autoBiddingDoMap.values()));
            if (CollectionUtils.isNotEmpty((Collection)autoBiddingDos)) {
                return autoBiddingDos.stream().collect(Collectors.toMap(autoBiddingDo -> {
                    Long advertId = autoBiddingDo.getAdvertId();
                    Long appId = autoBiddingDo.getAppId();
                    Long packageId = autoBiddingDo.getPlanId();
                    Long secondSubType = autoBiddingDo.getSecondSubType();
                    Long baseType = autoBiddingDo.getBaseType();
                    AutoBiddingFactorIndex factorIndex = AutoBiddingFactorIndex.newBuilder().packageId(packageId).advertId(advertId).cvrType(baseType).depthCvrType(secondSubType).appId(appId).build();
                    return factorIndex;
                }, Function.identity()));
            }
        }
        catch (Exception e) {
            this.logger.error("getAllAutoBiddingFactor happend error {}", (Throwable)e);
        }
        return Maps.newHashMap();
    }

    public void setAutoBiddingNewFee(AdvertRecommendRequestVo advertRecommendRequestVo) {
        try {
            AppDo appDo = advertRecommendRequestVo.getAppDo();
            Long appId = appDo.getId();
            Set<OrientationPackage> advertOrientationPackages = advertRecommendRequestVo.getAdvertOrientationPackages().stream().filter(OrientationPackage::isCpa).filter(dto -> dto.getDepthCvrType() != null).filter(dto -> dto.getManuallyConvertCost() == false).collect(Collectors.toSet());
            ArrayList allIndex = Lists.newArrayListWithCapacity((int)advertOrientationPackages.size());
            for (OrientationPackage advertOrientationPackage : advertOrientationPackages) {
                Long advertId = advertOrientationPackage.getAdvertId();
                Long packageId = advertOrientationPackage.getId();
                Integer cvrType = advertOrientationPackage.getCvrType();
                Integer depthCvrType = advertOrientationPackage.getDepthCvrType();
                Long convertCost = advertOrientationPackage.getConvertCost();
                AutoBiddingFactorIndex autoBiddingFactorIndex = AutoBiddingFactorIndex.newBuilder().advertId(advertId).packageId(packageId).appId(appId).cvrType(cvrType.longValue()).depthCvrType(depthCvrType.longValue()).convertCost(convertCost).build();
                allIndex.add(autoBiddingFactorIndex);
            }
            ImmutableMap autoBiddingDoMap = this.autoBiddingFactorCache.getAll((Iterable)allIndex);
            this.handleNewAfeeByAutoBiddingFactor(advertOrientationPackages, (Map<AutoBiddingFactorIndex, AutoBiddingDo>)autoBiddingDoMap, appId);
        }
        catch (Exception e) {
            this.logger.error("setAutoBiddingFactor happened error:{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void handleNewAfeeByAutoBiddingFactor(Set<OrientationPackage> advertOrientationPackages, Map<AutoBiddingFactorIndex, AutoBiddingDo> autoBiddingDoMap, Long appId) {
        advertOrientationPackages.forEach(advertOrientationPackage -> {
            Long advertId = advertOrientationPackage.getAdvertId();
            Long packageId = advertOrientationPackage.getId();
            Integer cvrType = advertOrientationPackage.getCvrType();
            Integer depthCvrType = advertOrientationPackage.getDepthCvrType();
            AutoBiddingFactorIndex autoBiddingFactorIndex = AutoBiddingFactorIndex.newBuilder().advertId(advertId).packageId(packageId).appId(appId).cvrType(cvrType.longValue()).depthCvrType(depthCvrType.longValue()).build();
            AutoBiddingDo autoBiddingDo = (AutoBiddingDo)autoBiddingDoMap.get(autoBiddingFactorIndex);
            if (autoBiddingDo != null) {
                Double autoBiddingFactor = Optional.ofNullable(autoBiddingDo.getAppAfeeFactor()).orElse(1.0);
                Long oldConvertCost = advertOrientationPackage.getConvertCost();
                Long newConvertCost = new BigDecimal((double)oldConvertCost.longValue() * autoBiddingFactor).longValue();
                advertOrientationPackage.setConvertCost(newConvertCost);
                advertOrientationPackage.setAutoBiddingFactor(autoBiddingFactor);
                advertOrientationPackage.setControlWeight(autoBiddingDo.getControlWeight());
            }
        });
    }
}

