/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.bo.advert;

import cn.com.duiba.nezha.engine.api.enums.ResultCodeEnum;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.mergeData.MergeData;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AdvertMaterialRcmdCtrStatEntity;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertMergeStatService;
import cn.com.duiba.nezha.engine.biz.support.advert.AdvertCacheKey;
import cn.com.duiba.nezha.engine.common.cache.RedisUtil;
import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertMaterialRcmdCtrStatBo {
    private static final Logger logger = LoggerFactory.getLogger(AdvertMaterialRcmdCtrStatBo.class);
    private static final Long EXPIRE_TIME = 1200L;
    @Resource
    private RedisUtil redisUtil;
    @Autowired
    private AdvertMergeStatService advertMergeStatService;

    public List<AdvertMaterialRcmdCtrStatEntity> getMaterials(long appId, long advertId, List<Long> materialIdList) {
        List<AdvertMaterialRcmdCtrStatEntity> advertMaterialRcmdCtrStatEntityList = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{appId, advertId, materialIdList})) {
            logger.warn("param invalid {}", (Object)ResultCodeEnum.PARAMS_INVALID.getDesc());
            return advertMaterialRcmdCtrStatEntityList;
        }
        try {
            String key = AdvertCacheKey.getAdvertMaterialsStatKey(appId, advertId, materialIdList);
            logger.debug("getMaterialList cache exits,key = {} read redis", (Object)key);
            advertMaterialRcmdCtrStatEntityList = this.redisUtil.getList(key, AdvertMaterialRcmdCtrStatEntity.class);
            if (advertMaterialRcmdCtrStatEntityList == null) {
                advertMaterialRcmdCtrStatEntityList = this.getAdvertMaterialRcmdCtrStatEntitiesFromMongo(appId, advertId, materialIdList);
                this.redisUtil.setList(key, advertMaterialRcmdCtrStatEntityList, EXPIRE_TIME);
            }
        }
        catch (Exception e) {
            logger.warn("getMaterialList happen error:{}", (Throwable)e);
            throw new RecommendEngineException("getMaterialList happen error", e);
        }
        return advertMaterialRcmdCtrStatEntityList;
    }

    private List<AdvertMaterialRcmdCtrStatEntity> getAdvertMaterialRcmdCtrStatEntitiesFromMongo(long appId, long advertId, List<Long> materialIdList) {
        ArrayList<AdvertMaterialRcmdCtrStatEntity> advertMaterialRcmdCtrStatEntityList = new ArrayList<AdvertMaterialRcmdCtrStatEntity>();
        try {
            List<MergeData> advertMergeStatDoList = this.advertMergeStatService.getMaterialDataInApp(advertId, appId, materialIdList);
            ImmutableMap materialId2MergeStat = Maps.uniqueIndex(advertMergeStatDoList, MergeData::getMaterialId);
            ImmutableSet entries = materialId2MergeStat.entrySet();
            for (Map.Entry entry : entries) {
                Long materialId = (Long)entry.getKey();
                MergeData advertMergeStatDo = (MergeData)entry.getValue();
                Double ctr = Optional.ofNullable(advertMergeStatDo.getCtr()).orElse(0.2);
                AdvertMaterialRcmdCtrStatEntity advertMaterialRcmdCtrStatEntity = new AdvertMaterialRcmdCtrStatEntity();
                advertMaterialRcmdCtrStatEntity.setAdvertId(advertId);
                advertMaterialRcmdCtrStatEntity.setAppId(appId);
                advertMaterialRcmdCtrStatEntity.setMaterialId(materialId);
                advertMaterialRcmdCtrStatEntity.setCtr(ctr);
                advertMaterialRcmdCtrStatEntityList.add(advertMaterialRcmdCtrStatEntity);
            }
        }
        catch (Exception e) {
            logger.info("new material query error:{}", (Throwable)e);
        }
        return advertMaterialRcmdCtrStatEntityList;
    }
}

