/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.domain;

import cn.com.duiba.nezha.alg.alg.vo.NezhaStatDto;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CorrectResult {
    public static final CorrectResult DEFAULT = CorrectResult.newBuilder().build();
    private Map<PredictResultType, Map<Long, Double>> correctionFactorMap;
    private Map<PredictResultType, Map<Long, Double>> reconstructionFactorMap;
    private Map<Long, NezhaStatDto> nezhaStatDtoMap;

    private CorrectResult(Builder builder) {
        this.setCorrectionFactorMap(builder.correctionFactorMap);
        this.setReconstructionFactorMap(builder.reconstructionFactorMap);
        this.setNezhaStatDtoMap(builder.nezhaStatDtoMap);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static CorrectResult getDEFAULT() {
        return DEFAULT;
    }

    public Map<Long, NezhaStatDto> getNezhaStatDtoMap() {
        return Optional.ofNullable(this.nezhaStatDtoMap).orElseGet(HashMap::new);
    }

    public void setNezhaStatDtoMap(Map<Long, NezhaStatDto> nezhaStatDtoMap) {
        this.nezhaStatDtoMap = nezhaStatDtoMap;
    }

    public Map<PredictResultType, Map<Long, Double>> getCorrectionFactorMap() {
        return Optional.ofNullable(this.correctionFactorMap).orElseGet(HashMap::new);
    }

    public void setCorrectionFactorMap(Map<PredictResultType, Map<Long, Double>> correctionFactorMap) {
        this.correctionFactorMap = correctionFactorMap;
    }

    public Map<PredictResultType, Map<Long, Double>> getReconstructionFactorMap() {
        return Optional.ofNullable(this.reconstructionFactorMap).orElseGet(HashMap::new);
    }

    public void setReconstructionFactorMap(Map<PredictResultType, Map<Long, Double>> reconstructionFactorMap) {
        this.reconstructionFactorMap = reconstructionFactorMap;
    }

    public static final class Builder {
        private Map<PredictResultType, Map<Long, Double>> correctionFactorMap;
        private Map<PredictResultType, Map<Long, Double>> reconstructionFactorMap;
        private Map<Long, NezhaStatDto> nezhaStatDtoMap;

        private Builder() {
        }

        public Builder correctionFactorMap(Map<PredictResultType, Map<Long, Double>> val) {
            this.correctionFactorMap = val;
            return this;
        }

        public Builder reconstructionFactorMap(Map<PredictResultType, Map<Long, Double>> val) {
            this.reconstructionFactorMap = val;
            return this;
        }

        public Builder nezhaStatDtoMap(Map<Long, NezhaStatDto> val) {
            this.nezhaStatDtoMap = val;
            return this;
        }

        public CorrectResult build() {
            return new CorrectResult(this);
        }
    }
}

