/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.message.advert.ons;

import cn.com.duiba.nezha.engine.biz.message.advert.ons.AbstractMessageResultHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="bootRocketMqMessageListener")
public class RocketMqMessageListener
implements MessageListenerConcurrently {
    private static final Logger logger = LoggerFactory.getLogger(RocketMqMessageListener.class);
    private static final Map<String, AbstractMessageResultHandler> HANDLER_CALLBACK_MAP = new ConcurrentHashMap<String, AbstractMessageResultHandler>();
    @Value(value="${nezha.roi.topic}")
    private String tuiaRoiTopic;
    @Value(value="${nezha.bizlog.enable}")
    protected boolean logBiz;

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        try {
            for (MessageExt message : msgs) {
                String topic;
                if (StringUtils.isNotEmpty((String)message.getUserProperty("perfTest")) || !(topic = message.getTopic()).equals(this.tuiaRoiTopic)) continue;
                AbstractMessageResultHandler handler = HANDLER_CALLBACK_MAP.get(message.getTags());
                String body = new String(message.getBody(), "utf-8");
                if (this.logBiz) {
                    logger.info("receive msg, tag:{} message:{}", (Object)message.getTags(), (Object)body);
                }
                handler.consumer(body);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ConsumeConcurrentlyStatus.RECONSUME_LATER;
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    public static void registerCallback(AbstractMessageResultHandler handler) {
        HANDLER_CALLBACK_MAP.put(handler.getListenTag(), handler);
    }
}

