/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.stereotype.Service;

@Service
public class AdvertSmartShopService
extends CacheService {
    private LoadingCache<String, Integer> blackWhiteCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Integer>(){

        public Integer load(String key) {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<String, Integer> loadAll(Iterable<? extends String> keys) {
            List keyList = StreamSupport.stream(keys.spliterator(), false).collect(Collectors.toList());
            HashMap<String, Integer> blackWhiteMap = new HashMap<String, Integer>(keyList.size());
            DBTimeProfile.enter((String)("load blackWhiteCache " + keyList.size()));
            List values = AdvertSmartShopService.this.nezhaStringRedisTemplate.opsForValue().multiGet(keyList);
            DBTimeProfile.release();
            AdvertSmartShopService.this.convert(keyList, blackWhiteMap, values);
            return blackWhiteMap;
        }
    });

    private void convert(List<String> collect, Map<String, Integer> blackWhiteMap, List<String> values) {
        for (int index = 0; index < collect.size(); ++index) {
            String key = collect.get(index);
            String value = values.get(index);
            Integer qualityLevel = Optional.ofNullable(value).map(v -> {
                switch (v) {
                    case "b1": {
                        return 1;
                    }
                    case "b2": {
                        return 2;
                    }
                    case "b3": {
                        return 3;
                    }
                    case "w": {
                        return 8;
                    }
                }
                return 16;
            }).orElse(0);
            blackWhiteMap.put(key, qualityLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePackageQualityLevelLevel(Set<OrientationPackage> orientationPackages, Long appId, Long slotId, Long activityId) {
        try {
            DBTimeProfile.enter((String)"loadBlackWhite");
            ArrayList allKeys = new ArrayList(orientationPackages.size() * 2);
            HashMap oldKeyMap = new HashMap(orientationPackages.size());
            HashMap newKeyMap = new HashMap(orientationPackages.size());
            orientationPackages.forEach(orientationPackage -> {
                Long advertId = orientationPackage.getAdvertId();
                Long packageId = orientationPackage.getId();
                String oldBlackWhiteKey = RedisKeyUtil.getBlackWhiteKey((Long)appId, (Long)slotId, (Long)activityId, (Long)packageId, (Long)advertId);
                String newBlackWhiteKey = RedisKeyUtil.getNewBlackWhiteKey((Long)advertId, (Long)packageId);
                allKeys.add(oldBlackWhiteKey);
                allKeys.add(newBlackWhiteKey);
                oldKeyMap.put(orientationPackage, oldBlackWhiteKey);
                newKeyMap.put(orientationPackage, newBlackWhiteKey);
            });
            ImmutableMap all = this.blackWhiteCache.getAll(allKeys);
            orientationPackages.forEach(arg_0 -> AdvertSmartShopService.lambda$handlePackageQualityLevelLevel$2((Map)all, newKeyMap, oldKeyMap, arg_0));
        }
        catch (Exception e) {
            this.logger.error("load blackWhite error :{}", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private static /* synthetic */ void lambda$handlePackageQualityLevelLevel$2(Map all, Map newKeyMap, Map oldKeyMap, OrientationPackage orientationPackage) {
        orientationPackage.setQualityLevel((Integer)Optional.ofNullable(all.get(newKeyMap.get(orientationPackage))).orElse(all.get(oldKeyMap.get(orientationPackage))));
    }
}

