/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.RoiHashKeyUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class OrientationPackageAdjustPriceFactorService
extends CacheService {
    private LoadingCache<String, Double> factorCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Double>(){

        public Double load(String key) {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<String, Double> loadAll(Iterable<? extends String> keys) {
            ArrayList keyList = Lists.newArrayList(keys);
            HashMap<String, Double> factorMap = new HashMap<String, Double>(keyList.size());
            List values = OrientationPackageAdjustPriceFactorService.this.nezhaStringRedisTemplate.opsForValue().multiGet((Collection)keyList);
            for (int index = 0; index < keyList.size(); ++index) {
                String key = (String)keyList.get(index);
                String value = (String)values.get(index);
                factorMap.put(key, Optional.ofNullable(value).map(Double::parseDouble).orElse(1.0));
            }
            return factorMap;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Set<OrientationPackage> orientationPackages, Long appId, Long slotId) {
        try {
            DBTimeProfile.enter((String)"loadAdjustPriceFactors");
            ArrayList keys = new ArrayList(orientationPackages.size() * 3);
            HashMap advert2dimKeysMap = new HashMap(orientationPackages.size());
            orientationPackages.forEach(orientationPackage -> {
                Long advertId = orientationPackage.getAdvertId();
                Long packageId = orientationPackage.getId();
                Integer cvrType = orientationPackage.getCvrType();
                String slotKey = RedisKeyUtil.factorKey((Long)advertId, (Long)packageId, (String)RoiHashKeyUtil.getSlotKey((Object)slotId, (Integer)cvrType));
                String appKey = RedisKeyUtil.factorKey((Long)advertId, (Long)packageId, (String)RoiHashKeyUtil.getAppKey((Object)appId, (Integer)cvrType));
                String defaultKey = RedisKeyUtil.factorKey((Long)advertId, (Long)packageId, (String)RoiHashKeyUtil.getDefault((Integer)cvrType));
                List<String> dimKeys = Arrays.asList(slotKey, appKey, defaultKey);
                keys.addAll(dimKeys);
                advert2dimKeysMap.put(orientationPackage, dimKeys);
            });
            ImmutableMap factorMap = new HashMap(0);
            try {
                factorMap = this.factorCache.getAll(keys);
            }
            catch (Exception e) {
                this.logger.error("load factor error :{}", (Throwable)e);
            }
            block5: for (OrientationPackage orientationPackage2 : orientationPackages) {
                List dimKeys = (List)advert2dimKeysMap.get(orientationPackage2);
                for (String dimKey : dimKeys) {
                    Double factor = (Double)factorMap.get(dimKey);
                    if (!this.checkFactor(factor)) continue;
                    orientationPackage2.setAdjustPriceFactor(factor);
                    continue block5;
                }
            }
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private boolean checkFactor(Double value) {
        return value != null && !value.isNaN() && !value.equals(1.0);
    }
}

