/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr;

import cn.com.duiba.nezha.alg.alg.vo.BiddingRateDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public interface NewAdvertSupportService {
    public void incrBidingCount(BiddingKey var1, long var2);

    public BiddingRateDo getBiddingRate(BiddingKey var1);

    public void insertOutGoing(OrientationPackage var1, Long var2);

    public Map<BiddingKey, Stat> getCacheInfo();

    public static class Stat {
        private AtomicLong inComing;
        private AtomicLong outGoing;

        public AtomicLong getInComing() {
            return this.inComing;
        }

        public void setInComing(AtomicLong inComing) {
            this.inComing = inComing;
        }

        public AtomicLong getOutGoing() {
            return this.outGoing;
        }

        public void setOutGoing(AtomicLong outGoing) {
            this.outGoing = outGoing;
        }
    }

    public static class BiddingKey {
        private Long advertId;
        private Long orientationId;
        private Long slotId;
        private String newTradeTagNum;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BiddingKey)) {
                return false;
            }
            BiddingKey that = (BiddingKey)o;
            return Objects.equals(this.advertId, that.advertId) && Objects.equals(this.orientationId, that.orientationId) && Objects.equals(this.slotId, that.slotId) && Objects.equals(this.newTradeTagNum, that.newTradeTagNum);
        }

        public int hashCode() {
            return Objects.hash(this.advertId, this.orientationId, this.slotId, this.newTradeTagNum);
        }

        public Long getAdvertId() {
            return this.advertId;
        }

        public void setAdvertId(Long advertId) {
            this.advertId = advertId;
        }

        public Long getOrientationId() {
            return this.orientationId;
        }

        public void setOrientationId(Long orientationId) {
            this.orientationId = orientationId;
        }

        public Long getSlotId() {
            return this.slotId;
        }

        public void setSlotId(Long slotId) {
            this.slotId = slotId;
        }

        public String getNewTradeTagNum() {
            return this.newTradeTagNum;
        }

        public void setNewTradeTagNum(String newTradeTagNum) {
            this.newTradeTagNum = newTradeTagNum;
        }

        public static BiddingKey getAdvertKey(Long advertId, Long slotId) {
            BiddingKey advertKey = new BiddingKey();
            advertKey.setAdvertId(advertId);
            advertKey.setSlotId(slotId);
            return advertKey;
        }

        public static BiddingKey getAdvertAndOrientationKey(Long advertId, Long packageId, Long slotId) {
            BiddingKey advertAndOrientationKey = new BiddingKey();
            advertAndOrientationKey.setAdvertId(advertId);
            advertAndOrientationKey.setSlotId(slotId);
            advertAndOrientationKey.setOrientationId(packageId);
            return advertAndOrientationKey;
        }

        public static BiddingKey getSlotKey(Long slotId) {
            BiddingKey slotKey = new BiddingKey();
            slotKey.setSlotId(slotId);
            return slotKey;
        }

        public static BiddingKey getTradeAndSlotKey(Long slotId, String newTradeTagNum) {
            BiddingKey tradeAndSlotKey = new BiddingKey();
            tradeAndSlotKey.setNewTradeTagNum(newTradeTagNum);
            tradeAndSlotKey.setSlotId(slotId);
            return tradeAndSlotKey;
        }
    }
}

