/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.merge;

import cn.com.duiba.nezha.engine.api.enums.AdvertMaterialGroupTypeEnum;
import cn.com.duiba.nezha.engine.api.enums.ResultCodeEnum;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AdvertMaterialRcmdCtrStatEntity;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertMaterialResortGroupVo;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertMaterialResortVo;
import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdvertMaterialMergeService {
    private static final Logger logger = LoggerFactory.getLogger(AdvertMaterialMergeService.class);

    public List<AdvertMaterialResortGroupVo> getMergeMaterialMap(List<AdvertMaterialRcmdCtrStatEntity> entityList, List<Long> oldMaterialIdList, List<Long> newMaterialIdList) {
        ArrayList<AdvertMaterialResortGroupVo> advertMaterialResortGroupVoList = new ArrayList<AdvertMaterialResortGroupVo>();
        if (AssertUtil.isAllEmpty((Object[])new Object[]{oldMaterialIdList, newMaterialIdList})) {
            logger.warn("getMergeMaterialMap param cheak invalid", (Object)ResultCodeEnum.PARAMS_INVALID.getDesc());
            return advertMaterialResortGroupVoList;
        }
        try {
            AdvertMaterialResortGroupVo advertMaterialResortGroupVo;
            HashMap<Long, AdvertMaterialRcmdCtrStatEntity> materialCRTMap = new HashMap<Long, AdvertMaterialRcmdCtrStatEntity>();
            if (AssertUtil.isNotEmpty(entityList)) {
                for (AdvertMaterialRcmdCtrStatEntity entity : entityList) {
                    materialCRTMap.put(entity.getMaterialId(), entity);
                }
            }
            ArrayList<AdvertMaterialResortVo> groupWithWeight = new ArrayList<AdvertMaterialResortVo>();
            ArrayList<AdvertMaterialResortVo> groupWithoutWeight = new ArrayList<AdvertMaterialResortVo>();
            if (AssertUtil.isNotEmpty(oldMaterialIdList)) {
                this.traverseOldMaterials(oldMaterialIdList, materialCRTMap, groupWithWeight, groupWithoutWeight);
            }
            if (AssertUtil.isNotEmpty(newMaterialIdList)) {
                this.traverseNewMaterials(newMaterialIdList, groupWithoutWeight);
            }
            if (AssertUtil.isNotEmpty(groupWithWeight)) {
                advertMaterialResortGroupVo = this.getAdvertMaterialResortGroupVo(AdvertMaterialGroupTypeEnum.WITH_WEIGHT_MATERIAL_TYPE.getIndex(), groupWithWeight);
                advertMaterialResortGroupVoList.add(advertMaterialResortGroupVo);
            }
            if (AssertUtil.isNotEmpty(groupWithoutWeight)) {
                advertMaterialResortGroupVo = this.getAdvertMaterialResortGroupVo(AdvertMaterialGroupTypeEnum.WITHOUT_WEIGHT_MATERIAL_TYPE.getIndex(), groupWithoutWeight);
                advertMaterialResortGroupVoList.add(advertMaterialResortGroupVo);
            }
        }
        catch (Exception e) {
            logger.error("getMergeMaterialMap happen error:{}", (Throwable)e);
            throw new RecommendEngineException("getMergeMaterialMap happen error", e);
        }
        return advertMaterialResortGroupVoList;
    }

    private void traverseOldMaterials(List<Long> oldMaterialIdList, Map<Long, AdvertMaterialRcmdCtrStatEntity> materialCRTMap, List<AdvertMaterialResortVo> groupWithWeight, List<AdvertMaterialResortVo> groupWithoutWeight) {
        for (Long materialId : oldMaterialIdList) {
            AdvertMaterialRcmdCtrStatEntity entity = materialCRTMap.get(materialId);
            AdvertMaterialResortVo materialResortVo = new AdvertMaterialResortVo();
            materialResortVo.setMaterialId(materialId);
            if (AssertUtil.isNotEmpty((Object)entity)) {
                materialResortVo.setRankScore(entity.getCtr());
                groupWithWeight.add(materialResortVo);
                continue;
            }
            groupWithoutWeight.add(materialResortVo);
        }
    }

    private void traverseNewMaterials(List<Long> newMaterialIdList, List<AdvertMaterialResortVo> groupWithoutWeight) {
        for (Long materialId : newMaterialIdList) {
            AdvertMaterialResortVo materialResortVo = new AdvertMaterialResortVo();
            materialResortVo.setMaterialId(materialId);
            groupWithoutWeight.add(materialResortVo);
        }
    }

    private AdvertMaterialResortGroupVo getAdvertMaterialResortGroupVo(long groupType, List<AdvertMaterialResortVo> groupVo) {
        AdvertMaterialResortGroupVo advertMaterialResortGroupVo = new AdvertMaterialResortGroupVo();
        advertMaterialResortGroupVo.setMaterialGroupId(groupType);
        advertMaterialResortGroupVo.setMaterialResortVoList(groupVo);
        advertMaterialResortGroupVo.setMaterialNums(groupVo.size());
        return advertMaterialResortGroupVo;
    }
}

