package cn.com.duiba.nezha.engine.biz.domain;

import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;

import java.util.Objects;

public class FloorPriceFeatureIndex {
    /**
     * 广告Id
     */
    private Long advertId;

    /**
     * 配置Id
     */
    private Long oriPkgId;

    /**
     * 媒体Id
     */
    private Long appId;

    /**
     * 广告位id
     */
    private Long slotId;


    public FloorPriceFeatureIndex(Long advertId, Long oriPkgId, Long appId, Long slotId) {
        this.advertId = advertId;
        this.oriPkgId = oriPkgId;
        this.appId = appId;
        this.slotId = slotId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FloorPriceFeatureIndex that = (FloorPriceFeatureIndex) o;
        return Objects.equals(advertId, that.advertId) &&
                Objects.equals(oriPkgId, that.oriPkgId) &&
                Objects.equals(appId, that.appId) &&
                Objects.equals(slotId, that.slotId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(advertId, oriPkgId, appId, slotId);
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOriPkgId() {
        return oriPkgId;
    }

    public void setOriPkgId(Long oriPkgId) {
        this.oriPkgId = oriPkgId;
    }

    public static FloorPriceFeatureIndex conver(OrientationPackage orientationPackage, AppDo appDo) {
        return new FloorPriceFeatureIndex(orientationPackage.getAdvertId(), orientationPackage.getId(), appDo.getId(), appDo.getSlotId());
    }
}
