package cn.com.duiba.nezha.engine.biz.domain.advert;

import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceResult;
import cn.com.duiba.nezha.alg.alg.vo.BiddingStatDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SmoothResultDo;
import cn.com.duiba.nezha.engine.api.dto.AdvertNewDto;
import cn.com.duiba.nezha.engine.api.enums.ChargeTypeEnum;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AdvertStatisticMergeEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AlgoRescureEntity;

import java.util.*;

public class OrientationPackage implements StatisticDataGetter {
    // 配置包id
    private Long id;

    private Long accountId;
    // 广告id
    private Long advertId;

    //优化目标
    private Integer cvrType;

    //深度优化目标
    private Integer depthCvrType;
    // 点击单价
    private Long clickFee;
    // 转化成本
    private Long convertCost;
    // 深度智能投放优化前的 转化成本
    private Long oldConvertCost;
    // 配置包类型 1-人工包 2-托管包
    private Integer packageType;
    // 投放类型 1-人工投放 2-自动托管 3-优投模式
    private Integer targetAppLimit;
    // 本次配置是否是强定向
    private Boolean strongTarget;
    // 预算
    private Long budget;
    // 计费类型 1-cpc, 2-cpa
    private Integer chargeType;
    // 素材列表
    private Set<Material> materials;
    // 0点到当前每小时预算（不包括当前小时）
    private List<Double> hourlyBudgetFees;
    // 0点到当前每小时预算发券（不包括当前小时）
    private List<Double> hourlyBudgetCounts;
    // 新行业标签
    private String newTradeTagNum;

    private Boolean smartShop;

    // 是否是扶持广告
    private Boolean supportStatus;
    // 是否需要扶持
    private Boolean needSupportWeight;
    // 参考的转化出价
    private Long assessCost;

    // 调价因子
    private Double adjustPriceFactor;

    //算法自救加权因子
    private  Double feeWeightFactor;

    //算法自救放弃流量
    private  Boolean isBasePriceException;

    // 时段,天,最近7天的统计数据
    private StatisticData hourStatisticData;
    private StatisticData todayStatisticData;
    private StatisticData recently7DayStatisticData;
    private StatisticData hourAppStatisticData;
    private StatisticData todayAppStatisticData;
    private StatisticData recently7DayAppStatisticData;

    // 智能采买统计数据
    private StatisticData smartShopStatisticData;

    private Integer qualityLevel;
    private Integer userBehavior;

    private Long finalFee;
    private Double statCtr;
    private Double statCvr;
    private Double preCtr;
    private Double preCvr;
    private Double ctr;
    private Double cvr;

    private Boolean giveUp;
    private Long flowTag;

    // 竞价成功率对象
    private BiddingStatDo biddingStatDo;

    // 预算消耗信息类
    private BudgetSmoothDo budgetSmoothDo;

    private Double qScore;
    private Double rankScore;
    private Integer rank;
    private Integer reRank;

    private Double supportWeight;
    private Boolean supportSuccess;

    private String orderId;

    private AdvertStatisticMergeEntity tagStatisticData;

    //算法自救信息
    private AlgoRescureEntity algoRescureEntity;

    private List<Double> hourlyCtr;
    private List<Double> hourlyCvr;
    private List<Double> hourlyClick;
    private List<Double> hourlyLaunch;
    private List<Double> hourlyConsume;

    private Integer releaseTarget;
    private Long importantAppFee;

    //消耗类型0：加速投放，1：匀速投放
    private Integer budgetSmooth;

    // 预算平滑对象
    private SmoothResultDo smoothResultDo;

    private String simpleSupportType;

    /**
     * ocpa 出价 是否为人工填写的
     */
    private Boolean manuallyConvertCost;

    // 是否被预算平滑放弃
    private Boolean budgetSmoothGiveUp ;

    /**
     * 深度优化 调价因子
     */
    private Double autoBiddingFactor;
    /**
     * 出价控制因子（暂时日志使用）
     */
    private  Double controlWeight;
    /**
     *  配置文件中 配置的supportInfo 字段中的扶持比例 只做打印使用
     */
    private Double supportInfoSupportWeight;

    /** 是否是潜力广告的配置 0 - 否，1-是*/
    private Integer potentionalStatus;

    /** 是否需要潜力广告扶持 false - 否,true-是*/
    private Boolean needPotentionalSupport;

    /**
     * 是否在底价白名单中 1-是底价白名单 0- 是普通广告
     */
    private Boolean floorPriceWhilteAdvert;

    /**
     * 托管底价放弃比例
     */
    private Double giveUpProb10;
    private Double giveUpProb5;


    public OrientationPackage(Long id, Long advertId) {
        this.id = id;
        this.advertId = advertId;
    }

    public OrientationPackage() {
    }



    public static OrientationPackage convert(AdvertNewDto advertDto) {
        OrientationPackage orientationPackage = new OrientationPackage();

        orientationPackage.setId(advertDto.getPackageId());
        orientationPackage.setAccountId(Long.parseLong(advertDto.getAccountId()));
        orientationPackage.setAdvertId(advertDto.getAdvertId());
        orientationPackage.setPackageType(advertDto.getPackageType());
        orientationPackage.setClickFee(advertDto.getFee());
        // 如果设置了重点媒体转化出价 则以重点媒体转化出价为准 否则使用 ConvertCost
        orientationPackage.setConvertCost(advertDto.getImportantAppFee());
        orientationPackage.setOldConvertCost(advertDto.getConvertCost());
        orientationPackage.setTargetAppLimit(advertDto.getTargetAppLimit());
        orientationPackage.setStrongTarget(advertDto.getStrongTarget());
        orientationPackage.setBudget(advertDto.getPackageBudget());
        orientationPackage.setChargeType(advertDto.getChargeType());
        orientationPackage.setNewTradeTagNum(advertDto.getNewTradeTagNum());

        // 配置包时段数据
        orientationPackage.setHourlyBudgetFees(advertDto.getHourlyBudgetFees());
        orientationPackage.setHourlyBudgetCounts(advertDto.getHourlyBudgetCounts());

        // 扶持相关字段
        orientationPackage.setSupportStatus(advertDto.getSupportStatus());
        orientationPackage.setNeedSupportWeight(advertDto.getNeedSupportWeight());
        orientationPackage.setAssessCost(advertDto.getAssessCost());
        orientationPackage.setCvrType(advertDto.getCvrType());
        orientationPackage.setDepthCvrType(advertDto.getDepthCvrType());
        orientationPackage.setReleaseTarget(advertDto.getReleaseTarget());
        orientationPackage.setImportantAppFee(advertDto.getImportantAppFee());
        orientationPackage.setManuallyConvertCost(advertDto.getDisAppFeeType()!=0);

        //消耗类型
        orientationPackage.setBudgetSmooth(advertDto.getBudgetSmooth());

        //潜力广告扶持
        orientationPackage.setPotentionalStatus(advertDto.getPotentionalStatus());
        orientationPackage.setNeedPotentionalSupport(Integer.valueOf(1).equals(advertDto.getNeedPotentionalSupport()));

        //是否是底价白名单
        orientationPackage.setFloorPriceWhilteAdvert(advertDto.getFloorPriceWhilteAdvert());
        return orientationPackage;
    }


    public Boolean getFloorPriceWhilteAdvert() {
        return floorPriceWhilteAdvert;
    }

    public void setFloorPriceWhilteAdvert(Boolean floorPriceWhilteAdvert) {
        this.floorPriceWhilteAdvert = floorPriceWhilteAdvert;
    }

    public Double getAutoBiddingFactor() {
        return Optional.ofNullable(autoBiddingFactor).orElse(1.0D);
    }

    public void setAutoBiddingFactor(Double autoBiddingFactor) {
        this.autoBiddingFactor = autoBiddingFactor;
    }

    public Boolean getBudgetSmoothGiveUp() {
        return Optional.ofNullable(budgetSmoothGiveUp).orElse(false);
    }

    public void setBudgetSmoothGiveUp(Boolean budgetSmoothGiveUp) {
        this.budgetSmoothGiveUp = budgetSmoothGiveUp;
    }

    public Double getControlWeight() {
        return controlWeight;
    }

    public void setControlWeight(Double controlWeight) {
        this.controlWeight = controlWeight;
    }

    public Boolean getManuallyConvertCost() {
        return manuallyConvertCost ;
    }

    public void setManuallyConvertCost(Boolean manuallyConvertCost) {
        this.manuallyConvertCost = manuallyConvertCost;
    }

    public Integer getDepthCvrType() {
        return depthCvrType;
    }

    public void setDepthCvrType(Integer depthCvrType) {
        this.depthCvrType = depthCvrType;
    }

    public Long getOldConvertCost() {
        return oldConvertCost;
    }

    public void setOldConvertCost(Long oldConvertCost) {
        this.oldConvertCost = oldConvertCost;
    }

    public Long getImportantAppFee() {
        return importantAppFee;
    }

    public void setImportantAppFee(Long importantAppFee) {
        this.importantAppFee = importantAppFee;
    }

    public Integer getReleaseTarget() {
        return releaseTarget;
    }

    public void setReleaseTarget(Integer releaseTarget) {
        this.releaseTarget = releaseTarget;
    }

    public List<Double> getHourlyCtr() {
        return hourlyCtr;
    }

    public void setHourlyCtr(List<Double> hourlyCtr) {
        this.hourlyCtr = hourlyCtr;
    }

    public List<Double> getHourlyCvr() {
        return hourlyCvr;
    }

    public void setHourlyCvr(List<Double> hourlyCvr) {
        this.hourlyCvr = hourlyCvr;
    }

    public List<Double> getHourlyClick() {
        return hourlyClick;
    }

    public void setHourlyClick(List<Double> hourlyClick) {
        this.hourlyClick = hourlyClick;
    }

    public List<Double> getHourlyLaunch() {
        return hourlyLaunch;
    }

    public void setHourlyLaunch(List<Double> hourlyLaunch) {
        this.hourlyLaunch = hourlyLaunch;
    }

    public List<Double> getHourlyConsume() {
        return hourlyConsume;
    }

    public void setHourlyConsume(List<Double> hourlyConsume) {
        this.hourlyConsume = hourlyConsume;
    }

    public AdvertStatisticMergeEntity getTagStatisticData() {
        return tagStatisticData;
    }

    public void setTagStatisticData(AdvertStatisticMergeEntity tagStatisticData) {
        this.tagStatisticData = tagStatisticData;
    }

    public Integer getCvrType() {
        return cvrType;
    }

    public void setCvrType(Integer cvrType) {
        this.cvrType = cvrType;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getReRank() {
        return reRank;
    }

    public void setReRank(Integer reRank) {
        this.reRank = reRank;
    }

    public Double getRankScore() {
        return rankScore;
    }

    public void setRankScore(Double rankScore) {
        this.rankScore = rankScore;
    }

    public Double getqScore() {
        return qScore;
    }

    public void setqScore(Double qScore) {
        this.qScore = qScore;
    }

    public Double getSupportWeight() {
        return Optional.ofNullable(supportWeight).orElse(1D);
    }

    public void setSupportWeight(Double supportWeight) {
        this.supportWeight = supportWeight;
    }

    public Boolean getSupportSuccess() {
        return supportSuccess;
    }

    public void setSupportSuccess(Boolean supportSuccess) {
        this.supportSuccess = supportSuccess;
    }

    public BudgetSmoothDo getBudgetSmoothDo() {
        return budgetSmoothDo;
    }

    public void setBudgetSmoothDo(BudgetSmoothDo budgetSmoothDo) {
        this.budgetSmoothDo = budgetSmoothDo;
    }

    public BiddingStatDo getBiddingStatDo() { return biddingStatDo; }

    public void setBiddingStatDo(BiddingStatDo biddingStatDo) { this.biddingStatDo = biddingStatDo; }

    public Boolean getGiveUp() {
        return giveUp;
    }

    public void setGiveUp(Boolean giveUp) {
        this.giveUp = giveUp;
    }

    public Boolean getBasePriceException() {
        return isBasePriceException;
    }

    public void setBasePriceException(Boolean basePriceException) {
        isBasePriceException = basePriceException;
    }

    public Long getFlowTag() {
        return flowTag;
    }

    public void setFlowTag(Long flowTag) {
        this.flowTag = flowTag;
    }

    public Integer getUserBehavior() {
        return userBehavior;
    }

    public void setUserBehavior(Integer userBehavior) {
        this.userBehavior = userBehavior;
    }

    public Double getCvr() {
        return cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public Double getCtr() {
        return ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Long getFinalFee() {
        return finalFee;
    }

    public void setFinalFee(Long finalFee) {
        this.finalFee = finalFee;
    }

    public Double getStatCtr() {
        return statCtr;
    }

    public void setStatCtr(Double statCtr) {
        this.statCtr = statCtr;
    }

    public Double getStatCvr() {
        return statCvr;
    }

    public void setStatCvr(Double statCvr) {
        this.statCvr = statCvr;
    }

    public Double getPreCtr() {
        return preCtr;
    }

    public void setPreCtr(Double preCtr) {
        this.preCtr = preCtr;
    }

    public Double getPreCvr() {
        return preCvr;
    }

    public void setPreCvr(Double preCvr) {
        this.preCvr = preCvr;
    }

    public Boolean getSmartShop() {
        return smartShop;
    }

    public void setSmartShop(Boolean smartShop) {
        this.smartShop = smartShop;
    }

    public Integer getQualityLevel() {
        return Optional.ofNullable(qualityLevel).orElse(0);
    }

    public void setQualityLevel(Integer qualityLevel) {
        this.qualityLevel = qualityLevel;
    }

    public Optional<StatisticData> getSmartShopStatisticData() {
        return Optional.ofNullable(smartShopStatisticData);
    }

    public void setSmartShopStatisticData(StatisticData smartShopStatisticData) {
        this.smartShopStatisticData = smartShopStatisticData;
    }

    @Override
    public StatisticData getHourAppStatisticData() {
        return hourAppStatisticData;
    }

    public void setHourAppStatisticData(StatisticData hourAppStatisticData) {
        this.hourAppStatisticData = hourAppStatisticData;
    }

    @Override
    public StatisticData getTodayAppStatisticData() {
        return todayAppStatisticData;
    }

    public void setTodayAppStatisticData(StatisticData todayAppStatisticData) {
        this.todayAppStatisticData = todayAppStatisticData;
    }

    @Override
    public StatisticData getRecently7DayAppStatisticData() {
        return recently7DayAppStatisticData;
    }

    public void setRecently7DayAppStatisticData(StatisticData recently7DayAppStatisticData) {
        this.recently7DayAppStatisticData = recently7DayAppStatisticData;
    }

    @Override
    public StatisticData getHourStatisticData() {
        return hourStatisticData;
    }

    public void setHourStatisticData(StatisticData hourStatisticData) {
        this.hourStatisticData = hourStatisticData;
    }

    @Override
    public StatisticData getTodayStatisticData() {
        return todayStatisticData;
    }

    public void setTodayStatisticData(StatisticData todayStatisticData) {
        this.todayStatisticData = todayStatisticData;
    }

    @Override
    public StatisticData getRecently7DayStatisticData() {
        return recently7DayStatisticData;
    }

    public void setRecently7DayStatisticData(StatisticData recently7DayStatisticData) {
        this.recently7DayStatisticData = recently7DayStatisticData;
    }

    public Double getAdjustPriceFactor() {
        return Optional.ofNullable(adjustPriceFactor).orElse(1D);
    }

    public Boolean getSupportStatus() {
        return supportStatus;
    }

    public void setSupportStatus(Boolean supportStatus) {
        this.supportStatus = supportStatus;
    }

    public Boolean getNeedSupportWeight() {
        return needSupportWeight;
    }

    public void setNeedSupportWeight(Boolean needSupportWeight) {
        this.needSupportWeight = needSupportWeight;
    }

    public Long getAssessCost() {
        return assessCost;
    }

    public void setAssessCost(Long assessCost) {
        this.assessCost = assessCost;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getClickFee() {
        return clickFee;
    }

    public void setClickFee(Long clickFee) {
        this.clickFee = clickFee;
    }

    public Long getBudget() {
        return budget;
    }

    public void setBudget(Long budget) {
        this.budget = budget;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Set<Material> getMaterials() {
        return Optional.ofNullable(materials).orElseGet(HashSet::new);
    }

    public void setMaterials(Set<Material> materials) {
        this.materials = materials;
    }

    public List<Double> getHourlyBudgetFees() {
        return hourlyBudgetFees;
    }

    public void setHourlyBudgetFees(List<Double> hourlyBudgetFees) {
        this.hourlyBudgetFees = hourlyBudgetFees;
    }

    public List<Double> getHourlyBudgetCounts() {
        return hourlyBudgetCounts;
    }

    public void setHourlyBudgetCounts(List<Double> hourlyBudgetCounts) {
        this.hourlyBudgetCounts = hourlyBudgetCounts;
    }

    public Long getConvertCost() {
        return convertCost;
    }

    public void setConvertCost(Long convertCost) {
        this.convertCost = convertCost;
    }

    public Integer getPackageType() {
        return packageType;
    }

    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    public Integer getTargetAppLimit() {
        return targetAppLimit;
    }

    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    public Boolean getStrongTarget() {
        return strongTarget;
    }

    public void setStrongTarget(Boolean strongTarget) {
        this.strongTarget = strongTarget;
    }

    public String getNewTradeTagNum() { return newTradeTagNum; }

    public void setNewTradeTagNum(String newTradeTagNum) { this.newTradeTagNum = newTradeTagNum; }

    public Boolean enableBudgetSmooth() {
        return budgetSmooth.equals(1);
    }
    public Boolean disableBudgetSmooth() {
        return !enableBudgetSmooth();
    }

    public void setBudgetSmooth(Integer budgetSmooth) { this.budgetSmooth = budgetSmooth; }

    public SmoothResultDo getSmoothResultDo() { return smoothResultDo; }

    public void setSmoothResultDo(SmoothResultDo smoothResultDo) { this.smoothResultDo = smoothResultDo; }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getSimpleSupportType() {
        return simpleSupportType;
    }

    public void setSimpleSupportType(String simpleSupportType) {
        this.simpleSupportType = simpleSupportType;
    }

    public Double getFeeWeightFactor() {
        return feeWeightFactor;
    }

    public void setFeeWeightFactor(Double feeWeightFactor) {
        this.feeWeightFactor = feeWeightFactor;
    }

    public AlgoRescureEntity getAlgoRescureEntity() {
        return algoRescureEntity;
    }

    public void setAlgoRescureEntity(AlgoRescureEntity algoRescureEntity) {
        this.algoRescureEntity = algoRescureEntity;
    }

    public Integer getPotentionalStatus() {
        return Optional.ofNullable(potentionalStatus).orElse(0);
    }

    public void setPotentionalStatus(Integer potentionalStatus) {
        this.potentionalStatus = potentionalStatus;
    }

    public Boolean getNeedPotentionalSupport() {
        return Optional.ofNullable(needPotentionalSupport).orElse(false);
    }

    public void setNeedPotentionalSupport(Boolean needPotentionalSupport) {
        this.needPotentionalSupport = needPotentionalSupport;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) { return true ;}
        if (o == null || getClass() != o.getClass()) { return false;}
        OrientationPackage that = (OrientationPackage) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(advertId, that.advertId);
    }

    public Boolean isWeakTarget() {
        return !strongTarget;
    }
    @Override
    public int hashCode() {
        return Objects.hash(id, advertId);
    }

    public Boolean isCpa() {
        return this.chargeType.equals(ChargeTypeEnum.CPA.getValue());
    }

    public void setAdjustPriceFactor(Double adjustPriceFactor) {
        this.adjustPriceFactor = adjustPriceFactor;
    }


    public Long getOriginalFee() {
        return this.isCpa() ? convertCost : clickFee;
    }

    public void setSupportInfoSupportWeight(Double supportInfoSupportWeight) {
        this.supportInfoSupportWeight = supportInfoSupportWeight;
    }

    public Double getSupportInfoSupportWeight() {
        return Optional.ofNullable(supportInfoSupportWeight).orElse(0D);
    }
    


    public Double getGiveUpProb10() {
        return giveUpProb10;
    }

    public void setGiveUpProb10(Double giveUpProb10) {
        this.giveUpProb10 = giveUpProb10;
    }

    public Double getGiveUpProb5() {
        return giveUpProb5;
    }

    public void setGiveUpProb5(Double giveUpProb5) {
        this.giveUpProb5 = giveUpProb5;
    }
}
