package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.engine.api.enums.EncourageAdvertAlgEnum;
import cn.com.duiba.nezha.engine.api.enums.ModelKeyEnum;
import cn.com.duiba.nezha.engine.api.enums.PredictCorrectType;
import cn.com.duiba.nezha.engine.biz.enums.RecommendMaterialType;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import org.springframework.stereotype.Service;

import static cn.com.duiba.nezha.engine.biz.vo.advert.AdvertStatDimWeightVo.advertStatDimWeightVoA;

@Service
public class EncourageAdvertRecommendService extends AbstractAdvertRecommendService {
    @Override
    public void prepareStrategyParameter(AdvertRecommendRequestVo advertRecommendRequestVo) {
        EncourageAdvertAlgEnum encourageAdvertAlgEnum = (EncourageAdvertAlgEnum) advertRecommendRequestVo.getAdvertAlgEnum();
        //CTR预估模型Key
        ModelKeyEnum ctrModelKey;

        //CVR预估模型Key
        ModelKeyEnum cvrModelKey;

        PredictCorrectType predictCorrectType = PredictCorrectType.NONE;

        RecommendMaterialType recommendMaterialType = RecommendMaterialType.NONE;

        MutModelType mutModelType = MutModelType.NORMAL;


        switch (encourageAdvertAlgEnum) {
            case ENCOURAGE_AND_PC_1:
                // todo 提测后更改回去
                ctrModelKey = ModelKeyEnum.ZZ_FTRL_FM_CTR_MODEL_v001;
                //后面 cvr 模型可以 随便设置一个 因为用不到。这里设置是为了 不报控制针
                cvrModelKey = ModelKeyEnum.FTRL_FM_BCVR_MODEL_v009;
                // 增值广告设置 CTR 标识
                mutModelType = MutModelType.CTR;
                break;
            default:
                throw new RuntimeException("策略不存在");
        }
        advertRecommendRequestVo.setAdvertStatDimWeightVo(advertStatDimWeightVoA);
        advertRecommendRequestVo.setCtrModelKey(ctrModelKey);
        advertRecommendRequestVo.setCvrModelKey(cvrModelKey);
        advertRecommendRequestVo.setRecommendMaterialType(recommendMaterialType);
        advertRecommendRequestVo.setPredictCorrectType(predictCorrectType);
        advertRecommendRequestVo.setAdvertMultiDimScoreEffective(false);
        advertRecommendRequestVo.setInvokeWeakFilter(true);
        advertRecommendRequestVo.setNeedPredict(true);
        advertRecommendRequestVo.setMutModelType(mutModelType);
    }
}
