package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: TradeRepetitionLaunchService
 * Function:  行业重复发券 衍生特征 数据处理类
 * Date:     2019/5/15 0015 下午 14:21
 */
@Service
public class TradeRepetitionLaunchService {

    private static final Logger LOGGER = LoggerFactory.getLogger(TradeRepetitionLaunchService.class);
    @Autowired
    private HbaseTemplate hbaseTemplate;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final String CONSUMER_RESOURCE_FEATURE = "consumer_trade_feature";
    private static final String TB_TRADE_FEATURE_DI = "tb_trade_feature_di";
    private static final String OLD_NEW_TAG_TRADE_CODE = "660201";

    public void handTradeRepetitionLaunchStat(AdvertRecommendRequestVo advertRecommendRequestVo) {
        ConsumerDo consumerDo = advertRecommendRequestVo.getConsumerDo();
        Long consumerId = consumerDo.getId();
        try {
            //1 从hbase中查询出 当前用户的特征数据
            String nowDate = LocalDate.now().format(DATE_TIME_FORMATTER);

            // 当前用户综合行业发券
            String newTradeToLaunchKey = DigestUtils.md5DigestAsHex(String.valueOf(consumerId).getBytes()).substring(0, 4) + "-" + consumerId + "-" + nowDate;

            // 当前用户综合行业其他信息(前一订单的综合行业id、用户该综合行业前一订单最后发券时间)
            String newTradeToOtherKey = DigestUtils.md5DigestAsHex(String.valueOf(consumerId).getBytes()).substring(0, 4) + "-" + consumerId + "-" + nowDate+"-str";
            List<String> allKeys = Lists.newArrayList(newTradeToLaunchKey, newTradeToOtherKey);

            Map<String, Result> map = new HashMap<>();
            DBTimeProfile.enter("hbaseResourceGet");

            // 先查询出所有数据
            hbaseTemplate.execute(CONSUMER_RESOURCE_FEATURE, table -> {
                List<Get> gets = allKeys.stream().map(rowKey -> new Get(rowKey.getBytes())).collect(Collectors.toList());
                Result[] results = table.get(gets);
                for (int i = 0; i < results.length; i++) {
                    Result result = results[i];
                    map.put(allKeys.get(i), result);
                }
                return null;
            });

            Result newTradeToLaunchResult = map.get(newTradeToLaunchKey);
            Map<String, Long> newTradeToLaunchMap = resolverResultValueToLong(newTradeToLaunchResult);

            Result result2 = map.get(newTradeToOtherKey);
            Map<String, String> newTradeLastGmtCreateTime = resolverResultValueToString(result2);

            // 设置上一单的综合行业id
            Optional.ofNullable(newTradeLastGmtCreateTime.get(OLD_NEW_TAG_TRADE_CODE)).ifPresent(consumerDo::setLastOperatingNewTrade);
            // 设置当前用户在不同综合行业上的发券量
            consumerDo.setNewTradeDayOrderRank(newTradeToLaunchMap);
            // 设置当前用户在不同综合行业上发券的订单时间
            consumerDo.setNewTradeLastGmtCreateTime(newTradeLastGmtCreateTime);
        } catch (Exception e) {
            LOGGER.warn("TradeRepetitionLaunchService.handTradeRepetitionLaunchStat error ", e);
        }finally {
            DBTimeProfile.release();
        }

    }

    // 将result解析成 map Value 为String
    private Map<String, String> resolverResultValueToString(Result result) {
        if(result==null || result.isEmpty()){
            return new HashMap<>();
        }
        List<Cell> cells = result.listCells();
        Map<String, String> map = new HashMap<>(cells.size());

        for (Cell cell : cells) {
            String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            map.put(qualifier, value);
        }
        return map;
    }

    // 将result解析成 map Value 为 Long
    private Map<String, Long> resolverResultValueToLong(Result result) {
        if(result==null ||result.isEmpty()){
            return new HashMap<>();
        }
        List<Cell> cells = result.listCells();
        Map<String, Long> map = new HashMap<>(cells.size());
        for (Cell cell : cells) {
            String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            map.put(qualifier, Long.valueOf(value));
        }
        return map;
    }

    /**
     * 处理用户画像相关数据
     * 下面代码比较绕 ，没办法数据部门存储就这样做的 ，见谅
     * @param advertRecommendRequestVo
     */
    public void handInterestPortrayalStat(AdvertRecommendRequestVo advertRecommendRequestVo) {
        try {
            Map<Long, Advert> advertMap = advertRecommendRequestVo.getAdvertMap();
            AppDo appDo = advertRecommendRequestVo.getAppDo();
            Collection<Advert> adverts = advertMap.values();

            List<String> allKeys = new ArrayList<>(adverts.size() * 6 + 6);
            Map<Advert,   Map<Boolean,Map<String, String>>> advertRowKeys = new HashMap<>(adverts.size());
            adverts.forEach(advert -> {

                //综合行业id
                Map<String, String> newTradeTagNumRowKeysMap = new HashMap<>(3);

                String newTradeTagId = advert.getNewTradeTagId();

                String newTradeTagIdLaunchKey = "1_launch_" + newTradeTagId;
                String newTradeTagIdClickKey = "1_click_" + newTradeTagId;
                String newTradeTagIdEffectKey = "1_effect_" + newTradeTagId;

                String newTradeTagIdLaunchRowKey = geMD5RowKey(newTradeTagIdLaunchKey);
                String newTradeTagIdClickRowKey = geMD5RowKey(newTradeTagIdClickKey);
                String newTradeTagIdEffectRowKey = geMD5RowKey(newTradeTagIdEffectKey);

                allKeys.add(newTradeTagIdLaunchRowKey);
                allKeys.add(newTradeTagIdClickRowKey);
                allKeys.add(newTradeTagIdEffectRowKey);

                newTradeTagNumRowKeysMap.put("launch", newTradeTagIdLaunchRowKey);
                newTradeTagNumRowKeysMap.put("click", newTradeTagIdClickRowKey);
                newTradeTagNumRowKeysMap.put("effect", newTradeTagIdEffectRowKey);


                //广告id
                Map<String, String> advertRowKeysMap = new HashMap<>(3);
                Long advertId = advert.getId();
                String advertLaunchKey = "4_launch_" + advertId;
                String advertClickKey = "4_click_" + advertId;
                String advertEffectKey = "4_effect_" + advertId;

                String advertLaunchRowKey = geMD5RowKey(advertLaunchKey);
                String advertClickRowKey = geMD5RowKey(advertClickKey);
                String advertEffectRowKey = geMD5RowKey(advertEffectKey);

                advertRowKeysMap.put("launch", advertLaunchRowKey);
                advertRowKeysMap.put("click", advertClickRowKey);
                advertRowKeysMap.put("effect", advertEffectRowKey);

                allKeys.add(advertLaunchRowKey);
                allKeys.add(advertClickRowKey);
                allKeys.add(advertEffectRowKey);

                //将 综合行业 和广告id 的rowkey 和advert关联起来
                Map<Boolean,Map<String, String>> isnewTradeTagNumRowKeysMap = new HashMap<>(2);
                isnewTradeTagNumRowKeysMap.put(true, newTradeTagNumRowKeysMap);
                isnewTradeTagNumRowKeysMap.put(false, advertRowKeysMap);
                advertRowKeys.put(advert, isnewTradeTagNumRowKeysMap);
            });

            // 媒体行业id
            Map<String, String> appTradeRowKeysMap = new HashMap<>(3);
            String industryTagPid = appDo.getIndustryTagPid();
            String industryTagPidLaunchKey = "2_launch_" + industryTagPid;
            String industryTagPidClickKey = "2_click_" + industryTagPid;
            String industryTagPidEffectKey = "2_effect_" + industryTagPid;

            String newTradeTagNumLaunchRowKey = geMD5RowKey(industryTagPidLaunchKey);
            String newTradeTagNumClickRowKey = geMD5RowKey(industryTagPidClickKey);
            String newTradeTagNumEffectRowKey = geMD5RowKey(industryTagPidEffectKey);

            allKeys.add(newTradeTagNumLaunchRowKey);
            allKeys.add(newTradeTagNumClickRowKey);
            allKeys.add(newTradeTagNumEffectRowKey);

            appTradeRowKeysMap.put("launch", newTradeTagNumLaunchRowKey);
            appTradeRowKeysMap.put("click", newTradeTagNumClickRowKey);
            appTradeRowKeysMap.put("effect", newTradeTagNumEffectRowKey);

            // 媒体id
            Map<String, String> appRowKeysMap = new HashMap<>(3);
            Long appId = appDo.getId();
            String appLaunchKey = "3_launch_" + appId;
            String appClickKey = "3_click_" + appId;
            String appEffectKey = "3_effect_" + appId;

            String appLaunchRowKey = geMD5RowKey(appLaunchKey);
            String appClickRowKey = geMD5RowKey(appClickKey);
            String appEffectRowKey = geMD5RowKey(appEffectKey);

            allKeys.add(appLaunchRowKey);
            allKeys.add(appClickRowKey);
            allKeys.add(appEffectRowKey);

            appRowKeysMap.put("launch", appLaunchRowKey);
            appRowKeysMap.put("click", appClickRowKey);
            appRowKeysMap.put("effect", appEffectRowKey);

            //媒体 和媒体行业 相关数据
            Map<Boolean,Map<String, String>> isAppTradeRowKeysMap = new HashMap<>(2);
            isAppTradeRowKeysMap.put(true, appTradeRowKeysMap);
            isAppTradeRowKeysMap.put(false, appRowKeysMap);


            // 查询缓存 hbase 获取 所有画像数据
            Map<String, Map<String, Long>> handInterestPortrayalStatMap = handInterestPortrayalStat.getAll(allKeys);

            // 这时候开始组装了，根据所有rowkeymap和 hbase中查询出来的key数据 匹配映射然后 设置到 advert 和advertRecommendRequestVo 中后面会使用
            bindhandInterestPortrayalDynamicStat(adverts, advertRowKeys, handInterestPortrayalStatMap);

            bindhandInterestPortrayalStaticStat(advertRecommendRequestVo, isAppTradeRowKeysMap, handInterestPortrayalStatMap);

        } catch (Exception e) {
            LOGGER.warn("TradeRepetitionLaunchService.handInterestPortrayalStat error", e);
        }

    }

    private void  bindhandInterestPortrayalStaticStat(AdvertRecommendRequestVo advertRecommendRequestVo,
                                                      Map<Boolean, Map<String, String>> isAppTradeRowKeysMap,
                                                      Map<String, Map<String, Long>> handInterestPortrayalStatMap) {

        Map<String, String> appTradeRowKeysMap = isAppTradeRowKeysMap.get(true);
        Map<String, String> appRowKeysMap = isAppTradeRowKeysMap.get(false);

        Map<String, Map<String, Long>> appTradeStatMap = MapUtils.translate(appTradeRowKeysMap, handInterestPortrayalStatMap);
        Map<String, Map<String, Long>> appStatMap = MapUtils.translate(appRowKeysMap, handInterestPortrayalStatMap);
        advertRecommendRequestVo.setAppTagInNewTrade(appTradeStatMap);
        advertRecommendRequestVo.setAppInNewTrade(appStatMap);

    }

    private void bindhandInterestPortrayalDynamicStat(Collection<Advert> adverts,
                                                     Map<Advert, Map<Boolean,Map<String, String>>> advertRowKeys,
                                                     Map<String, Map<String, Long>> handInterestPortrayalStatMap) {

        adverts.forEach(advert -> {
            Map<Boolean, Map<String, String>> rowKeysMap = advertRowKeys.get(advert);
            Map<String, String> newTradeTagIdRowKeysMap = rowKeysMap.get(true);
            Map<String, String> advertRowKeysMap = rowKeysMap.get(false);
            Map<String, Map<String, Long>> newTradeTagIdStatMap = MapUtils.translate(newTradeTagIdRowKeysMap, handInterestPortrayalStatMap);
            Map<String, Map<String, Long>> advertStatMap = MapUtils.translate(advertRowKeysMap, handInterestPortrayalStatMap);

            advert.setNewTradeInAppTag(newTradeTagIdStatMap);
            advert.setAdvertInAppTag(advertStatMap);
        });
    }


    /**
     * 用户画像 各个维度指标数据
     */
    private LoadingCache<String, Map<String, Long>> handInterestPortrayalStat = CacheBuilder.newBuilder()
            .expireAfterWrite(5L, TimeUnit.MINUTES)
            .build(new CacheLoader<String, Map<String, Long>>() {
                @Override
                public Map<String, Long> load(String key) throws Exception {
                    throw new UnsupportedOperationException("not support single query");
                }

                @Override
                public Map<String, Map<String, Long>> loadAll(Iterable<? extends String> keys) throws Exception {
                    return gethandInterestPortrayalStat(keys);
                }
            });

    private Map<String, Map<String, Long>> gethandInterestPortrayalStat(Iterable<? extends String> keys) {
        List<String> allKeys = Lists.newArrayList(keys);
        Map<String, Map<String, Long>> returnMap = Maps.newHashMapWithExpectedSize(allKeys.size());
        DBTimeProfile.enter("hbaseResourceGet");
        try {
            hbaseTemplate.execute(TB_TRADE_FEATURE_DI, table -> {
                List<Get> gets = allKeys.stream().map(rowKey -> new Get(rowKey.getBytes())).collect(Collectors.toList());
                Result[] results = table.get(gets);

                for (int i = 0; i < results.length; i++) {
                    Result result = results[i];
                    if (result==null || result.isEmpty()){
                        returnMap.put(allKeys.get(i), new HashMap<>());
                        continue;
                    }
                    List<Cell> cells = result.listCells();
                    Map<String, Long> resultMap = Maps.newHashMapWithExpectedSize(cells.size());
                    for (Cell cell : cells) {
                        String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                        String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());

                        resultMap.put(qualifier, Long.valueOf(value));
                    }

                    returnMap.put(allKeys.get(i), resultMap);
                }
                return null;
            });
        } catch (Exception e) {
            LOGGER.warn("TradeRepetitionLaunchService.gethandInterestPortrayalStat happend error", e);
        }finally {
            DBTimeProfile.release();
        }
        return returnMap;
    }

    @NotNull
    private String geMD5RowKey(String newTradeTagNumLaunchKey) {
        return DigestUtils.md5DigestAsHex(newTradeTagNumLaunchKey.getBytes()).substring(0, 4) + "-" + newTradeTagNumLaunchKey;
    }
}
