package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.alg.common.model.pacing.AdvertOrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.ResultType;
import cn.com.duiba.nezha.alg.common.model.pacing.HelpBySelfParams;
import cn.com.duiba.nezha.alg.common.model.pacing.HelpBySelf;
import cn.com.duiba.nezha.alg.common.model.pacing.HelpMeasureResult;
import cn.com.duiba.nezha.alg.common.model.pacing.SlotRecommender;
import cn.com.duiba.nezha.alg.common.model.pacing.TrusteeshipParams;
import cn.com.duiba.nezha.engine.api.dto.FusingOrientationPackageDto;
import cn.com.duiba.nezha.engine.api.dto.RecommendAppDto;
import cn.com.duiba.nezha.engine.api.dto.RescureDto;
import cn.com.duiba.nezha.engine.api.dto.RescureSlotDto;
import cn.com.duiba.nezha.engine.api.dto.RescureAppDto;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatDo;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AlgoRescureEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.SlotAdvertInfo;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDate;

import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;

import static java.util.stream.Collectors.partitioningBy;
import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toMap;
import static java.util.stream.Collectors.toSet;

@Service
@RefreshScope
public class TrusteeshipRecommendService extends CacheService {

    @Value("${trusteeship.white}")
    private String white;

    private LoadingCache<String, TrusteeshipParams> trusteeshipParamsCache = CacheBuilder.newBuilder().refreshAfterWrite(10, TimeUnit.MINUTES)
            .build(new CacheLoader<String, TrusteeshipParams>() {
                @Override
                public TrusteeshipParams load(String key) {
                    return Optional.ofNullable(nezhaStringRedisTemplate.opsForValue().get(RedisKeyUtil.getTrusteeshipParamsKey()))
                            .map(json -> JSON.parseObject(json, TrusteeshipParams.class))
                            .orElseGet(TrusteeshipParams::new);
                }

                @Override
                public ListenableFuture<TrusteeshipParams> reload(String key, TrusteeshipParams oldValue) throws Exception {
                    ListenableFutureTask<TrusteeshipParams> task = ListenableFutureTask.create(() -> load(key));
                    executorService.submit(task);
                    return task;
                }
            });

    private LoadingCache<String, AdvertStatDo> packageDataCache = CacheBuilder.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build(new CacheLoader<String, AdvertStatDo>() {
                @Override
                public AdvertStatDo load(String key) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
                }
            });

    private LoadingCache<String, SlotAdvertInfo> slotAdvertCache = CacheBuilder.newBuilder()
            .expireAfterWrite(10L, TimeUnit.MINUTES)
            .recordStats()
            .build(new CacheLoader<String, SlotAdvertInfo>() {
                @Override
                public SlotAdvertInfo load(String key) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, SlotAdvertInfo> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, SlotAdvertInfo.class, SlotAdvertInfo::new);
                }
            });
    private LoadingCache<String, AdvertStatDo> slotPackageDataCache = CacheBuilder.newBuilder()
            .expireAfterWrite(1L, TimeUnit.MINUTES)
            .build(new CacheLoader<String, AdvertStatDo>() {
                @Override
                public AdvertStatDo load(String key) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
                }
            });

    private LoadingCache<String, AdvertStatDo> slotAdvertDataCache = CacheBuilder.newBuilder()
            .expireAfterWrite(1L, TimeUnit.MINUTES)
            .build(new CacheLoader<String, AdvertStatDo>() {
                @Override
                public AdvertStatDo load(String key) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
                }
            });

    private LoadingCache<String, RescureDto> rescureOrientDataCache = CacheBuilder.newBuilder()
            .expireAfterWrite(5L, TimeUnit.MINUTES)
            .build(new CacheLoader<String, RescureDto>() {
                @Override
                public RescureDto load(String key) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, RescureDto> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, RescureDto.class, RescureDto::new);
                }
            });

    private LoadingCache<String, RescureAppDto> rescureOrientAppDataCache = CacheBuilder.newBuilder()
            .expireAfterWrite(5L, TimeUnit.MINUTES)
            .build(new CacheLoader<String, RescureAppDto>() {
                @Override
                public RescureAppDto load(String key) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, RescureAppDto> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, RescureAppDto.class, RescureAppDto::new);
                }
            });

    private LoadingCache<String, RescureSlotDto> rescureOrientSlotDataCache = CacheBuilder.newBuilder()
            .expireAfterWrite(5L, TimeUnit.MINUTES)
            .build(new CacheLoader<String, RescureSlotDto>() {
                @Override
                public RescureSlotDto load(String key) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, RescureSlotDto> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, RescureSlotDto.class, RescureSlotDto::new);
                }
            });

    /**
     * 算法参数缓存 每天更新一次
     */
    private LoadingCache<String, HelpBySelfParams> helpBySelfParamsCache = CacheBuilder.newBuilder()
            .expireAfterWrite(1, TimeUnit.HOURS)
            .build(new CacheLoader<String, HelpBySelfParams>() {
                @Override
                public HelpBySelfParams load(String key) throws Exception {
                    return Optional.ofNullable(nezhaStringRedisTemplate.opsForValue().get(key))
                            .map(json -> JSON.parseObject(json, HelpBySelfParams.class)).orElse(new HelpBySelfParams());
                }

                @Override
                public Map<String, HelpBySelfParams> loadAll(Iterable<? extends String> keys) throws Exception {
                    throw new IllegalAccessException("not suppose multi query");
                }
            });

    public Set<OrientationPackage>  giveUpRescurePackage(Set<OrientationPackage> orientationPackages) {
        try {
            HelpBySelfParams helpBySelfParams = helpBySelfParamsCache.get(RedisKeyUtil.getHelpbyselfParamsKey());

            if (Math.random() < 0.0001) {
                logger.info("Params helpBySelfParams", JSONObject.toJSONString(helpBySelfParams));
            }
            List<OrientationPackage> trusteeshipGiveUpPackages = orientationPackages.stream()
                    .filter(orientationPackage -> orientationPackage.getBasePriceException() != null &&  orientationPackage.getBasePriceException() == true)
                    .filter(orientationPackage -> HelpBySelf.isGiveUpBaseFlow(orientationPackage.getFinalFee(), true,helpBySelfParams) == true)
                    .collect(toList());
            Set<OrientationPackage> allPackage = new HashSet<>();

            if (trusteeshipGiveUpPackages != null) {
                logger.info("rescure give up package size: " + trusteeshipGiveUpPackages.size());
                allPackage.addAll(trusteeshipGiveUpPackages);
            }

            return allPackage;
        } catch (Exception e) {
            logger.error("giveUpRescurePackage error", e);
            return new HashSet<>();
        }
    }

    public Set<OrientationPackage> recommend(Set<OrientationPackage> orientationPackages, AdvertRecommendRequestVo advertRecommendRequestVo) {

        AppDo appDo = advertRecommendRequestVo.getAppDo();
        Long appId = appDo.getId();
        Long slotId = appDo.getSlotId();

        // 根据是否强弱定向来分组
        Map<Boolean, List<OrientationPackage>> partByTargetType = orientationPackages.stream().collect(partitioningBy(OrientationPackage::getStrongTarget));
        List<OrientationPackage> strongTargetPackages = partByTargetType.getOrDefault(true, new ArrayList<>());
        List<OrientationPackage> weakTargetOrientationPackages = partByTargetType.getOrDefault(false, new ArrayList<>());

        try {
            DBTimeProfile.enter("handleTrusteeshipAdvert");
            Set<Long> whiteAdvertIds;
            if (StringUtils.isEmpty(white)) {//todo 可以考虑在注入的时候切割好
                whiteAdvertIds = new HashSet<>();
            } else {
                whiteAdvertIds = Stream.of(white.split(",")).map(Long::parseLong).collect(toSet());
            }


            Set<Long> trusteeshipAdvertIds = weakTargetOrientationPackages.stream().map(OrientationPackage::getAdvertId).collect(toSet());

            // 获取自动托管参数
            TrusteeshipParams trusteeshipParams = trusteeshipParamsCache.getUnchecked(RedisKeyUtil.getTrusteeshipParamsKey());

            // 获取弱定向配置包的配置数据(熔断之后会重置)
            Map<OrientationPackage, AdvertStatDo> packageAdvertStatDoMap = this.getPackageData(weakTargetOrientationPackages);

            // 获取托管自救算法数据
            Map<OrientationPackage,RescureDto>  packageRescureDtoMap = this.getRescurePackageData(weakTargetOrientationPackages);

            // 获取托管自救媒体数据
            Map<OrientationPackage,RescureAppDto>  packageRescureAppDtoMap = this.getRescureAppPackageData(weakTargetOrientationPackages,appId);

            // 获取托管自救广告位数据
            Map<OrientationPackage,RescureSlotDto>  packageRescureSlotDtoMap = this.getRescureSlotPackageData(weakTargetOrientationPackages,slotId);

            // 获取候选集
            Map<Long, SlotAdvertInfo> advertSlotInfoMap = this.getSlotAdvertInfo(trusteeshipAdvertIds, slotId);


            // 自动托管配置在广告位上的数据
            Map<OrientationPackage, AdvertStatDo> orientationSlotDataMap = this.getSlotPackageData(weakTargetOrientationPackages, slotId);

            Map<Long, AdvertStatDo> advertSlotDataMap = this.getSlotAdvertData(trusteeshipAdvertIds, slotId);

                List<OrientInfo> trusteeshipOrientInfoList = weakTargetOrientationPackages.stream().map(orientationPackage -> {
                Integer cvrType = orientationPackage.getCvrType();
                Long advertId = orientationPackage.getAdvertId();

                SlotAdvertInfo slotAdvertInfo = advertSlotInfoMap.get(advertId);
                List<Double> biasSet = slotAdvertInfo.getBiasSet();
                List<Double> cvrSet = slotAdvertInfo.getCvrSet();
                Double cost20d = slotAdvertInfo.getCost20d();
                AdvertStatDo packageStatDo = packageAdvertStatDoMap.get(orientationPackage);

                OrientInfo orientInfo = new OrientInfo();

                //系统自救参数
                RescureDto rescureDto = packageRescureDtoMap.get(orientationPackage);
                HelpMeasureResult helpMeasureResult = new HelpMeasureResult();
                helpMeasureResult.setExpand(rescureDto.getExpand());
                helpMeasureResult.setOrientRatioWeight(rescureDto.getOrientRatioWeight());
                helpMeasureResult.setIsReorient(rescureDto.getIsReorient());
                helpMeasureResult.setIsBlackRealse(rescureDto.getIsBlackRealse());
                orientInfo.setHelpMeasureResult(helpMeasureResult);

                orientInfo.setAdvertId(advertId);
                orientInfo.setOrientId(orientationPackage.getId());
                orientInfo.setCvrSet(cvrSet);
                orientInfo.setBiasSet(biasSet);
                orientInfo.setManagered(true);
                orientInfo.setCost20d(cost20d);
                orientInfo.setManageType(orientationPackage.getTargetAppLimit());
                orientInfo.setChargeType(orientationPackage.getChargeType());
                orientInfo.setTarget(orientationPackage.getConvertCost());
                orientInfo.setFee(orientationPackage.getClickFee());
                orientInfo.setAppOrientationConvert(orientationPackage.getTodayAppStatisticData().getConvertCount().doubleValue());
                orientInfo.setAppOrientationCost(orientationPackage.getTodayAppStatisticData().getTotalConsume().doubleValue());
                orientInfo.setOrientCostG1d(packageStatDo.getChargeFees().doubleValue());
                orientInfo.setOrientConvertG1d(packageStatDo.getActClickCnt(cvrType).doubleValue());
                orientInfo.setReleaseTarget(orientationPackage.getReleaseTarget());
                orientInfo.setCvrType(orientationPackage.getCvrType());
                orientInfo.setImportantAppAfee(orientationPackage.getImportantAppFee());
                orientInfo.setFuseWhite(whiteAdvertIds.contains(advertId));


                //算法自救
                RescureAppDto rescureAppDto = packageRescureAppDtoMap.get(orientationPackage);
                orientationPackage.setFeeWeightFactor(rescureAppDto.getFeeWeightFactor());

                RescureSlotDto rescureSlotDto = packageRescureSlotDtoMap.get(orientationPackage);
                orientationPackage.setFeeWeightFactor(rescureSlotDto.getFeeWeightFactor());
                orientationPackage.setBasePriceException(rescureSlotDto.getBasePriceException());

                if (rescureAppDto.getFeeWeightFactor() != null && rescureSlotDto.getFeeWeightFactor() != null) {
                    orientationPackage.setFeeWeightFactor(Math.max(rescureAppDto.getFeeWeightFactor(),rescureSlotDto.getFeeWeightFactor()));
                }

                AlgoRescureEntity algoRescureEntity = this.getRescureEntity(rescureDto,rescureSlotDto,rescureAppDto);
                orientationPackage.setAlgoRescureEntity(algoRescureEntity);

                Optional.ofNullable(orientationPackage.getRecently7DayStatisticData()).map(statisticData -> statisticData.getTotalConsume().doubleValue()).ifPresent(orientInfo::setOrientCostG7d);
                Optional.ofNullable(orientationPackage.getTodayAppStatisticData()).map(StatisticData::getCvr).ifPresent(orientInfo::setAppOrientCvrDay);

                // 设置配置包在广告位上的消耗信息
                Optional.ofNullable(orientationSlotDataMap.get(orientationPackage)).ifPresent(slotPackageData -> {
                    orientInfo.setSlotOrientationConvert(slotPackageData.getActClickCnt(cvrType).doubleValue());
                    orientInfo.setSlotOrientationCost(slotPackageData.getChargeFees().doubleValue());
                });

                // 设置广告在广告位上的消耗信息
                Optional.ofNullable(advertSlotDataMap.get(advertId)).ifPresent(slotAdvertData -> {
                    orientInfo.setSlotAdvertConvert(slotAdvertData.getActClickCnt(cvrType).doubleValue());
                    orientInfo.setSlotAdvertCost(slotAdvertData.getChargeFees().doubleValue());
                });

                return orientInfo;
            }).collect(toList());
            //算法 对弱定向进行推荐
            Map<ResultType, Collection<AdvertOrientInfo>> trusteeshipRecommendResult = SlotRecommender.recommend(trusteeshipOrientInfoList, slotId, trusteeshipParams);
            Map<AdvertOrientInfo, OrientationPackage> packageMap = weakTargetOrientationPackages
                    .stream()
                    .collect(toMap(orientationPackage -> new AdvertOrientInfo(orientationPackage.getAdvertId(), orientationPackage.getId()), Function.identity()));


            List<OrientationPackage> trusteeshipOnTargetPackages = trusteeshipRecommendResult
                    .getOrDefault(ResultType.ONTARGET, new ArrayList<>())
                    .stream()
                    .map(packageMap::get)
                    .collect(toList());

            List<OrientationPackage> trusteeshipGiveUpPackages = trusteeshipRecommendResult
                    .getOrDefault(ResultType.GIVEUP, new ArrayList<>())
                    .stream()
                    .map(packageMap::get)
                    .collect(toList());

            this.handlerTrusteeshipResult(appId, advertRecommendRequestVo, trusteeshipRecommendResult);// 返回给业务系统做推荐使用 todo 可以采样返回


            Set<OrientationPackage> allPackage = new HashSet<>(strongTargetPackages);
            allPackage.addAll(trusteeshipOnTargetPackages);
            allPackage.addAll(trusteeshipGiveUpPackages);
            allPackage.forEach(orientationPackage -> orientationPackage.setSmartShop(trusteeshipGiveUpPackages.contains(orientationPackage)));//放弃的流量走智能采买

            return allPackage;
        } catch (Exception e) {
            logger.error("handleTrusteeshipAdvert error", e);
            return new HashSet<>(strongTargetPackages);
        } finally {
            DBTimeProfile.release();
        }
    }

    private AlgoRescureEntity getRescureEntity(RescureDto rescureDto,  RescureSlotDto rescureSlotDto, RescureAppDto rescureAppDto) {
        AlgoRescureEntity algoRescureEntity = new AlgoRescureEntity();
        Optional.ofNullable(rescureDto.getExpand()).ifPresent(obj -> {
            algoRescureEntity.setCostException(rescureDto.getCostException());
            algoRescureEntity.setCostConvertException(rescureDto.getCostConvertException());
            algoRescureEntity.setFatalException(rescureDto.getFatalException());
            algoRescureEntity.setHelpBySelfType(rescureDto.getHelpBySelfType());
            algoRescureEntity.setExpand(rescureDto.getExpand());
            algoRescureEntity.setOrientRatioWeight(rescureDto.getOrientRatioWeight());
            algoRescureEntity.setIsReorient(rescureDto.getIsReorient());
            algoRescureEntity.setIsBlackRealse(rescureDto.getIsBlackRealse());
            algoRescureEntity.setRemindAE1(rescureDto.getRemindAE());
            algoRescureEntity.setResetStableFactor(rescureDto.getResetStableFactor());
        });

        Optional.ofNullable(rescureSlotDto.getBasePriceException()).ifPresent(obj -> {
            algoRescureEntity.setFeeWeightFactor0(rescureSlotDto.getFeeWeightFactor());
            algoRescureEntity.setBasePriceException(rescureSlotDto.getBasePriceException());
            algoRescureEntity.setRemindAE2(rescureSlotDto.getRemindAE());
        });

        Optional.ofNullable(rescureAppDto.getCancelStableRelate()).ifPresent(obj -> {
            algoRescureEntity.setFeeWeightFactor1(rescureAppDto.getFeeWeightFactor());
            algoRescureEntity.setCancelStableRelate(rescureAppDto.getCancelStableRelate());
        });
        return algoRescureEntity;
    }

    private Map<OrientationPackage, AdvertStatDo> getPackageData(Collection<OrientationPackage> weakTargetOrientationPackages) {
        try {
            DBTimeProfile.enter("getPackageData");
            Map<OrientationPackage, String> packageKeysMap = weakTargetOrientationPackages.stream()
                    .collect(toMap(Function.identity(), orientationPackage ->
                            RedisKeyUtil.getOrientationPackageData(
                                    orientationPackage.getAdvertId(),
                                    orientationPackage.getId(),
                                    LocalDate.now().format(DAY_FORMATTER))));

            return MapUtils.translate(packageKeysMap, packageDataCache.getAll(packageKeysMap.values()));

        } catch (ExecutionException e) {
            throw new RecommendEngineException("getPackageData error", e);
        } finally {
            DBTimeProfile.release();
        }
    }

    private Map<OrientationPackage, RescureDto> getRescurePackageData(Collection<OrientationPackage> weakTargetOrientationPackages) {
        try {
            DBTimeProfile.enter("getRescurePackageData");
            Map<OrientationPackage, String> packageRescureKeysMap = weakTargetOrientationPackages.stream()
                    .collect(toMap(Function.identity(), orientationPackage ->
                            RedisKeyUtil.getNezhaRescureKey(
                                    orientationPackage.getAdvertId(),
                                    orientationPackage.getId())));

            return MapUtils.translate(packageRescureKeysMap, rescureOrientDataCache.getAll(packageRescureKeysMap.values()));
        }catch (ExecutionException e) {
            throw new RecommendEngineException("getRescurePackageData error", e);
        } finally {
            DBTimeProfile.release();
        }
    }

    private Map<OrientationPackage, RescureAppDto> getRescureAppPackageData(Collection<OrientationPackage> weakTargetOrientationPackages, Long appId) {
        try {
            DBTimeProfile.enter("getRescureAppPackageData");
            Map<OrientationPackage, String> packageRescureKeysMap = weakTargetOrientationPackages.stream()
                    .collect(toMap(Function.identity(), orientationPackage ->
                            RedisKeyUtil.getNezhaRescureAppKey(
                                    orientationPackage.getAdvertId(),
                                    orientationPackage.getId(),
                                    appId)));

            return MapUtils.translate(packageRescureKeysMap, rescureOrientAppDataCache.getAll(packageRescureKeysMap.values()));
        }catch (ExecutionException e) {
            throw new RecommendEngineException("getRescureAppPackageData error", e);
        } finally {
            DBTimeProfile.release();
        }
    }

    private Map<OrientationPackage, RescureSlotDto> getRescureSlotPackageData(Collection<OrientationPackage> weakTargetOrientationPackages, Long slotId) {
        try {
            DBTimeProfile.enter("getRescureSlotPackageData");
            Map<OrientationPackage, String> packageRescureKeysMap = weakTargetOrientationPackages.stream()
                    .collect(toMap(Function.identity(), orientationPackage ->
                            RedisKeyUtil.getNezhaRescureSlotKey(
                                    orientationPackage.getAdvertId(),
                                    orientationPackage.getId(),
                                    slotId)));

            return MapUtils.translate(packageRescureKeysMap, rescureOrientSlotDataCache.getAll(packageRescureKeysMap.values()));
        }catch (ExecutionException e) {
            throw new RecommendEngineException("getRescureSlotPackageData error", e);
        } finally {
            DBTimeProfile.release();
        }
    }

    private Map<Long, SlotAdvertInfo> getSlotAdvertInfo(Collection<Long> advertIds, Long slotId) {
        try {
            DBTimeProfile.enter("AdvertStatService.getSlotAdvertInfo");
            Map<Long, String> advertKeyMap = advertIds.stream()
                    .collect(toMap(Function.identity(),
                            advertId -> RedisKeyUtil.getSlotAdvertInfoKey(slotId, advertId)));

            ImmutableMap<String, SlotAdvertInfo> keySlotAdvertInfoMap = slotAdvertCache.getAll(advertKeyMap.values());
            return MapUtils.translate(advertKeyMap, keySlotAdvertInfoMap);
        } catch (Exception e) {
            throw new RecommendEngineException("getSlotAdvertInfo error", e);
        } finally {
            DBTimeProfile.release();
        }

    }

    private Map<OrientationPackage, AdvertStatDo> getSlotPackageData(Collection<OrientationPackage> trusteeshipOrientationPackages, Long slotId) {

        try {
            DBTimeProfile.enter("AdvertStatService.getSlotPackageData");
            String todayDate = LocalDate.now().format(DAY_FORMATTER);
            Map<OrientationPackage, String> orientationPackageKeyMap = trusteeshipOrientationPackages.stream()
                    .collect(toMap(Function.identity(),
                            orientationPackage -> RedisKeyUtil
                                    .getSlotPackageDataKey(
                                            slotId,
                                            orientationPackage.getAdvertId(),
                                            orientationPackage.getId(),
                                            orientationPackage.getConvertCost(),
                                            todayDate)));
            return MapUtils.translate(orientationPackageKeyMap, slotPackageDataCache.getAll(orientationPackageKeyMap.values()));
        } catch (ExecutionException e) {
            throw new RecommendEngineException("getSlotPackageBlackInfo error", e);
        } finally {
            DBTimeProfile.release();
        }
    }

    private Map<Long, AdvertStatDo> getSlotAdvertData(Collection<Long> advertIds, Long slotId) {

        try {
            DBTimeProfile.enter("AdvertStatService.getSlotPackageData");
            String todayDate = LocalDate.now().format(DAY_FORMATTER);
            Map<Long, String> advertIdKeyMap = advertIds.stream()
                    .collect(toMap(Function.identity(),
                            advertId -> RedisKeyUtil
                                    .getSlotAdvertDataKey(
                                            slotId,
                                            advertId,
                                            todayDate)));
            return MapUtils.translate(advertIdKeyMap, slotAdvertDataCache.getAll(advertIdKeyMap.values()));
        } catch (ExecutionException e) {
            throw new RecommendEngineException("getSlotPackageBlackInfo error", e);
        } finally {
            DBTimeProfile.release();
        }
    }

    private void handlerTrusteeshipResult(Long appId, AdvertRecommendRequestVo advertRecommendRequestVo, Map<ResultType, Collection<AdvertOrientInfo>> trusteeshipRecommendResult) {

        Set<FusingOrientationPackageDto> fuse1PackageDto = trusteeshipRecommendResult
                .getOrDefault(ResultType.FUSE1, new ArrayList<>())
                .stream()
                .map(advertOrientInfo -> this.convert(advertOrientInfo, 2))
                .collect(toSet());

        Set<FusingOrientationPackageDto> fuse2PackageDto = trusteeshipRecommendResult
                .getOrDefault(ResultType.FUSE2, new ArrayList<>())
                .stream()
                .map(advertOrientInfo -> this.convert(advertOrientInfo, 1))
                .collect(toSet());

        fuse1PackageDto.addAll(fuse2PackageDto);
        advertRecommendRequestVo.setFusingOrientationPackages(fuse1PackageDto);


        Set<RecommendAppDto> recommendTargetAppDto = trusteeshipRecommendResult
                .getOrDefault(ResultType.ORIENT, new ArrayList<>())
                .stream()
                .map(advertOrientInfo -> this.convert(advertOrientInfo, appId, 1))
                .collect(toSet());

        Set<RecommendAppDto> recommendLimitAppDto = trusteeshipRecommendResult
                .getOrDefault(ResultType.SHIELD, new ArrayList<>())
                .stream()
                .map(advertOrientInfo -> this.convert(advertOrientInfo, appId, 2))
                .collect(toSet());

        recommendTargetAppDto.addAll(recommendLimitAppDto);

        advertRecommendRequestVo.setRecommendApps(recommendTargetAppDto);
    }

    private RecommendAppDto convert(AdvertOrientInfo advertOrientInfo, Long appId, Integer type) {
        RecommendAppDto recommendAppDto = new RecommendAppDto();
        recommendAppDto.setAdvertId(advertOrientInfo.getAdvertId());
        recommendAppDto.setAppId(appId);
        recommendAppDto.setPackageId(advertOrientInfo.getOrientId());
        recommendAppDto.setBias(advertOrientInfo.getCostConvertBias());
        recommendAppDto.setType(type);
        return recommendAppDto;
    }

    private FusingOrientationPackageDto convert(AdvertOrientInfo advertOrientInfo, Integer type) {
        FusingOrientationPackageDto fusingOrientationPackageDto = new FusingOrientationPackageDto();
        fusingOrientationPackageDto.setType(type);
        fusingOrientationPackageDto.setId(advertOrientInfo.getOrientId());
        fusingOrientationPackageDto.setAdvertId(advertOrientInfo.getAdvertId());
        return fusingOrientationPackageDto;
    }
}
