package cn.com.duiba.nezha.engine.biz.service.advert.ctr.impl;

import cn.com.duiba.nezha.alg.alg.vo.BiddingRateDo;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.NewAdvertSupportService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Service
public class NewAdvertSupportServiceImpl extends CacheService implements NewAdvertSupportService {

    private LoadingCache<BiddingKey, Stat> newAdvertStatecache = CacheBuilder.newBuilder().expireAfterWrite(12, TimeUnit.HOURS).build(new CacheLoader<BiddingKey, Stat>() {
        @Override
        public Stat load(BiddingKey key) throws Exception {
            Stat stat1 = new Stat();
            stat1.setInComing(new AtomicLong(0));
            stat1.setOutGoing(new AtomicLong(0));
            return stat1;
        }
    });



    // 插入发券的广告的不同维度
    @Override
    public void insertOutGoing(OrientationPackage orientationPackage, Long slotId) {
        try {
            DBTimeProfile.enter("insertOutGoing");

            // 广告维度:
            BiddingKey advertKey = new BiddingKey();
            advertKey.setAdvertId(orientationPackage.getAdvertId());
            advertKey.setSlotId(slotId);

            insertNewAdvertStatecache(advertKey);

            // 广告配置维度:
            BiddingKey advertAndOrientationKey = new BiddingKey();
            advertAndOrientationKey.setAdvertId(orientationPackage.getAdvertId());
            advertAndOrientationKey.setSlotId(slotId);
            advertAndOrientationKey.setOrientationId(orientationPackage.getId());

            insertNewAdvertStatecache(advertAndOrientationKey);

            // 行业维度:
            BiddingKey tradeAndSlotKey = new BiddingKey();
            tradeAndSlotKey.setNewTradeTagNum(orientationPackage.getNewTradeTagNum());
            tradeAndSlotKey.setSlotId(slotId);

            insertNewAdvertStatecache(tradeAndSlotKey);

            // 广告位维度
            BiddingKey slotKey = new BiddingKey();
            slotKey.setSlotId(slotId);

            insertNewAdvertStatecache(slotKey);


        } catch (Exception e) {
            logger.error("newAdvertStateCache error :{}", e);
            throw new RecommendEngineException("get newAdvertStateCache error", e);
        } finally {
            DBTimeProfile.release();
        }


    }

    @Override
    public void incrBidingCount(BiddingKey advertKey, long size) {
        try {
            Stat stat = newAdvertStatecache.get(advertKey);
            stat.getInComing().getAndAdd(size);
        } catch (Exception e) {
            logger.error("incrBidingCount error :{}", e);
            throw new RecommendEngineException("incrBidingCount error", e);
        }

    }

    @Override
    public BiddingRateDo getBiddingRate(BiddingKey advertKey) {
        try {
            double advertRate;
            Stat stat = newAdvertStatecache.get(advertKey);
            long inComing = stat.getInComing().get();
            if (inComing == 0) {
                advertRate = 0d;
            } else {
                advertRate = stat.getOutGoing().doubleValue() / inComing;
            }

            return new BiddingRateDo(stat.getOutGoing().longValue(), inComing, advertRate);
        } catch (Exception e) {
            logger.error("getBiddingRate error :{}", e);
            throw new RecommendEngineException("get getBiddingRate error", e);
        }

    }

    public void insertNewAdvertStatecache(BiddingKey advertKey) {
        try {
            Stat stat = new Stat();
            stat = newAdvertStatecache.get(advertKey);
            stat.getOutGoing().getAndAdd(1L);
        } catch (Exception e) {
            logger.error("insertNewAdvertStatecache error :{}", e);
            throw new RecommendEngineException("insertNewAdvertStatecache error", e);
        }
    }

    @Override
    public Map<BiddingKey, Stat> getCacheInfo() {
        return newAdvertStatecache.asMap();
    }

}
