package cn.com.duiba.nezha.engine.biz.service.advert.engine.impl;

import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.engine.EncourageArpuOneService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

@Service
public class EncourageArpuOneServiceImpl extends CacheService implements EncourageArpuOneService {

    private LoadingCache<String, Double> encourageCache = CacheBuilder.newBuilder()
            .expireAfterAccess(3, TimeUnit.MINUTES).build(new CacheLoader<String, Double>() {
                @Override
                public Double load(String key) throws Exception {
                    return -1d;
                }
            });


    @Override
    public void insertArpu(String orderId, Double arpu) {

        encourageCache.put(orderId, arpu);
    }

    @Override
    public Double getArpuByOrderId(String orderId) {
        try{

            if(StringUtils.isEmpty(orderId)){
                return null;
            }
            return encourageCache.get(orderId);
        }catch (Exception e){
            logger.error("EncourageArpuOneServiceImpl.getArpuByOrderId error :{}", e);
            throw new RecommendEngineException("get getArpuByOrderId error", e);
        }

    }
}
