package cn.com.duiba.nezha.engine.biz.service.advert.support;

import cn.com.duiba.nezha.alg.alg.alg.NewAdvertSupportAlg;
import cn.com.duiba.nezha.alg.alg.vo.AdvertSupportInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.SupportDo;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Service
public class AdvertSupportService extends CacheService {

    //新广告扶持
    private static final Integer NEW_ADVERT_SUPPORT = 0;

    //潜力广告扶持
    private static final Integer POTENTIONAL_ADVERT_SUPPORT = 1;

    private LoadingCache<String, AdvertStatDo> packageDataCache = CacheBuilder.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build(new CacheLoader<String, AdvertStatDo>() {
                @Override
                public AdvertStatDo load(String s) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
                }
            });

    private LoadingCache<String, AdvertStatDo> slotPackageDataCache = CacheBuilder.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES)
            .build(new CacheLoader<String, AdvertStatDo>() {
                @Override
                public AdvertStatDo load(String s) throws Exception {
                    throw new IllegalAccessException("not suppose single query");
                }

                @Override
                public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
                    return StringRedisHelper.of(nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
                }
            });

    public void support(Collection<OrientationPackage> orientationPackages, Long slotId) {
        try {

            // 获取所有的扶持广告
            Collection<OrientationPackage> supportOrientationPackages = orientationPackages.stream().filter(bo->bo.getNeedSupportWeight() || bo.getNeedPotentionalSupport()).collect(Collectors.toList());

            Map<OrientationPackage, String> packageKeyMap = new HashMap<>(supportOrientationPackages.size());
            Map<OrientationPackage, String> slotKeyMap = new HashMap<>(supportOrientationPackages.size());
            for (OrientationPackage orientationPackage : supportOrientationPackages) {
                Long advertId = orientationPackage.getAdvertId();
                Long packageId = orientationPackage.getId();
                String today = LocalDate.now().format(DAY_FORMATTER);
                String packageKey = RedisKeyUtil.getOrientationPackageSupportData(advertId, packageId, today);
                String slotKey = RedisKeyUtil.getOrientationPackageSlotSupportData(slotId, advertId, packageId, today);
                packageKeyMap.put(orientationPackage, packageKey);
                slotKeyMap.put(orientationPackage, slotKey);
            }
            Map<OrientationPackage, AdvertStatDo> packageData = MapUtils.translate(packageKeyMap, packageDataCache.getAll(packageKeyMap.values()));
            Map<OrientationPackage, AdvertStatDo> slotPackageData = MapUtils.translate(slotKeyMap, slotPackageDataCache.getAll(slotKeyMap.values()));

            supportOrientationPackages.forEach(orientationPackage -> {
                AdvertSupportInfoDo advertSupportInfoDo = new AdvertSupportInfoDo();
                advertSupportInfoDo.setAdvertId(orientationPackage.getAdvertId());
                advertSupportInfoDo.setPlanId(orientationPackage.getId());
                advertSupportInfoDo.setaFee(orientationPackage.getAssessCost());
                Optional.ofNullable(packageData.get(orientationPackage)).ifPresent(advertStatDo -> {
                    advertSupportInfoDo.setConsume(advertStatDo.getChargeFees());
                    advertSupportInfoDo.setLandingPageClickPV(advertStatDo.getActClickCnt());
                });
                Optional.ofNullable(slotPackageData.get(orientationPackage)).ifPresent(advertStatDo -> {
                    advertSupportInfoDo.setSlotConsume(advertStatDo.getChargeFees());
                    advertSupportInfoDo.setSlotLandingPageClickPV(advertStatDo.getActClickCnt());
                });

                if(orientationPackage.getNeedPotentionalSupport()){
                    advertSupportInfoDo.setAdvertSupportType(POTENTIONAL_ADVERT_SUPPORT);
                }else{
                    advertSupportInfoDo.setAdvertSupportType(NEW_ADVERT_SUPPORT);
                }

                SupportDo supportDo = NewAdvertSupportAlg.circuitBreakerNew(advertSupportInfoDo);

                // 如果熔断因子返回null.则熔断
                if (supportDo == null || supportDo.getCircuitBreakerFactor() == null) {
                    return;
                }
                // 计算预算
                Double supportWeight = NewAdvertSupportAlg.biddingFactor(supportDo, orientationPackage.getBudgetSmoothDo(), orientationPackage.getBiddingStatDo(),advertSupportInfoDo);

                orientationPackage.setSupportWeight(supportWeight);
            });

        } catch (Exception e) {
            logger.error("support error", e);
        }
    }
}
