package cn.com.duiba.nezha.engine.biz.vo.advert;

import cn.com.duiba.nezha.alg.alg.vo.NezhaStatDto;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.engine.api.dto.FusingOrientationPackageDto;
import cn.com.duiba.nezha.engine.api.dto.RecommendAppDto;
import cn.com.duiba.nezha.engine.api.enums.AdvertAlgEnum;
import cn.com.duiba.nezha.engine.api.enums.DeepTfServer;
import cn.com.duiba.nezha.engine.api.enums.ModelKeyEnum;
import cn.com.duiba.nezha.engine.api.enums.PredictCorrectType;
import cn.com.duiba.nezha.engine.biz.domain.*;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.enums.AdvertType;
import cn.com.duiba.nezha.engine.biz.enums.RecommendMaterialType;

import java.util.*;

public class AdvertRecommendRequestVo {

    private String ip;

    private Long predictCost;

    // 用户信息
    private ConsumerDo consumerDo;

    // engine的请求信息
    private RequestDo requestDo;

    // 请求的媒体信息
    private AppDo appDo;

    // 请求的活动信息
    private ActivityDo activityDo;

    //低arpu值券阈值
    private Double lowArpuThresholdValue;

    // 算法类型
    private AdvertAlgEnum advertAlgEnum;

    // 广告类型
    private AdvertType advertType;

    // 权重对象
    private AdvertStatDimWeightVo advertStatDimWeightVo;

    // CVR LR模型KEY
    private ModelKeyEnum cvrModelKey;

    // CTR LR模型KEY
    private ModelKeyEnum ctrModelKey;

    private DeepTfServer deepCtrModelKey;

    private DeepTfServer deepCvrModelKey;

    // 素材推荐方式
    private RecommendMaterialType recommendMaterialType;

    // 预估纠偏类型
    private PredictCorrectType predictCorrectType;

    // 广告多维度质量分是否启用
    private Boolean advertMultiDimScoreEffective;

    //是否启动弱条件过滤
    private Boolean invokeWeakFilter;

    private Map<Long, Advert> advertMap;

    private Set<OrientationPackage> advertOrientationPackages;

    private Map<Long, Integer> userAdvertBehaviorMap;

    private Map<Long, Double> ctrReconstructionFactorMap;

    private Map<Long, Double> cvrReconstructionFactorMap;

    private Map<FeatureIndex, Double> predictCtr;

    private Map<FeatureIndex, Double> predictCvr;

    private Map<Long, Double> ctrCorrectionFactorMap;

    private Map<Long, Double> cvrCorrectionFactorMap;

    private Map<FeatureIndex, Map<String, String>> featureMap;

    private Map<Long, NezhaStatDto> nezhaStatDtoMap;

    private Map<Long, AdvertStatFeatureDo> advertStatFeatureMap;

    private Boolean needPredict;

    private MutModelType mutModelType;

    // 推荐(定向/屏蔽)的媒体
    private Set<RecommendAppDto> recommendApps;

    // 需要熔断的配置包
    private Collection<FusingOrientationPackageDto> fusingOrientationPackages;

    //广告&媒体偏好画像特征
    private Map<String, Map<String,Long>> appTagInNewTrade; // 媒体行业在不同广告行业上的发券量/点击量/转化量  f550101-550102
    private Map<String, Map<String,Long>> appInNewTrade; // 媒体在不同广告行业上的发券量/点击量/转化量 f550301-550302
    // 算法预估降级 模型 （配置死）
    private ModelKeyEnum fusingCvrModelKey;
    private ModelKeyEnum fusingCtrModelKey;


    public AdvertType getAdvertType() {
        return advertType;
    }

    public void setAdvertType(AdvertType advertType) {
        this.advertType = advertType;
    }

    public Map<String, Map<String, Long>> getAppTagInNewTrade() {
        return appTagInNewTrade;
    }

    public void setAppTagInNewTrade(Map<String, Map<String, Long>> appTagInNewTrade) {
        this.appTagInNewTrade = appTagInNewTrade;
    }

    public Map<String, Map<String, Long>> getAppInNewTrade() {
        return appInNewTrade;
    }

    public void setAppInNewTrade(Map<String, Map<String, Long>> appInNewTrade) {
        this.appInNewTrade = appInNewTrade;
    }

    public MutModelType getMutModelType() {
        return mutModelType;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getPredictCost() {
        return predictCost;
    }

    public void setPredictCost(Long predictCost) {
        this.predictCost = predictCost;
    }

    public void setMutModelType(MutModelType mutModelType) {
        this.mutModelType = mutModelType;
    }

    public Set<RecommendAppDto> getRecommendApps() {
        return recommendApps;
    }

    public void setRecommendApps(Set<RecommendAppDto> recommendApps) {
        this.recommendApps = recommendApps;
    }

    public Collection<FusingOrientationPackageDto> getFusingOrientationPackages() {
        return fusingOrientationPackages;
    }

    public void setFusingOrientationPackages(Collection<FusingOrientationPackageDto> fusingOrientationPackages) {
        this.fusingOrientationPackages = fusingOrientationPackages;
    }

    public Boolean getNeedPredict() {
        return needPredict;
    }

    public void setNeedPredict(Boolean needPredict) {
        this.needPredict = needPredict;
    }

    public Map<Long, AdvertStatFeatureDo> getAdvertStatFeatureMap() {
        return Optional.ofNullable(advertStatFeatureMap).orElseGet(HashMap::new);
    }

    public void setAdvertStatFeatureMap(Map<Long, AdvertStatFeatureDo> advertStatFeatureMap) {
        this.advertStatFeatureMap = advertStatFeatureMap;
    }

    public Map<Long, NezhaStatDto> getNezhaStatDtoMap() {
        return Optional.ofNullable(nezhaStatDtoMap).orElseGet(HashMap::new);
    }

    public void setNezhaStatDtoMap(Map<Long, NezhaStatDto> nezhaStatDtoMap) {
        this.nezhaStatDtoMap = nezhaStatDtoMap;
    }

    public Map<FeatureIndex, Map<String, String>> getFeatureMap() {
        return Optional.ofNullable(featureMap).orElseGet(HashMap::new);
    }

    public void setFeatureMap(Map<FeatureIndex, Map<String, String>> featureMap) {
        this.featureMap = featureMap;
    }

    public Map<Long, Double> getCvrCorrectionFactorMap() {
        return Optional.ofNullable(cvrCorrectionFactorMap).orElseGet(HashMap::new);
    }

    public void setCvrCorrectionFactorMap(Map<Long, Double> cvrCorrectionFactorMap) {
        this.cvrCorrectionFactorMap = cvrCorrectionFactorMap;
    }

    public Map<Long, Double> getCtrCorrectionFactorMap() {
        return Optional.ofNullable(ctrCorrectionFactorMap).orElseGet(HashMap::new);
    }

    public void setCtrCorrectionFactorMap(Map<Long, Double> ctrCorrectionFactorMap) {
        this.ctrCorrectionFactorMap = ctrCorrectionFactorMap;
    }

    public ConsumerDo getConsumerDo() {
        return consumerDo;
    }

    public void setConsumerDo(ConsumerDo consumerDo) {
        this.consumerDo = consumerDo;
    }

    public RequestDo getRequestDo() {
        return requestDo;
    }

    public void setRequestDo(RequestDo requestDo) {
        this.requestDo = requestDo;
    }

    public AppDo getAppDo() {
        return appDo;
    }

    public void setAppDo(AppDo appDo) {
        this.appDo = appDo;
    }

    public ActivityDo getActivityDo() {
        return activityDo;
    }

    public void setActivityDo(ActivityDo activityDo) {
        this.activityDo = activityDo;
    }

    public Double getLowArpuThresholdValue() {
        return lowArpuThresholdValue;
    }

    public void setLowArpuThresholdValue(Double lowArpuThresholdValue) {
        this.lowArpuThresholdValue = lowArpuThresholdValue;
    }

    public AdvertAlgEnum getAdvertAlgEnum() {
        return advertAlgEnum;
    }

    public void setAdvertAlgEnum(AdvertAlgEnum advertAlgEnum) {
        this.advertAlgEnum = advertAlgEnum;
    }

    public AdvertStatDimWeightVo getAdvertStatDimWeightVo() {
        return advertStatDimWeightVo;
    }

    public void setAdvertStatDimWeightVo(AdvertStatDimWeightVo advertStatDimWeightVo) {
        this.advertStatDimWeightVo = advertStatDimWeightVo;
    }

    public ModelKeyEnum getCvrModelKey() {
        return cvrModelKey;
    }

    public void setCvrModelKey(ModelKeyEnum cvrModelKey) {
        this.cvrModelKey = cvrModelKey;
    }

    public ModelKeyEnum getCtrModelKey() {
        return ctrModelKey;
    }

    public void setCtrModelKey(ModelKeyEnum ctrModelKey) {
        this.ctrModelKey = ctrModelKey;
    }

    public DeepTfServer getDeepCtrModelKey() {
        return deepCtrModelKey;
    }

    public void setDeepCtrModelKey(DeepTfServer deepCtrModelKey) {
        this.deepCtrModelKey = deepCtrModelKey;
    }

    public DeepTfServer getDeepCvrModelKey() {
        return deepCvrModelKey;
    }

    public void setDeepCvrModelKey(DeepTfServer deepCvrModelKey) {
        this.deepCvrModelKey = deepCvrModelKey;
    }

    public RecommendMaterialType getRecommendMaterialType() {
        return recommendMaterialType;
    }

    public void setRecommendMaterialType(RecommendMaterialType recommendMaterialType) {
        this.recommendMaterialType = recommendMaterialType;
    }

    public PredictCorrectType getPredictCorrectType() {
        return predictCorrectType;
    }

    public void setPredictCorrectType(PredictCorrectType predictCorrectType) {
        this.predictCorrectType = predictCorrectType;
    }

    public Boolean getAdvertMultiDimScoreEffective() {
        return advertMultiDimScoreEffective;
    }

    public void setAdvertMultiDimScoreEffective(Boolean advertMultiDimScoreEffective) {
        this.advertMultiDimScoreEffective = advertMultiDimScoreEffective;
    }

    public Boolean getInvokeWeakFilter() {
        return invokeWeakFilter;
    }

    public void setInvokeWeakFilter(Boolean invokeWeakFilter) {
        this.invokeWeakFilter = invokeWeakFilter;
    }


    public Map<Long, Advert> getAdvertMap() {
        return advertMap;
    }

    public void setAdvertMap(Map<Long, Advert> advertMap) {
        this.advertMap = advertMap;
    }

    public Set<OrientationPackage> getAdvertOrientationPackages() {
        return advertOrientationPackages;
    }

    public void setAdvertOrientationPackages(Set<OrientationPackage> advertOrientationPackages) {
        this.advertOrientationPackages = advertOrientationPackages;
    }

    public Map<Long, Integer> getUserAdvertBehaviorMap() {
        return Optional.ofNullable(userAdvertBehaviorMap).orElseGet(HashMap::new);
    }

    public void setUserAdvertBehaviorMap(Map<Long, Integer> userAdvertBehaviorMap) {
        this.userAdvertBehaviorMap = userAdvertBehaviorMap;
    }

    public Map<Long, Double> getCtrReconstructionFactorMap() {
        return Optional.ofNullable(ctrReconstructionFactorMap).orElseGet(HashMap::new);
    }

    public void setCtrReconstructionFactorMap(Map<Long, Double> ctrReconstructionFactorMap) {
        this.ctrReconstructionFactorMap = ctrReconstructionFactorMap;
    }

    public Map<Long, Double> getCvrReconstructionFactorMap() {
        return Optional.ofNullable(cvrReconstructionFactorMap).orElseGet(HashMap::new);
    }

    public void setCvrReconstructionFactorMap(Map<Long, Double> cvrReconstructionFactorMap) {
        this.cvrReconstructionFactorMap = cvrReconstructionFactorMap;
    }

    public Map<FeatureIndex, Double> getPredictCtr() {
        return Optional.ofNullable(predictCtr).orElseGet(HashMap::new);
    }

    public void setPredictCtr(Map<FeatureIndex, Double> predictCtr) {
        this.predictCtr = predictCtr;
    }

    public Map<FeatureIndex, Double> getPredictCvr() {
        return Optional.ofNullable(predictCvr).orElseGet(HashMap::new);
    }

    public void setPredictCvr(Map<FeatureIndex, Double> predictCvr) {
        this.predictCvr = predictCvr;
    }


    public void setCommonInfo(AppDo appDo, ConsumerDo consumerDo, RequestDo requestDo, ActivityDo activityDo) {
        this.appDo = appDo;
        this.consumerDo = consumerDo;
        this.requestDo = requestDo;
        this.activityDo = activityDo;
    }

    public void setFusingCvrModelKey(ModelKeyEnum fusingCvrModelKey) {
        this.fusingCvrModelKey = fusingCvrModelKey;
    }

    public ModelKeyEnum getFusingCvrModelKey() {
        return Optional.ofNullable(fusingCvrModelKey).orElse(ModelKeyEnum.FTRL_FM_BCVR_MODEL_v007);
    }

    public void setFusingCtrModelKey(ModelKeyEnum fusingCtrModelKey) {
        this.fusingCtrModelKey = fusingCtrModelKey;
    }
    public ModelKeyEnum getFusingCtrModelKey() {
        return Optional.ofNullable(fusingCtrModelKey).orElse(ModelKeyEnum.FTRL_FM_CTR_MODEL_v007);
    }
}
