/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.bo.advert;

import cn.com.duiba.nezha.alg.alg.alg.BudgetSmoothAlg;
import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SmoothResultDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertBudgetSmoothService
extends CacheService {
    private static final RateLimiter RATE_LIMITER = RateLimiter.create((double)0.02);
    private LoadingCache<String, BudgetDo> budgetDoCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, BudgetDo>(){

        public BudgetDo load(String key) throws Exception {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<String, BudgetDo> loadAll(Iterable<? extends String> keys) {
            return StringRedisHelper.of((StringRedisTemplate)AdvertBudgetSmoothService.this.nezhaStringRedisTemplate).valueMultiGet(keys, BudgetDo.class, BudgetDo::new);
        }
    });
    private LoadingCache<BudgetQuery, Optional<BudgetSmoothDo>> lastBudgetSmoothDoCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BudgetQuery, Optional<BudgetSmoothDo>>(){

        public Optional<BudgetSmoothDo> load(BudgetQuery key) throws Exception {
            return Optional.empty();
        }

        public Map<BudgetQuery, Optional<BudgetSmoothDo>> loadAll(Iterable<? extends BudgetQuery> keys) {
            ArrayList ks = Lists.newArrayList(keys);
            HashMap<BudgetQuery, Optional<BudgetSmoothDo>> map = new HashMap<BudgetQuery, Optional<BudgetSmoothDo>>(ks.size());
            ks.forEach(k -> map.put((BudgetQuery)k, Optional.empty()));
            return map;
        }
    });
    private LoadingCache<BudgetQuery, BudgetSmoothDo> budgetSmoothDoCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<BudgetQuery, BudgetSmoothDo>(){

        public BudgetSmoothDo load(BudgetQuery key) throws Exception {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<BudgetQuery, BudgetSmoothDo> loadAll(Iterable<? extends BudgetQuery> keys) {
            ArrayList newQueries = Lists.newArrayList(keys);
            return AdvertBudgetSmoothService.this.getBudgetSmoothDos(newQueries);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNewBudgetSmooth(Long appId, Set<OrientationPackage> orientationPackages, Integer adxLoadType) {
        try {
            DBTimeProfile.enter((String)"getNewBudgetSmooth");
            Set<OrientationPackage> needSupportOrSmoothBudgetPackages = orientationPackages.stream().filter(orientationPackage -> orientationPackage.getNeedSupportWeight() != false || orientationPackage.enableBudgetSmooth() != false || orientationPackage.getNeedPotentionalSupport() != false).collect(Collectors.toSet());
            if (needSupportOrSmoothBudgetPackages.isEmpty()) {
                return;
            }
            ArrayList allKeys = new ArrayList(needSupportOrSmoothBudgetPackages.size() * 2);
            HashMap advertQueries = new HashMap(needSupportOrSmoothBudgetPackages.size());
            HashMap advertAppQueries = new HashMap(needSupportOrSmoothBudgetPackages.size());
            needSupportOrSmoothBudgetPackages.forEach(orientationPackage -> {
                Long advertId = orientationPackage.getAdvertId();
                Long packageId = orientationPackage.getId();
                BudgetQuery advertQuery = new BudgetQuery();
                advertQuery.setAdvertId(advertId);
                advertQuery.setPackageId(packageId);
                advertQuery.setAdxLoadType(adxLoadType);
                BudgetQuery advertAppQuery = new BudgetQuery();
                advertAppQuery.setAdvertId(advertId);
                advertAppQuery.setPackageId(packageId);
                advertAppQuery.setAppId(appId);
                advertAppQuery.setAdxLoadType(adxLoadType);
                advertQueries.put(orientationPackage, advertQuery);
                advertAppQueries.put(orientationPackage, advertAppQuery);
                allKeys.add(advertQuery);
                allKeys.add(advertAppQuery);
            });
            ImmutableMap queryBudgetSmoothDoMap = this.budgetSmoothDoCache.getAll(allKeys);
            needSupportOrSmoothBudgetPackages.forEach(arg_0 -> AdvertBudgetSmoothService.lambda$getNewBudgetSmooth$2(advertQueries, (Map)queryBudgetSmoothDoMap, advertAppQueries, arg_0));
            if (adxLoadType == 2 && RATE_LIMITER.tryAcquire()) {
                needSupportOrSmoothBudgetPackages.stream().filter(OrientationPackage::enableBudgetSmooth).forEach(orientationPackage -> this.logger.info("\u5e7f\u544a\u914d\u7f6e\u7684\u5e73\u6ed1\u9884\u7b97\u5bf9\u8c61: " + JSONObject.toJSONString((Object)orientationPackage.getSmoothResultDo())));
            }
            needSupportOrSmoothBudgetPackages.stream().filter(OrientationPackage::enableBudgetSmooth).filter(orientationPackage -> orientationPackage.getSmoothResultDo() != null && orientationPackage.getSmoothResultDo().getGiveUp() != false).forEach(orientationPackage -> orientationPackage.setBudgetSmoothGiveUp(true));
        }
        catch (Exception e) {
            this.logger.error("getNewBudgetSmooth happened error:{}", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<BudgetQuery, BudgetSmoothDo> getBudgetSmoothDos(List<BudgetQuery> budgetQueries) {
        try {
            DBTimeProfile.enter((String)"getBudgetSmoothDos");
            String dayFormat = LocalDate.now().format(DAY_FORMATTER);
            Integer adxLoadType = budgetQueries.get(0).getAdxLoadType();
            HashMap queryKeyMap = new HashMap();
            budgetQueries.forEach(newBudgetQuery -> {
                Long advertId = newBudgetQuery.getAdvertId();
                Long packageId = newBudgetQuery.getPackageId();
                Long appId = newBudgetQuery.getAppId();
                queryKeyMap.put(newBudgetQuery, RedisKeyUtil.getBudgetQueryKey((Long)appId, (Long)advertId, (Long)packageId, (String)dayFormat));
            });
            ImmutableMap keyBudgetMap = this.budgetDoCache.getAll(queryKeyMap.values());
            Map queryBudgetDoMap = MapUtils.translate(queryKeyMap, (Map)keyBudgetMap);
            ImmutableMap lastQueryBudgetSmoothDoMap = this.lastBudgetSmoothDoCache.getAll(budgetQueries);
            HashMap<BudgetQuery, BudgetSmoothDo> resultMap = new HashMap<BudgetQuery, BudgetSmoothDo>(budgetQueries.size());
            for (BudgetQuery query : budgetQueries) {
                BudgetDo budgetDo = (BudgetDo)queryBudgetDoMap.get(query);
                if (budgetDo.getAdvertId() == null) {
                    budgetDo = null;
                }
                BudgetSmoothDo lastBudgetSmoothDo = ((Optional)lastQueryBudgetSmoothDoMap.get(query)).orElse(null);
                BudgetSmoothDo newBudgetSmoothDo = BudgetSmoothAlg.getBudgetRatio((BudgetDo)budgetDo, (BudgetSmoothDo)lastBudgetSmoothDo);
                if (adxLoadType == 2) {
                    this.lastBudgetSmoothDoCache.put((Object)query, Optional.of(newBudgetSmoothDo));
                }
                resultMap.put(query, newBudgetSmoothDo);
            }
            HashMap<BudgetQuery, BudgetSmoothDo> hashMap = resultMap;
            return hashMap;
        }
        catch (Exception e) {
            this.logger.error("getAllBudgetSmoothDos happened error:{}", (Throwable)e);
            HashMap<BudgetQuery, BudgetSmoothDo> hashMap = new HashMap<BudgetQuery, BudgetSmoothDo>();
            return hashMap;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private static /* synthetic */ void lambda$getNewBudgetSmooth$2(Map advertQueries, Map queryBudgetSmoothDoMap, Map advertAppQueries, OrientationPackage orientationPackage) {
        BudgetQuery advertQueryKey = (BudgetQuery)advertQueries.get(orientationPackage);
        BudgetSmoothDo advertBudgetSmoothDo = (BudgetSmoothDo)queryBudgetSmoothDoMap.get(advertQueryKey);
        if (orientationPackage.getNeedSupportWeight().booleanValue() || orientationPackage.getNeedPotentionalSupport().booleanValue()) {
            orientationPackage.setBudgetSmoothDo(advertBudgetSmoothDo);
        }
        if (orientationPackage.enableBudgetSmooth().booleanValue()) {
            BudgetQuery advertAppQueryKey = (BudgetQuery)advertAppQueries.get(orientationPackage);
            BudgetSmoothDo advertAppBudgetSmoothDo = (BudgetSmoothDo)queryBudgetSmoothDoMap.get(advertAppQueryKey);
            SmoothResultDo smoothResultDo = BudgetSmoothAlg.getSmoothRatio((BudgetSmoothDo)advertBudgetSmoothDo, (BudgetSmoothDo)advertAppBudgetSmoothDo);
            orientationPackage.setSmoothResultDo(smoothResultDo);
        }
    }

    class BudgetQuery {
        private Long advertId;
        private Long packageId;
        private Long appId;
        private Integer adxLoadType;

        BudgetQuery() {
        }

        public Integer getAdxLoadType() {
            return this.adxLoadType;
        }

        public void setAdxLoadType(Integer adxLoadType) {
            this.adxLoadType = adxLoadType;
        }

        public Long getAdvertId() {
            return this.advertId;
        }

        public void setAdvertId(Long advertId) {
            this.advertId = advertId;
        }

        public Long getPackageId() {
            return this.packageId;
        }

        public void setPackageId(Long packageId) {
            this.packageId = packageId;
        }

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BudgetQuery)) {
                return false;
            }
            BudgetQuery that = (BudgetQuery)o;
            return Objects.equals(this.advertId, that.advertId) && Objects.equals(this.packageId, that.packageId) && Objects.equals(this.appId, that.appId) && Objects.equals(this.adxLoadType, that.adxLoadType);
        }

        public int hashCode() {
            return Objects.hash(this.advertId, this.packageId, this.appId, this.adxLoadType);
        }
    }
}

