/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.bo.advert.impl;

import cn.com.duiba.nezha.engine.api.enums.StatDataTypeEnum;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertStatAssociationBo;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatDo;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertStatService;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertStatAssociationBoImpl
implements AdvertStatAssociationBo {
    private static final ImmutableMap<StatDataTypeEnum, Function<AdvertStatDo, Double>> DATA_TYPE_FUNCTION_MAP = ImmutableMap.of((Object)StatDataTypeEnum.CTR, stat -> Optional.ofNullable(stat.getCtr()).orElse(0.0), (Object)StatDataTypeEnum.CVR, stat -> Optional.ofNullable(stat.getCvr()).orElse(0.0), (Object)StatDataTypeEnum.CLICK, stat -> stat.getChargeCnt().doubleValue(), (Object)StatDataTypeEnum.EXPOSURE, stat -> stat.getLaunchCnt().doubleValue(), (Object)StatDataTypeEnum.FEE, stat -> stat.getChargeFees().doubleValue());
    @Autowired
    private AdvertStatService advertStatService;

    @Override
    public Map<Long, StatisticData> get7DayStat(Set<Long> appIds, Long advertId, Map<Long, Long> advertId2PkgId) {
        if (advertId2PkgId == null) {
            advertId2PkgId = Collections.emptyMap();
        }
        HashSet<AdvertStatService.Query> queries = new HashSet<AdvertStatService.Query>(appIds.size());
        HashMap<Long, AdvertStatService.Query> appId2QueryMap = new HashMap<Long, AdvertStatService.Query>(appIds.size());
        for (Long appId : appIds) {
            AdvertStatService.Query query = AdvertStatService.Query.newBuilder().appId(appId).advertId(advertId).packageId(advertId2PkgId.get(advertId)).build();
            queries.add(query);
            appId2QueryMap.put(appId, query);
        }
        Map<AdvertStatService.Query, StatisticData> r7DayStat = this.advertStatService.get7DayStat(queries);
        return MapUtils.translate(appId2QueryMap, r7DayStat);
    }
}

