/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.bo.hbase;

import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.engine.api.dto.TagStat;
import cn.com.duiba.nezha.engine.biz.domain.ActivityDo;
import cn.com.duiba.nezha.engine.biz.domain.ActivityFeatureDo;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerDo;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerFeatureDO;
import cn.com.duiba.nezha.engine.biz.domain.RequestDo;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AppInstallFeature;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ActivityFeatureService;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ConsumerAppInstallService;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ConsumerFeatureService;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ResourceFeatureService;
import cn.com.duiba.nezha.engine.common.utils.MyObjectUtil;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumerFeatureBo {
    private Logger logger = LoggerFactory.getLogger(ConsumerFeatureBo.class);
    @Autowired
    private ConsumerFeatureService consumerFeatureService;
    @Autowired
    private ConsumerAppInstallService consumerAppInstallService;
    @Autowired
    private ActivityFeatureService activityFeatureService;
    @Autowired
    private ResourceFeatureService resourceFeatureService;

    public FeatureDo getFeatureDo(ConsumerDo consumerDo, AppDo appDo, ActivityDo activityDo, RequestDo requestDo) {
        List<TagStat> tagStats;
        FeatureDo featureDo = new FeatureDo();
        featureDo.setConsumerId(consumerDo.getId());
        featureDo.setMemberId(consumerDo.getMemberId() == null ? null : String.valueOf(consumerDo.getMemberId()));
        featureDo.setShipArea(consumerDo.getShipArea());
        featureDo.setUserLastlogbigintime(consumerDo.getLastLoginTime());
        featureDo.setUserRegtime(consumerDo.getRegisterTime());
        featureDo.setMobile(consumerDo.getPhoneNumber());
        featureDo.setAppId(appDo.getId());
        featureDo.setAppCategory(appDo.getCategory());
        featureDo.setSlotId(appDo.getSlotId());
        featureDo.setSlotType(appDo.getSlotType());
        featureDo.setSlotWidth(appDo.getSlotWidth());
        featureDo.setSlotHeight(appDo.getSlotHeight());
        featureDo.setSlotIndustryTagId(appDo.getSlotIndustryTagId());
        featureDo.setSlotIndustryTagPid(appDo.getSlotIndustryTagPid());
        featureDo.setAppIndustryTagId(appDo.getIndustryTagId());
        featureDo.setAppIndustryTagPid(appDo.getIndustryTagPid());
        featureDo.setTrafficTagId(appDo.getTrafficTagId());
        featureDo.setTrafficTagPid(appDo.getTrafficTagPid());
        Long operatingActivityId = activityDo.getOperatingId();
        ActivityFeatureDo activityFeatureDo = this.activityFeatureService.get(operatingActivityId);
        featureDo.setOperatingActivityId(operatingActivityId);
        featureDo.setActivityUseType(activityDo.getUseType() == null ? null : String.valueOf(activityDo.getUseType()));
        featureDo.setActivityId(activityDo.getId());
        featureDo.setActivityType(activityDo.getType());
        featureDo.setPerformance(activityFeatureDo.getPerformance());
        featureDo.setLaunchInfo(activityFeatureDo.getLaunchInfo());
        featureDo.setBasicInfo(activityFeatureDo.getBasicInfo());
        featureDo.setTotalInfo(activityFeatureDo.getTotalInfo());
        featureDo.setUa(requestDo.getUa());
        featureDo.setCityId(requestDo.getCityId());
        featureDo.setPriceSection(requestDo.getPriceSection());
        featureDo.setPutIndex(requestDo.getPutIndex());
        featureDo.setModel(requestDo.getModel());
        featureDo.setConnectionType(requestDo.getConnectionType());
        featureDo.setOperatorType(requestDo.getOperatorType());
        featureDo.setPhoneBrand(requestDo.getPhoneBrand());
        featureDo.setPhoneModelNum(requestDo.getPhoneModel());
        featureDo.setAlgStartPosition(requestDo.getStartCount());
        ArrayList<String> keys = new ArrayList<String>();
        Long consumerId = featureDo.getConsumerId();
        keys.add(this.getConsumerOrderFeatureKey(consumerId, null));
        keys.add(this.getConsumerOrderFeatureKey(consumerId, operatingActivityId));
        Map featureVos = null;
        try {
            featureVos = (Map)CatUtils.executeInCatTransaction(() -> this.consumerFeatureService.getFeatures(keys), (String)"Hbase", (String)"consumerFeatureService#getFeatures");
        }
        catch (Throwable throwable) {
            this.logger.error("resourceFeatureService error !", throwable);
        }
        ConsumerFeatureDO globalFeatureDO = this.getConsumerOrderFeatureDo(consumerId, null, featureVos);
        featureDo.setDayOrderRank(this.getRealRank(globalFeatureDO.getCurrentDayOrderCount()));
        featureDo.setOrderRank(this.getRealRank(globalFeatureDO.getOrderCount()));
        featureDo.setLastGmtCreateTime(globalFeatureDO.getLastOrderTime());
        featureDo.setLastChargeNums(MyObjectUtil.string2long((String)globalFeatureDO.getIsBilling()));
        featureDo.setLastOperatingActivityId(MyObjectUtil.string2long((String)globalFeatureDO.getLastActivityId()));
        ConsumerFeatureDO activityFeatureDO = this.getConsumerOrderFeatureDo(consumerId, operatingActivityId, featureVos);
        featureDo.setDayActivityOrderRank(this.getRealRank(activityFeatureDO.getCurrentDayOrderCount()));
        featureDo.setActivityOrderRank(this.getRealRank(activityFeatureDO.getOrderCount()));
        featureDo.setActivityLastGmtCreateTime(activityFeatureDO.getLastOrderTime());
        featureDo.setActivityLastChargeNums(MyObjectUtil.string2long((String)activityFeatureDO.getIsBilling()));
        Joiner joiner = Joiner.on((String)",");
        List<String> installApps = consumerDo.getInstallApps();
        if (CollectionUtils.isNotEmpty(installApps)) {
            AppInstallFeature installFeature = this.consumerAppInstallService.getFeature(installApps);
            featureDo.setAppList2(joiner.join(installApps));
            featureDo.setCategoryIdList1(joiner.join(installFeature.getFirstCategory()));
            featureDo.setCategoryIdList2(joiner.join(installFeature.getSecondCategory()));
            featureDo.setCategory1idCntList(installFeature.getFirstCategoryCount());
            featureDo.setCategory2idCntList(installFeature.getSecondCategoryCount());
            featureDo.setIsGame(installFeature.getHasGame() != false ? "1" : "0");
            featureDo.setClusterId(joiner.join(installFeature.getClusterIdList()));
            featureDo.setImportantApp(joiner.join(installFeature.getImportantAppList()));
        }
        if (CollectionUtils.isNotEmpty(tagStats = consumerDo.getTagStats())) {
            ArrayList<String> tagIds = new ArrayList<String>(tagStats.size());
            ArrayList<Double> scores = new ArrayList<Double>(tagStats.size());
            ArrayList<Long> launchs = new ArrayList<Long>(tagStats.size());
            ArrayList<Long> clicks = new ArrayList<Long>(tagStats.size());
            ArrayList<Long> converts = new ArrayList<Long>(tagStats.size());
            for (TagStat tagStat : tagStats) {
                tagIds.add(tagStat.getTagId());
                scores.add(tagStat.getScore());
                launchs.add(tagStat.getLaunch());
                clicks.add(tagStat.getClick());
                converts.add(tagStat.getConvert());
            }
            featureDo.setUIIds(joiner.join(tagIds));
            featureDo.setUIScore(joiner.join(scores));
            featureDo.setUILaunchPV(joiner.join(launchs));
            featureDo.setUIClickPv(joiner.join(clicks));
            featureDo.setUIEffectPv(joiner.join(converts));
        }
        featureDo.setUICtr(consumerDo.getClickInterestedTags());
        featureDo.setUUnICtr(consumerDo.getClickUninterestedTags());
        featureDo.setUICvr(consumerDo.getConvertInterestedTags());
        featureDo.setUUnICvr(consumerDo.getConvertUninterestedTags());
        featureDo.setSex(consumerDo.getSex());
        featureDo.setAge(consumerDo.getAge());
        featureDo.setWorkStatus(consumerDo.getWorkStatus());
        featureDo.setStudentStatus(consumerDo.getStudentStatus());
        featureDo.setMarriageStatus(consumerDo.getMarriageStatus());
        featureDo.setBear(consumerDo.getBear());
        if (CollectionUtils.isNotEmpty(consumerDo.getInterestedList())) {
            featureDo.setInterestList(joiner.join(consumerDo.getInterestedList()));
        }
        try {
            CatUtils.executeInCatTransaction(() -> {
                this.resourceFeatureService.get(consumerId, featureDo);
                return null;
            }, (String)"Hbase", (String)"resourceFeatureService");
        }
        catch (Throwable throwable) {
            this.logger.error("resourceFeatureService error !", throwable);
        }
        return featureDo;
    }

    private ConsumerFeatureDO getConsumerOrderFeatureDo(Long consumerId, Long activityId, Map<String, ConsumerFeatureDO> featureDtoMap) {
        String mainKey = this.getConsumerOrderFeatureKey(consumerId, activityId);
        return featureDtoMap.getOrDefault(mainKey, new ConsumerFeatureDO());
    }

    private Long getRealRank(Long longVal) {
        return Optional.ofNullable(longVal).map(v -> v + 1L).orElse(1L);
    }

    public String getConsumerOrderFeatureKey(Long consumerId, Long activityId) {
        StringBuilder sb = new StringBuilder().append(consumerId).reverse();
        if (activityId != null) {
            sb.append("-").append(activityId);
        }
        return sb.toString();
    }
}

