/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.domain.advert;

import cn.com.duiba.nezha.engine.api.dto.AdvertNewDto;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Material {
    private Long id;
    private String atmosphere;
    private String backgroundColour;
    private Boolean prevalent;
    private String interception;
    private String carton;
    private String bodyElement;
    private Set<String> tags;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAtmosphere() {
        return this.atmosphere;
    }

    public void setAtmosphere(String atmosphere) {
        this.atmosphere = atmosphere;
    }

    public String getBackgroundColour() {
        return this.backgroundColour;
    }

    public void setBackgroundColour(String backgroundColour) {
        this.backgroundColour = backgroundColour;
    }

    public Boolean getPrevalent() {
        return this.prevalent;
    }

    public void setPrevalent(Boolean prevalent) {
        this.prevalent = prevalent;
    }

    public String getInterception() {
        return this.interception;
    }

    public void setInterception(String interception) {
        this.interception = interception;
    }

    public String getCarton() {
        return this.carton;
    }

    public void setCarton(String carton) {
        this.carton = carton;
    }

    public String getBodyElement() {
        return this.bodyElement;
    }

    public void setBodyElement(String bodyElement) {
        this.bodyElement = bodyElement;
    }

    public Set<String> getTags() {
        return Optional.ofNullable(this.tags).orElseGet(HashSet::new);
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public static Set<Material> convert(AdvertNewDto advertDto) {
        Map materialMapNew = advertDto.getMaterialMapNew();
        return advertDto.getMaterials().stream().map(materialDto -> {
            Material material = new Material();
            Long id = materialDto.getId();
            material.setId(id);
            material.setAtmosphere(materialDto.getAtmosphere());
            material.setBackgroundColour(materialDto.getBackgroundColour());
            material.setPrevalent(materialDto.getPrevalent());
            material.setInterception(materialDto.getInterception());
            material.setCarton(materialDto.getCarton());
            material.setBodyElement(materialDto.getBodyElement());
            material.setTags(materialMapNew.getOrDefault(id, new HashSet()));
            return material;
        }).collect(Collectors.toSet());
    }
}

