/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.domain.advert;

import cn.com.duiba.nezha.alg.alg.vo.BiddingStatDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SmoothResultDo;
import cn.com.duiba.nezha.engine.api.dto.AdvertNewDto;
import cn.com.duiba.nezha.engine.api.enums.ChargeTypeEnum;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.domain.advert.Material;
import cn.com.duiba.nezha.engine.biz.domain.advert.StatisticDataGetter;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AdvertStatisticMergeEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AlgoRescureEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class OrientationPackage
implements StatisticDataGetter {
    private Long id;
    private Long accountId;
    private Long advertId;
    private Integer cvrType;
    private Integer depthCvrType;
    private Long clickFee;
    private Long convertCost;
    private Long oldConvertCost;
    private Integer packageType;
    private Integer targetAppLimit;
    private Boolean strongTarget;
    private Long budget;
    private Integer chargeType;
    private Set<Material> materials;
    private List<Double> hourlyBudgetFees;
    private List<Double> hourlyBudgetCounts;
    private String newTradeTagNum;
    private Boolean smartShop;
    private Boolean supportStatus;
    private Boolean needSupportWeight;
    private Long assessCost;
    private Double adjustPriceFactor;
    private Double feeWeightFactor;
    private Boolean isBasePriceException;
    private StatisticData hourStatisticData;
    private StatisticData todayStatisticData;
    private StatisticData recently7DayStatisticData;
    private StatisticData hourAppStatisticData;
    private StatisticData todayAppStatisticData;
    private StatisticData recently7DayAppStatisticData;
    private StatisticData smartShopStatisticData;
    private Integer qualityLevel;
    private Integer userBehavior;
    private Long finalFee;
    private Double statCtr;
    private Double statCvr;
    private Double preCtr;
    private Double preCvr;
    private Double ctr;
    private Double cvr;
    private Boolean giveUp;
    private Long flowTag;
    private BiddingStatDo biddingStatDo;
    private BudgetSmoothDo budgetSmoothDo;
    private Double qScore;
    private Double rankScore;
    private Integer rank;
    private Integer reRank;
    private Double supportWeight;
    private Boolean supportSuccess;
    private String orderId;
    private AdvertStatisticMergeEntity tagStatisticData;
    private AlgoRescureEntity algoRescureEntity;
    private List<Double> hourlyCtr;
    private List<Double> hourlyCvr;
    private List<Double> hourlyClick;
    private List<Double> hourlyLaunch;
    private List<Double> hourlyConsume;
    private Integer releaseTarget;
    private Long importantAppFee;
    private Integer budgetSmooth;
    private SmoothResultDo smoothResultDo;
    private String simpleSupportType;
    private Boolean manuallyConvertCost;
    private Boolean budgetSmoothGiveUp;
    private Double autoBiddingFactor;
    private Double controlWeight;
    private Double supportInfoSupportWeight;
    private Integer potentionalStatus;
    private Boolean needPotentionalSupport;
    private Boolean floorPriceWhilteAdvert;
    private Double giveUpProb10;
    private Double giveUpProb5;

    public OrientationPackage(Long id, Long advertId) {
        this.id = id;
        this.advertId = advertId;
    }

    public OrientationPackage() {
    }

    public static OrientationPackage convert(AdvertNewDto advertDto) {
        OrientationPackage orientationPackage = new OrientationPackage();
        orientationPackage.setId(advertDto.getPackageId());
        orientationPackage.setAccountId(Long.parseLong(advertDto.getAccountId()));
        orientationPackage.setAdvertId(advertDto.getAdvertId());
        orientationPackage.setPackageType(advertDto.getPackageType());
        orientationPackage.setClickFee(advertDto.getFee());
        orientationPackage.setConvertCost(advertDto.getImportantAppFee());
        orientationPackage.setOldConvertCost(advertDto.getConvertCost());
        orientationPackage.setTargetAppLimit(advertDto.getTargetAppLimit());
        orientationPackage.setStrongTarget(advertDto.getStrongTarget());
        orientationPackage.setBudget(advertDto.getPackageBudget());
        orientationPackage.setChargeType(advertDto.getChargeType());
        orientationPackage.setNewTradeTagNum(advertDto.getNewTradeTagNum());
        orientationPackage.setHourlyBudgetFees(advertDto.getHourlyBudgetFees());
        orientationPackage.setHourlyBudgetCounts(advertDto.getHourlyBudgetCounts());
        orientationPackage.setSupportStatus(advertDto.getSupportStatus());
        orientationPackage.setNeedSupportWeight(advertDto.getNeedSupportWeight());
        orientationPackage.setAssessCost(advertDto.getAssessCost());
        orientationPackage.setCvrType(advertDto.getCvrType());
        orientationPackage.setDepthCvrType(advertDto.getDepthCvrType());
        orientationPackage.setReleaseTarget(advertDto.getReleaseTarget());
        orientationPackage.setImportantAppFee(advertDto.getImportantAppFee());
        orientationPackage.setManuallyConvertCost(advertDto.getDisAppFeeType() != 0);
        orientationPackage.setBudgetSmooth(advertDto.getBudgetSmooth());
        orientationPackage.setPotentionalStatus(advertDto.getPotentionalStatus());
        orientationPackage.setNeedPotentionalSupport(Integer.valueOf(1).equals(advertDto.getNeedPotentionalSupport()));
        orientationPackage.setFloorPriceWhilteAdvert(advertDto.getFloorPriceWhilteAdvert());
        return orientationPackage;
    }

    public Boolean getFloorPriceWhilteAdvert() {
        return this.floorPriceWhilteAdvert;
    }

    public void setFloorPriceWhilteAdvert(Boolean floorPriceWhilteAdvert) {
        this.floorPriceWhilteAdvert = floorPriceWhilteAdvert;
    }

    public Double getAutoBiddingFactor() {
        return Optional.ofNullable(this.autoBiddingFactor).orElse(1.0);
    }

    public void setAutoBiddingFactor(Double autoBiddingFactor) {
        this.autoBiddingFactor = autoBiddingFactor;
    }

    public Boolean getBudgetSmoothGiveUp() {
        return Optional.ofNullable(this.budgetSmoothGiveUp).orElse(false);
    }

    public void setBudgetSmoothGiveUp(Boolean budgetSmoothGiveUp) {
        this.budgetSmoothGiveUp = budgetSmoothGiveUp;
    }

    public Double getControlWeight() {
        return this.controlWeight;
    }

    public void setControlWeight(Double controlWeight) {
        this.controlWeight = controlWeight;
    }

    public Boolean getManuallyConvertCost() {
        return this.manuallyConvertCost;
    }

    public void setManuallyConvertCost(Boolean manuallyConvertCost) {
        this.manuallyConvertCost = manuallyConvertCost;
    }

    public Integer getDepthCvrType() {
        return this.depthCvrType;
    }

    public void setDepthCvrType(Integer depthCvrType) {
        this.depthCvrType = depthCvrType;
    }

    public Long getOldConvertCost() {
        return this.oldConvertCost;
    }

    public void setOldConvertCost(Long oldConvertCost) {
        this.oldConvertCost = oldConvertCost;
    }

    public Long getImportantAppFee() {
        return this.importantAppFee;
    }

    public void setImportantAppFee(Long importantAppFee) {
        this.importantAppFee = importantAppFee;
    }

    public Integer getReleaseTarget() {
        return this.releaseTarget;
    }

    public void setReleaseTarget(Integer releaseTarget) {
        this.releaseTarget = releaseTarget;
    }

    public List<Double> getHourlyCtr() {
        return this.hourlyCtr;
    }

    public void setHourlyCtr(List<Double> hourlyCtr) {
        this.hourlyCtr = hourlyCtr;
    }

    public List<Double> getHourlyCvr() {
        return this.hourlyCvr;
    }

    public void setHourlyCvr(List<Double> hourlyCvr) {
        this.hourlyCvr = hourlyCvr;
    }

    public List<Double> getHourlyClick() {
        return this.hourlyClick;
    }

    public void setHourlyClick(List<Double> hourlyClick) {
        this.hourlyClick = hourlyClick;
    }

    public List<Double> getHourlyLaunch() {
        return this.hourlyLaunch;
    }

    public void setHourlyLaunch(List<Double> hourlyLaunch) {
        this.hourlyLaunch = hourlyLaunch;
    }

    public List<Double> getHourlyConsume() {
        return this.hourlyConsume;
    }

    public void setHourlyConsume(List<Double> hourlyConsume) {
        this.hourlyConsume = hourlyConsume;
    }

    public AdvertStatisticMergeEntity getTagStatisticData() {
        return this.tagStatisticData;
    }

    public void setTagStatisticData(AdvertStatisticMergeEntity tagStatisticData) {
        this.tagStatisticData = tagStatisticData;
    }

    public Integer getCvrType() {
        return this.cvrType;
    }

    public void setCvrType(Integer cvrType) {
        this.cvrType = cvrType;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getReRank() {
        return this.reRank;
    }

    public void setReRank(Integer reRank) {
        this.reRank = reRank;
    }

    public Double getRankScore() {
        return this.rankScore;
    }

    public void setRankScore(Double rankScore) {
        this.rankScore = rankScore;
    }

    public Double getqScore() {
        return this.qScore;
    }

    public void setqScore(Double qScore) {
        this.qScore = qScore;
    }

    public Double getSupportWeight() {
        return Optional.ofNullable(this.supportWeight).orElse(1.0);
    }

    public void setSupportWeight(Double supportWeight) {
        this.supportWeight = supportWeight;
    }

    public Boolean getSupportSuccess() {
        return this.supportSuccess;
    }

    public void setSupportSuccess(Boolean supportSuccess) {
        this.supportSuccess = supportSuccess;
    }

    public BudgetSmoothDo getBudgetSmoothDo() {
        return this.budgetSmoothDo;
    }

    public void setBudgetSmoothDo(BudgetSmoothDo budgetSmoothDo) {
        this.budgetSmoothDo = budgetSmoothDo;
    }

    public BiddingStatDo getBiddingStatDo() {
        return this.biddingStatDo;
    }

    public void setBiddingStatDo(BiddingStatDo biddingStatDo) {
        this.biddingStatDo = biddingStatDo;
    }

    public Boolean getGiveUp() {
        return this.giveUp;
    }

    public void setGiveUp(Boolean giveUp) {
        this.giveUp = giveUp;
    }

    public Boolean getBasePriceException() {
        return this.isBasePriceException;
    }

    public void setBasePriceException(Boolean basePriceException) {
        this.isBasePriceException = basePriceException;
    }

    public Long getFlowTag() {
        return this.flowTag;
    }

    public void setFlowTag(Long flowTag) {
        this.flowTag = flowTag;
    }

    public Integer getUserBehavior() {
        return this.userBehavior;
    }

    public void setUserBehavior(Integer userBehavior) {
        this.userBehavior = userBehavior;
    }

    public Double getCvr() {
        return this.cvr;
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public Double getCtr() {
        return this.ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Long getFinalFee() {
        return this.finalFee;
    }

    public void setFinalFee(Long finalFee) {
        this.finalFee = finalFee;
    }

    public Double getStatCtr() {
        return this.statCtr;
    }

    public void setStatCtr(Double statCtr) {
        this.statCtr = statCtr;
    }

    public Double getStatCvr() {
        return this.statCvr;
    }

    public void setStatCvr(Double statCvr) {
        this.statCvr = statCvr;
    }

    public Double getPreCtr() {
        return this.preCtr;
    }

    public void setPreCtr(Double preCtr) {
        this.preCtr = preCtr;
    }

    public Double getPreCvr() {
        return this.preCvr;
    }

    public void setPreCvr(Double preCvr) {
        this.preCvr = preCvr;
    }

    public Boolean getSmartShop() {
        return this.smartShop;
    }

    public void setSmartShop(Boolean smartShop) {
        this.smartShop = smartShop;
    }

    public Integer getQualityLevel() {
        return Optional.ofNullable(this.qualityLevel).orElse(0);
    }

    public void setQualityLevel(Integer qualityLevel) {
        this.qualityLevel = qualityLevel;
    }

    public Optional<StatisticData> getSmartShopStatisticData() {
        return Optional.ofNullable(this.smartShopStatisticData);
    }

    public void setSmartShopStatisticData(StatisticData smartShopStatisticData) {
        this.smartShopStatisticData = smartShopStatisticData;
    }

    @Override
    public StatisticData getHourAppStatisticData() {
        return this.hourAppStatisticData;
    }

    public void setHourAppStatisticData(StatisticData hourAppStatisticData) {
        this.hourAppStatisticData = hourAppStatisticData;
    }

    @Override
    public StatisticData getTodayAppStatisticData() {
        return this.todayAppStatisticData;
    }

    public void setTodayAppStatisticData(StatisticData todayAppStatisticData) {
        this.todayAppStatisticData = todayAppStatisticData;
    }

    @Override
    public StatisticData getRecently7DayAppStatisticData() {
        return this.recently7DayAppStatisticData;
    }

    public void setRecently7DayAppStatisticData(StatisticData recently7DayAppStatisticData) {
        this.recently7DayAppStatisticData = recently7DayAppStatisticData;
    }

    @Override
    public StatisticData getHourStatisticData() {
        return this.hourStatisticData;
    }

    public void setHourStatisticData(StatisticData hourStatisticData) {
        this.hourStatisticData = hourStatisticData;
    }

    @Override
    public StatisticData getTodayStatisticData() {
        return this.todayStatisticData;
    }

    public void setTodayStatisticData(StatisticData todayStatisticData) {
        this.todayStatisticData = todayStatisticData;
    }

    @Override
    public StatisticData getRecently7DayStatisticData() {
        return this.recently7DayStatisticData;
    }

    public void setRecently7DayStatisticData(StatisticData recently7DayStatisticData) {
        this.recently7DayStatisticData = recently7DayStatisticData;
    }

    public Double getAdjustPriceFactor() {
        return Optional.ofNullable(this.adjustPriceFactor).orElse(1.0);
    }

    public Boolean getSupportStatus() {
        return this.supportStatus;
    }

    public void setSupportStatus(Boolean supportStatus) {
        this.supportStatus = supportStatus;
    }

    public Boolean getNeedSupportWeight() {
        return this.needSupportWeight;
    }

    public void setNeedSupportWeight(Boolean needSupportWeight) {
        this.needSupportWeight = needSupportWeight;
    }

    public Long getAssessCost() {
        return this.assessCost;
    }

    public void setAssessCost(Long assessCost) {
        this.assessCost = assessCost;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return this.advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getClickFee() {
        return this.clickFee;
    }

    public void setClickFee(Long clickFee) {
        this.clickFee = clickFee;
    }

    public Long getBudget() {
        return this.budget;
    }

    public void setBudget(Long budget) {
        this.budget = budget;
    }

    public Integer getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Set<Material> getMaterials() {
        return Optional.ofNullable(this.materials).orElseGet(HashSet::new);
    }

    public void setMaterials(Set<Material> materials) {
        this.materials = materials;
    }

    public List<Double> getHourlyBudgetFees() {
        return this.hourlyBudgetFees;
    }

    public void setHourlyBudgetFees(List<Double> hourlyBudgetFees) {
        this.hourlyBudgetFees = hourlyBudgetFees;
    }

    public List<Double> getHourlyBudgetCounts() {
        return this.hourlyBudgetCounts;
    }

    public void setHourlyBudgetCounts(List<Double> hourlyBudgetCounts) {
        this.hourlyBudgetCounts = hourlyBudgetCounts;
    }

    public Long getConvertCost() {
        return this.convertCost;
    }

    public void setConvertCost(Long convertCost) {
        this.convertCost = convertCost;
    }

    public Integer getPackageType() {
        return this.packageType;
    }

    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    public Integer getTargetAppLimit() {
        return this.targetAppLimit;
    }

    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    public Boolean getStrongTarget() {
        return this.strongTarget;
    }

    public void setStrongTarget(Boolean strongTarget) {
        this.strongTarget = strongTarget;
    }

    public String getNewTradeTagNum() {
        return this.newTradeTagNum;
    }

    public void setNewTradeTagNum(String newTradeTagNum) {
        this.newTradeTagNum = newTradeTagNum;
    }

    public Boolean enableBudgetSmooth() {
        return this.budgetSmooth.equals(1);
    }

    public Boolean disableBudgetSmooth() {
        return this.enableBudgetSmooth() == false;
    }

    public void setBudgetSmooth(Integer budgetSmooth) {
        this.budgetSmooth = budgetSmooth;
    }

    public SmoothResultDo getSmoothResultDo() {
        return this.smoothResultDo;
    }

    public void setSmoothResultDo(SmoothResultDo smoothResultDo) {
        this.smoothResultDo = smoothResultDo;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getSimpleSupportType() {
        return this.simpleSupportType;
    }

    public void setSimpleSupportType(String simpleSupportType) {
        this.simpleSupportType = simpleSupportType;
    }

    public Double getFeeWeightFactor() {
        return this.feeWeightFactor;
    }

    public void setFeeWeightFactor(Double feeWeightFactor) {
        this.feeWeightFactor = feeWeightFactor;
    }

    public AlgoRescureEntity getAlgoRescureEntity() {
        return this.algoRescureEntity;
    }

    public void setAlgoRescureEntity(AlgoRescureEntity algoRescureEntity) {
        this.algoRescureEntity = algoRescureEntity;
    }

    public Integer getPotentionalStatus() {
        return Optional.ofNullable(this.potentionalStatus).orElse(0);
    }

    public void setPotentionalStatus(Integer potentionalStatus) {
        this.potentionalStatus = potentionalStatus;
    }

    public Boolean getNeedPotentionalSupport() {
        return Optional.ofNullable(this.needPotentionalSupport).orElse(false);
    }

    public void setNeedPotentionalSupport(Boolean needPotentionalSupport) {
        this.needPotentionalSupport = needPotentionalSupport;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrientationPackage that = (OrientationPackage)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.advertId, that.advertId);
    }

    public Boolean isWeakTarget() {
        return this.strongTarget == false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.advertId);
    }

    public Boolean isCpa() {
        return this.chargeType.equals(ChargeTypeEnum.CPA.getValue());
    }

    public void setAdjustPriceFactor(Double adjustPriceFactor) {
        this.adjustPriceFactor = adjustPriceFactor;
    }

    public Long getOriginalFee() {
        return this.isCpa() != false ? this.convertCost : this.clickFee;
    }

    public void setSupportInfoSupportWeight(Double supportInfoSupportWeight) {
        this.supportInfoSupportWeight = supportInfoSupportWeight;
    }

    public Double getSupportInfoSupportWeight() {
        return Optional.ofNullable(this.supportInfoSupportWeight).orElse(0.0);
    }

    public Double getGiveUpProb10() {
        return this.giveUpProb10;
    }

    public void setGiveUpProb10(Double giveUpProb10) {
        this.giveUpProb10 = giveUpProb10;
    }

    public Double getGiveUpProb5() {
        return this.giveUpProb5;
    }

    public void setGiveUpProb5(Double giveUpProb5) {
        this.giveUpProb5 = giveUpProb5;
    }
}

