/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.message.advert.ons;

import cn.com.duiba.nezha.engine.biz.message.advert.ons.AbstractMessageResultHandler;
import cn.com.duiba.nezha.engine.biz.message.advert.ons.OnsRoiControllerMessageTag;
import cn.com.duiba.nezha.engine.biz.message.advert.ons.RocketMqMessageListener;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RoiCostMessageHandler
extends AbstractMessageResultHandler {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public String getListenTag() {
        return OnsRoiControllerMessageTag.ROI_COST.getTag();
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank((String)message)) {
            JSONObject json = JSONObject.parseObject((String)message);
            String advertId = json.getString("adid");
            String packageId = json.getString("packageId");
            if (StringUtils.isBlank((String)advertId) || StringUtils.isBlank((String)packageId)) {
                this.logger.warn("conusmer message:{} error,illegal argument", (Object)message);
                return;
            }
            this.logger.info("roi cost change message:{}", (Object)message);
            String feeKey = RedisKeyUtil.roiFeeKey((String)advertId, (String)packageId, (LocalDate)LocalDate.now());
            String cvrKey = RedisKeyUtil.roiCvrKey((String)advertId, (String)packageId, (LocalDate)LocalDate.now());
            this.stringRedisTemplate.delete((Object)feeKey);
            this.stringRedisTemplate.delete((Object)cvrKey);
            this.mongoTemplate.remove(Query.query((CriteriaDefinition)new Criteria("advertId").is((Object)advertId).and("packageId").is((Object)packageId)), "cpa_factor");
        }
    }

    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}

