/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.engine.api.enums.FlowTag;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.domain.mergeData.MergeData;
import cn.com.duiba.nezha.engine.biz.enums.AdvertType;
import cn.com.duiba.nezha.engine.biz.enums.BackendDefaultCVR;
import cn.com.duiba.nezha.engine.biz.enums.MergeDataType;
import cn.com.duiba.nezha.engine.biz.service.advert.AdvertSmartShopService;
import cn.com.duiba.nezha.engine.biz.service.advert.OrientationPackageAdjustPriceFactorService;
import cn.com.duiba.nezha.engine.biz.service.advert.TradeRepetitionLaunchService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertMergeStatService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertStatService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.TagStatAssociationService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.Pair;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataHandleBo {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AdvertMergeStatService advertMergeStatService;
    @Autowired
    private AdvertStatService advertStatService;
    @Autowired
    private OrientationPackageAdjustPriceFactorService orientationPackageAdjustPriceFactorService;
    @Autowired
    private TagStatAssociationService tagStatAssociationService;
    @Autowired
    private AdvertSmartShopService advertSmartShopService;
    @Autowired
    private TradeRepetitionLaunchService tradeRepetitionLaunchService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMergeData(Collection<Advert> adverts, Long appId) {
        try {
            DBTimeProfile.enter((String)"handleMergeData");
            Map<MergeDataType, List<MergeData>> advertAndAppData = this.advertMergeStatService.getAdvertAndAppData(adverts, appId);
            Map appMergeDataMap = ((List)advertAndAppData.getOrDefault((Object)MergeDataType.APP, new ArrayList())).stream().collect(Collectors.toMap(MergeData::getAdvertId, Function.identity()));
            Map globalMergeDataMap = ((List)advertAndAppData.getOrDefault((Object)MergeDataType.GLOBAL, new ArrayList())).stream().collect(Collectors.toMap(MergeData::getAdvertId, Function.identity()));
            adverts.forEach(advert -> {
                MergeData appMergeData = (MergeData)appMergeDataMap.get(advert.getId());
                MergeData globalMergeData = (MergeData)globalMergeDataMap.get(advert.getId());
                advert.setAppMergeData(appMergeData);
                advert.setGlobalMergeData(globalMergeData);
                this.handleStatCtrAndCvr((Advert)advert);
            });
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private void handleStatCtrAndCvr(Advert advert) {
        Optional<MergeData> globalMergeData = advert.getGlobalMergeData();
        advert.getOrientationPackages().forEach(orientationPackage -> {
            if (advert.getType().equals((Object)AdvertType.INTERACT)) {
                Integer cvrType = orientationPackage.getCvrType();
                orientationPackage.setStatCtr(globalMergeData.map(MergeData::getCtr).orElse(0.2));
                orientationPackage.setStatCvr(globalMergeData.map(mergeData -> mergeData.getCvr(cvrType)).orElse(BackendDefaultCVR.getCvr(cvrType)));
                Optional<MergeData> appMergeData = advert.getAppMergeData();
                appMergeData.map(MergeData::getCtr).ifPresent(orientationPackage::setStatCtr);
                appMergeData.map(mergeData -> mergeData.getCvr(cvrType)).ifPresent(orientationPackage::setStatCvr);
            } else if (advert.getType().equals((Object)AdvertType.SHOW)) {
                orientationPackage.setStatCtr(globalMergeData.map(MergeData::getCtr).orElse(0.01));
                orientationPackage.setStatCvr(globalMergeData.map(MergeData::getCvr).orElse(0.1));
                Optional<MergeData> appMergeData = advert.getAppMergeData();
                appMergeData.map(MergeData::getCtr).ifPresent(orientationPackage::setStatCtr);
                appMergeData.map(MergeData::getCvr).ifPresent(orientationPackage::setStatCvr);
            } else {
                orientationPackage.setStatCtr(globalMergeData.map(MergeData::getCtr).orElse(0.2));
                orientationPackage.setStatCvr(globalMergeData.map(MergeData::getCvr).orElse(0.02));
                Optional<MergeData> appMergeData = advert.getAppMergeData();
                appMergeData.map(MergeData::getCtr).ifPresent(orientationPackage::setStatCtr);
                appMergeData.map(MergeData::getCvr).ifPresent(orientationPackage::setStatCvr);
            }
        });
    }

    public void handleAdjustPriceFactor(Set<OrientationPackage> orientationPackages, Long appId, Long slotId) {
        this.orientationPackageAdjustPriceFactorService.handle(orientationPackages, appId, slotId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStatisticData(Collection<Advert> adverts, Set<OrientationPackage> orientationPackages, Long appId) {
        try {
            DBTimeProfile.enter((String)"handleStatisticData");
            HashSet<AdvertStatService.Query> queries = new HashSet<AdvertStatService.Query>();
            HashMap advertQueryMap = new HashMap();
            HashMap packageQueryMap = new HashMap();
            orientationPackages.forEach(orientationPackage -> {
                Long advertId = orientationPackage.getAdvertId();
                Long packageId = orientationPackage.getId();
                AdvertStatService.Query advertQuery = AdvertStatService.Query.newBuilder().advertId(advertId).build();
                AdvertStatService.Query advertAppQuery = AdvertStatService.Query.newBuilder().advertId(advertId).appId(appId).build();
                AdvertStatService.Query packageQuery = AdvertStatService.Query.newBuilder().advertId(advertId).packageId(packageId).build();
                AdvertStatService.Query packageAppQuery = AdvertStatService.Query.newBuilder().advertId(advertId).packageId(packageId).appId(appId).build();
                queries.add(advertQuery);
                queries.add(advertAppQuery);
                queries.add(packageQuery);
                queries.add(packageAppQuery);
                advertQueryMap.put(advertId, Pair.of((Object)advertQuery, (Object)advertAppQuery));
                packageQueryMap.put(orientationPackage, Pair.of((Object)packageQuery, (Object)packageAppQuery));
            });
            Map<AdvertStatService.Query, StatisticData> currentHourStatMap = this.advertStatService.getCurrentHourStat(queries);
            Map<AdvertStatService.Query, StatisticData> currentDayStatMap = this.advertStatService.getCurrentDayStat(queries);
            Map<AdvertStatService.Query, StatisticData> recently7DayStatMap = this.advertStatService.get7DayStat(queries);
            adverts.forEach(advert -> {
                Pair queryPair = (Pair)advertQueryMap.get(advert.getId());
                Optional advertQuery = queryPair.getLeft();
                Optional advertAppQuery = queryPair.getRight();
                advertQuery.map(currentHourStatMap::get).ifPresent(advert::setHourStatisticData);
                advertQuery.map(currentDayStatMap::get).ifPresent(advert::setTodayStatisticData);
                advertQuery.map(recently7DayStatMap::get).ifPresent(advert::setRecently7DayStatisticData);
                advertAppQuery.map(currentHourStatMap::get).ifPresent(advert::setHourAppStatisticData);
                advertAppQuery.map(currentDayStatMap::get).ifPresent(advert::setTodayAppStatisticData);
                advertAppQuery.map(recently7DayStatMap::get).ifPresent(advert::setRecently7DayAppStatisticData);
            });
            orientationPackages.forEach(orientationPackage -> {
                Pair queryPair = (Pair)packageQueryMap.get(orientationPackage);
                Optional packageQuery = queryPair.getLeft();
                Optional packageAppQuery = queryPair.getRight();
                packageQuery.map(currentHourStatMap::get).ifPresent(orientationPackage::setHourStatisticData);
                packageQuery.map(currentDayStatMap::get).ifPresent(orientationPackage::setTodayStatisticData);
                packageQuery.map(recently7DayStatMap::get).ifPresent(orientationPackage::setRecently7DayStatisticData);
                packageAppQuery.map(currentHourStatMap::get).ifPresent(orientationPackage::setHourAppStatisticData);
                packageAppQuery.map(currentDayStatMap::get).ifPresent(orientationPackage::setTodayAppStatisticData);
                packageAppQuery.map(recently7DayStatMap::get).ifPresent(orientationPackage::setRecently7DayAppStatisticData);
            });
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSmartShopData(Set<OrientationPackage> orientationPackages) {
        try {
            DBTimeProfile.enter((String)"handleSmartShopData");
            Map orientPackage2QueryMap = orientationPackages.stream().collect(Collectors.toMap(Function.identity(), orientPackage -> AdvertStatService.Query.newBuilder().advertId(orientPackage.getAdvertId()).packageId(orientPackage.getId()).tag(FlowTag.GOOD.getTag()).build()));
            Map<AdvertStatService.Query, StatisticData> currentDayStat = this.advertStatService.getCurrentDayStat(orientPackage2QueryMap.values());
            orientationPackages.forEach(orientationPackage -> orientationPackage.setSmartShopStatisticData((StatisticData)currentDayStat.get(orientPackage2QueryMap.get(orientationPackage))));
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSmartShopWhiteBlackData(Set<OrientationPackage> orientationPackages, Long appId, Long slotId, Long activityId) {
        try {
            DBTimeProfile.enter((String)"handleSmartShopWhiteBlackData");
            this.advertSmartShopService.handlePackageQualityLevelLevel(orientationPackages, appId, slotId, activityId);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public void handleHourlyData(Collection<Advert> adverts, Long appId) {
        try {
            DBTimeProfile.enter((String)"handleHourlyData");
            Map advertQueryMap = adverts.stream().collect(Collectors.toMap(Function.identity(), advert -> AdvertStatService.Query.newBuilder().appId(appId).advertId(advert.getId()).build()));
            Map<AdvertStatService.Query, List<StatisticData>> todayHourlyStatMap = this.advertStatService.getTodayHourlyStat(advertQueryMap.values());
            adverts.forEach(advert -> {
                List statisticDataList = todayHourlyStatMap.getOrDefault(advertQueryMap.get(advert), new ArrayList());
                advert.getOrientationPackages().forEach(orientationPackage -> {
                    ArrayList<Double> hourlyCtr = new ArrayList<Double>();
                    ArrayList<Double> hourlyCvr = new ArrayList<Double>();
                    ArrayList<Double> hourlyClick = new ArrayList<Double>();
                    ArrayList<Double> hourlyLaunch = new ArrayList<Double>();
                    ArrayList<Double> hourlyConsume = new ArrayList<Double>();
                    statisticDataList.forEach(statisticData -> {
                        hourlyCtr.add(statisticData.getCtr());
                        hourlyCvr.add(statisticData.getCvr(orientationPackage.getCvrType()));
                        hourlyClick.add(statisticData.getChargeClickCount().doubleValue());
                        hourlyLaunch.add(statisticData.getLaunchCount().doubleValue());
                        hourlyConsume.add(statisticData.getTotalConsume().doubleValue());
                    });
                    orientationPackage.setHourlyCtr(hourlyCtr);
                    orientationPackage.setHourlyCvr(hourlyCvr);
                    orientationPackage.setHourlyClick(hourlyClick);
                    orientationPackage.setHourlyLaunch(hourlyLaunch);
                    orientationPackage.setHourlyConsume(hourlyConsume);
                });
            });
        }
        catch (Exception e) {
            throw new RecommendEngineException("getTodayHourlyStat error", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public void handleTagData(Collection<Advert> adverts, Long appId) {
        try {
            DBTimeProfile.enter((String)"handleTagData");
            this.tagStatAssociationService.handleTagStat(adverts, appId);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public void handTradeRepetitionLaunch(AdvertRecommendRequestVo advertRecommendRequestVo) {
        try {
            DBTimeProfile.enter((String)"handTradeRepetitionLaunch");
            CatUtils.executeInCatTransaction(() -> {
                this.tradeRepetitionLaunchService.handTradeRepetitionLaunchStat(advertRecommendRequestVo);
                return null;
            }, (String)"Hbase", (String)"handTradeRepetitionLaunchStat");
            this.tradeRepetitionLaunchService.handInterestPortrayalStat(advertRecommendRequestVo);
        }
        catch (Throwable throwable) {
            this.logger.error("handTradeRepetitionLaunch error !", throwable);
        }
        finally {
            DBTimeProfile.release();
        }
    }
}

