/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class TradeRepetitionLaunchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TradeRepetitionLaunchService.class);
    @Autowired
    private HbaseTemplate hbaseTemplate;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final String CONSUMER_RESOURCE_FEATURE = "consumer_trade_feature";
    private static final String TB_TRADE_FEATURE_DI = "tb_trade_feature_di";
    private static final String OLD_NEW_TAG_TRADE_CODE = "660201";
    private LoadingCache<String, Map<String, Long>> handInterestPortrayalStat = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, Long>>(){

        public Map<String, Long> load(String key) throws Exception {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<String, Map<String, Long>> loadAll(Iterable<? extends String> keys) throws Exception {
            return TradeRepetitionLaunchService.this.gethandInterestPortrayalStat(keys);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handTradeRepetitionLaunchStat(AdvertRecommendRequestVo advertRecommendRequestVo) {
        ConsumerDo consumerDo = advertRecommendRequestVo.getConsumerDo();
        Long consumerId = consumerDo.getId();
        try {
            String nowDate = LocalDate.now().format(DATE_TIME_FORMATTER);
            String newTradeToLaunchKey = DigestUtils.md5DigestAsHex((byte[])String.valueOf(consumerId).getBytes()).substring(0, 4) + "-" + consumerId + "-" + nowDate;
            String newTradeToOtherKey = DigestUtils.md5DigestAsHex((byte[])String.valueOf(consumerId).getBytes()).substring(0, 4) + "-" + consumerId + "-" + nowDate + "-str";
            ArrayList allKeys = Lists.newArrayList((Object[])new String[]{newTradeToLaunchKey, newTradeToOtherKey});
            HashMap map = new HashMap();
            DBTimeProfile.enter((String)"hbaseResourceGet");
            this.hbaseTemplate.execute(CONSUMER_RESOURCE_FEATURE, table -> {
                List gets = allKeys.stream().map(rowKey -> new Get(rowKey.getBytes())).collect(Collectors.toList());
                Result[] results = table.get(gets);
                for (int i = 0; i < results.length; ++i) {
                    Result result = results[i];
                    map.put(allKeys.get(i), result);
                }
                return null;
            });
            Result newTradeToLaunchResult = (Result)map.get(newTradeToLaunchKey);
            Map<String, Long> newTradeToLaunchMap = this.resolverResultValueToLong(newTradeToLaunchResult);
            Result result2 = (Result)map.get(newTradeToOtherKey);
            Map<String, String> newTradeLastGmtCreateTime = this.resolverResultValueToString(result2);
            Optional.ofNullable(newTradeLastGmtCreateTime.get(OLD_NEW_TAG_TRADE_CODE)).ifPresent(consumerDo::setLastOperatingNewTrade);
            consumerDo.setNewTradeDayOrderRank(newTradeToLaunchMap);
            consumerDo.setNewTradeLastGmtCreateTime(newTradeLastGmtCreateTime);
        }
        catch (Exception e) {
            LOGGER.warn("TradeRepetitionLaunchService.handTradeRepetitionLaunchStat error ", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<String, String> resolverResultValueToString(Result result) {
        if (result == null || result.isEmpty()) {
            return new HashMap<String, String>();
        }
        List cells = result.listCells();
        HashMap<String, String> map = new HashMap<String, String>(cells.size());
        for (Cell cell : cells) {
            String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            map.put(qualifier, value);
        }
        return map;
    }

    private Map<String, Long> resolverResultValueToLong(Result result) {
        if (result == null || result.isEmpty()) {
            return new HashMap<String, Long>();
        }
        List cells = result.listCells();
        HashMap<String, Long> map = new HashMap<String, Long>(cells.size());
        for (Cell cell : cells) {
            String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            map.put(qualifier, Long.valueOf(value));
        }
        return map;
    }

    public void handInterestPortrayalStat(AdvertRecommendRequestVo advertRecommendRequestVo) {
        try {
            Map<Long, Advert> advertMap = advertRecommendRequestVo.getAdvertMap();
            AppDo appDo = advertRecommendRequestVo.getAppDo();
            Collection<Advert> adverts = advertMap.values();
            ArrayList<String> allKeys = new ArrayList<String>(adverts.size() * 6 + 6);
            HashMap<Advert, Map<Boolean, Map<String, String>>> advertRowKeys = new HashMap<Advert, Map<Boolean, Map<String, String>>>(adverts.size());
            adverts.forEach(advert -> {
                HashMap<String, String> newTradeTagNumRowKeysMap = new HashMap<String, String>(3);
                String newTradeTagId = advert.getNewTradeTagId();
                String newTradeTagIdLaunchKey = "1_launch_" + newTradeTagId;
                String newTradeTagIdClickKey = "1_click_" + newTradeTagId;
                String newTradeTagIdEffectKey = "1_effect_" + newTradeTagId;
                String newTradeTagIdLaunchRowKey = this.geMD5RowKey(newTradeTagIdLaunchKey);
                String newTradeTagIdClickRowKey = this.geMD5RowKey(newTradeTagIdClickKey);
                String newTradeTagIdEffectRowKey = this.geMD5RowKey(newTradeTagIdEffectKey);
                allKeys.add(newTradeTagIdLaunchRowKey);
                allKeys.add(newTradeTagIdClickRowKey);
                allKeys.add(newTradeTagIdEffectRowKey);
                newTradeTagNumRowKeysMap.put("launch", newTradeTagIdLaunchRowKey);
                newTradeTagNumRowKeysMap.put("click", newTradeTagIdClickRowKey);
                newTradeTagNumRowKeysMap.put("effect", newTradeTagIdEffectRowKey);
                HashMap<String, String> advertRowKeysMap = new HashMap<String, String>(3);
                Long advertId = advert.getId();
                String advertLaunchKey = "4_launch_" + advertId;
                String advertClickKey = "4_click_" + advertId;
                String advertEffectKey = "4_effect_" + advertId;
                String advertLaunchRowKey = this.geMD5RowKey(advertLaunchKey);
                String advertClickRowKey = this.geMD5RowKey(advertClickKey);
                String advertEffectRowKey = this.geMD5RowKey(advertEffectKey);
                advertRowKeysMap.put("launch", advertLaunchRowKey);
                advertRowKeysMap.put("click", advertClickRowKey);
                advertRowKeysMap.put("effect", advertEffectRowKey);
                allKeys.add(advertLaunchRowKey);
                allKeys.add(advertClickRowKey);
                allKeys.add(advertEffectRowKey);
                HashMap<Boolean, HashMap<String, String>> isnewTradeTagNumRowKeysMap = new HashMap<Boolean, HashMap<String, String>>(2);
                isnewTradeTagNumRowKeysMap.put(true, newTradeTagNumRowKeysMap);
                isnewTradeTagNumRowKeysMap.put(false, advertRowKeysMap);
                advertRowKeys.put((Advert)advert, (Map<Boolean, Map<String, String>>)isnewTradeTagNumRowKeysMap);
            });
            HashMap<String, String> appTradeRowKeysMap = new HashMap<String, String>(3);
            String industryTagPid = appDo.getIndustryTagPid();
            String industryTagPidLaunchKey = "2_launch_" + industryTagPid;
            String industryTagPidClickKey = "2_click_" + industryTagPid;
            String industryTagPidEffectKey = "2_effect_" + industryTagPid;
            String newTradeTagNumLaunchRowKey = this.geMD5RowKey(industryTagPidLaunchKey);
            String newTradeTagNumClickRowKey = this.geMD5RowKey(industryTagPidClickKey);
            String newTradeTagNumEffectRowKey = this.geMD5RowKey(industryTagPidEffectKey);
            allKeys.add(newTradeTagNumLaunchRowKey);
            allKeys.add(newTradeTagNumClickRowKey);
            allKeys.add(newTradeTagNumEffectRowKey);
            appTradeRowKeysMap.put("launch", newTradeTagNumLaunchRowKey);
            appTradeRowKeysMap.put("click", newTradeTagNumClickRowKey);
            appTradeRowKeysMap.put("effect", newTradeTagNumEffectRowKey);
            HashMap<String, String> appRowKeysMap = new HashMap<String, String>(3);
            Long appId = appDo.getId();
            String appLaunchKey = "3_launch_" + appId;
            String appClickKey = "3_click_" + appId;
            String appEffectKey = "3_effect_" + appId;
            String appLaunchRowKey = this.geMD5RowKey(appLaunchKey);
            String appClickRowKey = this.geMD5RowKey(appClickKey);
            String appEffectRowKey = this.geMD5RowKey(appEffectKey);
            allKeys.add(appLaunchRowKey);
            allKeys.add(appClickRowKey);
            allKeys.add(appEffectRowKey);
            appRowKeysMap.put("launch", appLaunchRowKey);
            appRowKeysMap.put("click", appClickRowKey);
            appRowKeysMap.put("effect", appEffectRowKey);
            HashMap<Boolean, Map<String, String>> isAppTradeRowKeysMap = new HashMap<Boolean, Map<String, String>>(2);
            isAppTradeRowKeysMap.put(true, appTradeRowKeysMap);
            isAppTradeRowKeysMap.put(false, appRowKeysMap);
            ImmutableMap handInterestPortrayalStatMap = this.handInterestPortrayalStat.getAll(allKeys);
            this.bindhandInterestPortrayalDynamicStat(adverts, advertRowKeys, (Map<String, Map<String, Long>>)handInterestPortrayalStatMap);
            this.bindhandInterestPortrayalStaticStat(advertRecommendRequestVo, isAppTradeRowKeysMap, (Map<String, Map<String, Long>>)handInterestPortrayalStatMap);
        }
        catch (Exception e) {
            LOGGER.warn("TradeRepetitionLaunchService.handInterestPortrayalStat error", (Throwable)e);
        }
    }

    private void bindhandInterestPortrayalStaticStat(AdvertRecommendRequestVo advertRecommendRequestVo, Map<Boolean, Map<String, String>> isAppTradeRowKeysMap, Map<String, Map<String, Long>> handInterestPortrayalStatMap) {
        Map<String, String> appTradeRowKeysMap = isAppTradeRowKeysMap.get(true);
        Map<String, String> appRowKeysMap = isAppTradeRowKeysMap.get(false);
        Map appTradeStatMap = MapUtils.translate(appTradeRowKeysMap, handInterestPortrayalStatMap);
        Map appStatMap = MapUtils.translate(appRowKeysMap, handInterestPortrayalStatMap);
        advertRecommendRequestVo.setAppTagInNewTrade(appTradeStatMap);
        advertRecommendRequestVo.setAppInNewTrade(appStatMap);
    }

    private void bindhandInterestPortrayalDynamicStat(Collection<Advert> adverts, Map<Advert, Map<Boolean, Map<String, String>>> advertRowKeys, Map<String, Map<String, Long>> handInterestPortrayalStatMap) {
        adverts.forEach(advert -> {
            Map rowKeysMap = (Map)advertRowKeys.get(advert);
            Map newTradeTagIdRowKeysMap = (Map)rowKeysMap.get(true);
            Map advertRowKeysMap = (Map)rowKeysMap.get(false);
            Map newTradeTagIdStatMap = MapUtils.translate((Map)newTradeTagIdRowKeysMap, (Map)handInterestPortrayalStatMap);
            Map advertStatMap = MapUtils.translate((Map)advertRowKeysMap, (Map)handInterestPortrayalStatMap);
            advert.setNewTradeInAppTag(newTradeTagIdStatMap);
            advert.setAdvertInAppTag(advertStatMap);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, Long>> gethandInterestPortrayalStat(Iterable<? extends String> keys) {
        ArrayList allKeys = Lists.newArrayList(keys);
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)allKeys.size());
        DBTimeProfile.enter((String)"hbaseResourceGet");
        try {
            this.hbaseTemplate.execute(TB_TRADE_FEATURE_DI, table -> {
                List gets = allKeys.stream().map(rowKey -> new Get(rowKey.getBytes())).collect(Collectors.toList());
                Result[] results = table.get(gets);
                for (int i = 0; i < results.length; ++i) {
                    Result result = results[i];
                    if (result == null || result.isEmpty()) {
                        returnMap.put(allKeys.get(i), new HashMap());
                        continue;
                    }
                    List cells = result.listCells();
                    HashMap resultMap = Maps.newHashMapWithExpectedSize((int)cells.size());
                    for (Cell cell : cells) {
                        String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                        String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                        resultMap.put(qualifier, Long.valueOf(value));
                    }
                    returnMap.put(allKeys.get(i), resultMap);
                }
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("TradeRepetitionLaunchService.gethandInterestPortrayalStat happend error", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
        return returnMap;
    }

    @NotNull
    private String geMD5RowKey(String newTradeTagNumLaunchKey) {
        return DigestUtils.md5DigestAsHex((byte[])newTradeTagNumLaunchKey.getBytes()).substring(0, 4) + "-" + newTradeTagNumLaunchKey;
    }
}

