/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr.impl;

import cn.com.duiba.nezha.alg.common.util.StringZIP;
import cn.com.duiba.nezha.alg.feature.parse.FeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.ESMM;
import cn.com.duiba.nezha.alg.model.FFM;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.engine.api.enums.DeepTfServer;
import cn.com.duiba.nezha.engine.api.enums.ModelKey;
import cn.com.duiba.nezha.engine.api.enums.ModelKeyEnum;
import cn.com.duiba.nezha.engine.api.enums.ModelType;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.bo.hbase.ConsumerFeatureBo;
import cn.com.duiba.nezha.engine.biz.domain.ActivityDo;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatFeatureDo;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerDo;
import cn.com.duiba.nezha.engine.biz.domain.FeatureIndex;
import cn.com.duiba.nezha.engine.biz.domain.RequestDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.advert.Material;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertPredictService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertStatFeatureService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.SystemClock;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AdvertPredictServiceImpl
extends CacheService
implements AdvertPredictService,
InitializingBean {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<ModelKeyEnum, IModel> offlineFMModelCache = CacheBuilder.newBuilder().refreshAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ModelKeyEnum, IModel>(){

        public IModel load(ModelKeyEnum modelKey) {
            return AdvertPredictServiceImpl.this.loadFMModel(modelKey).orElse(null);
        }

        public ListenableFuture<IModel> reload(ModelKeyEnum modelKey, IModel oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> AdvertPredictServiceImpl.this.loadFMModel(modelKey).orElse(oldValue));
            AdvertPredictServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    });
    private final LoadingCache<ModelKeyEnum, IModel> onlineFFMModelCache = CacheBuilder.newBuilder().refreshAfterWrite(90L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ModelKeyEnum, IModel>(){

        public IModel load(ModelKeyEnum modelKey) {
            return AdvertPredictServiceImpl.this.loadFFMModel(modelKey).orElse(null);
        }

        public ListenableFuture<IModel> reload(ModelKeyEnum modelKey, IModel oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> AdvertPredictServiceImpl.this.loadFFMModel(modelKey).orElse(oldValue));
            AdvertPredictServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    });
    private final LoadingCache<ModelKeyEnum, IModel> onlineCODERModelCache = CacheBuilder.newBuilder().refreshAfterWrite(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ModelKeyEnum, IModel>(){

        public IModel load(ModelKeyEnum modelKey) {
            return AdvertPredictServiceImpl.this.loadCODERModel(modelKey).orElse(null);
        }

        public ListenableFuture<IModel> reload(ModelKeyEnum modelKey, IModel oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> AdvertPredictServiceImpl.this.loadCODERModel(modelKey).orElse(oldValue));
            AdvertPredictServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    });
    private final LoadingCache<ModelKeyEnum, IModel> onlineFMModelCache = CacheBuilder.newBuilder().refreshAfterWrite(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ModelKeyEnum, IModel>(){

        public IModel load(ModelKeyEnum modelKey) {
            return AdvertPredictServiceImpl.this.loadFMModel(modelKey).orElse(null);
        }

        public ListenableFuture<IModel> reload(ModelKeyEnum modelKey, IModel oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> AdvertPredictServiceImpl.this.loadFMModel(modelKey).orElse(oldValue));
            AdvertPredictServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    });
    @Autowired
    private ConsumerFeatureBo consumerFeatureBo;
    @Autowired
    private AdvertStatFeatureService advertStatFeatureService;
    @Value(value="${spring.profiles.active}")
    private String active;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<PredictResultType, Map<FeatureIndex, Double>> predict(AdvertRecommendRequestVo advertRecommendRequestVo, Map<PredictResultType, Collection<Advert>> needPredictAdvertMap) {
        try {
            DBTimeProfile.enter((String)"predict");
            Collection<Advert> adverts = advertRecommendRequestVo.getAdvertMap().values();
            AppDo appDo = advertRecommendRequestVo.getAppDo();
            RequestDo requestDo = advertRecommendRequestVo.getRequestDo();
            ConsumerDo consumerDo = advertRecommendRequestVo.getConsumerDo();
            ActivityDo activityDo = advertRecommendRequestVo.getActivityDo();
            Long appId = appDo.getId();
            Long slotId = appDo.getSlotId();
            Long activityId = activityDo.getOperatingId();
            Map<Long, AdvertStatFeatureDo> advertStatFeatureMap = this.advertStatFeatureService.get(appId, slotId, activityId, adverts);
            advertRecommendRequestVo.setAdvertStatFeatureMap(advertStatFeatureMap);
            Map<FeatureIndex, Map<String, String>> featureMap = this.getFeatureMap(adverts, consumerDo, appDo, activityDo, requestDo, advertStatFeatureMap, advertRecommendRequestVo);
            advertRecommendRequestVo.setFeatureMap(featureMap);
            MutModelType mutModelType = advertRecommendRequestVo.getMutModelType();
            IModel ctrModel = this.getModel(advertRecommendRequestVo.getCtrModelKey());
            IModel cvrModel = this.getModel(advertRecommendRequestVo.getCvrModelKey());
            IModel fusingCtrModel = this.getModel(advertRecommendRequestVo.getFusingCtrModelKey());
            IModel fusingCvrModel = this.getModel(advertRecommendRequestVo.getFusingCvrModelKey());
            DeepTfServer deepCtrModelKey = advertRecommendRequestVo.getDeepCtrModelKey();
            DeepTfServer deepCvrModelKey = advertRecommendRequestVo.getDeepCvrModelKey();
            TFServingClient ctrTfServingClient = Optional.ofNullable(deepCtrModelKey).map(server -> new TFServingClient(server.getHost(), server.getPort().intValue(), server.getModelKey(), null)).orElse(null);
            TFServingClient cvrTfServingClient = Optional.ofNullable(deepCvrModelKey).map(server -> new TFServingClient(server.getHost(), server.getPort().intValue(), server.getModelKey(), null)).orElse(null);
            ESMM esmm = new ESMM(ctrModel, cvrModel, fusingCtrModel, fusingCvrModel, null, ctrTfServingClient, cvrTfServingClient, mutModelType);
            long now = SystemClock.now();
            Map predictResultTypeMapMap = (Map)CatUtils.executeInCatTransaction(() -> esmm.predictCTRsAndCVRsWithTF(featureMap), (String)"esmmPredict", (String)advertRecommendRequestVo.getAdvertAlgEnum().toString());
            advertRecommendRequestVo.setPredictCost(SystemClock.now() - now);
            Map<PredictResultType, Map<FeatureIndex, Double>> map = needPredictAdvertMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Map featurePredictValueMap = predictResultTypeMapMap.getOrDefault(entry.getKey(), new HashMap());
                return ((Collection)entry.getValue()).stream().map(this::convertToFeatureIndex).flatMap(Collection::stream).collect(Collectors.toMap(Function.identity(), featureIndex -> featurePredictValueMap.getOrDefault(featureIndex, 0.0)));
            }));
            return map;
        }
        catch (Throwable e) {
            this.logger.warn("predict happened error:{}", e);
            HashMap<PredictResultType, Map<FeatureIndex, Double>> hashMap = new HashMap<PredictResultType, Map<FeatureIndex, Double>>();
            return hashMap;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Set<FeatureIndex> convertToFeatureIndex(Advert advert) {
        Long advertId = advert.getId();
        Set<OrientationPackage> orientationPackages = advert.getOrientationPackages();
        return orientationPackages.stream().map(orientationPackage -> {
            Set<Material> materials = orientationPackage.getMaterials();
            if (materials.isEmpty()) {
                return Collections.singleton(new FeatureIndex(advertId, orientationPackage.getId()));
            }
            return materials.stream().map(material -> new FeatureIndex(advertId, orientationPackage.getId(), material.getId())).collect(Collectors.toSet());
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Map<FeatureIndex, Map<String, String>> getFeatureMap(Collection<Advert> adverts, ConsumerDo consumerDo, AppDo appDo, ActivityDo activityDo, RequestDo requestDo, Map<Long, AdvertStatFeatureDo> advertStatFeatureMap, AdvertRecommendRequestVo advertRecommendRequestVo) {
        FeatureDo staticFeatureDo = this.getFeatureDo(consumerDo, appDo, activityDo, requestDo);
        staticFeatureDo.setAppInNewTrade(advertRecommendRequestVo.getAppInNewTrade());
        staticFeatureDo.setAppTagInNewTrade(advertRecommendRequestVo.getAppTagInNewTrade());
        Map staticFeatureMap = FeatureParse.generateFeatureMapStatic((FeatureDo)staticFeatureDo);
        HashMap<FeatureIndex, Map<String, String>> finalFeatureMap = new HashMap<FeatureIndex, Map<String, String>>();
        adverts.forEach(advert -> advert.getOrientationPackages().forEach(orientationPackage -> {
            Long advertId = advert.getId();
            Long packageId = orientationPackage.getId();
            FeatureDo orientationPackageFeatureDo = new FeatureDo();
            orientationPackageFeatureDo.setAdvertId(advertId);
            orientationPackageFeatureDo.setAccountId(advert.getAccountId());
            orientationPackageFeatureDo.setMatchTagNums(advert.getMatchTags());
            orientationPackageFeatureDo.setTradeId2(advert.getIndustryTag());
            orientationPackageFeatureDo.setAdvertTags(advert.getSpreadTags().stream().filter(Objects::nonNull).collect(Collectors.joining(",")));
            orientationPackageFeatureDo.setTimes(advert.getLaunchCountToUser());
            orientationPackageFeatureDo.setOperatingResource(advert.getResourceTagNum());
            orientationPackageFeatureDo.setBankEndType(orientationPackage.getCvrType().toString());
            orientationPackageFeatureDo.setOperatingNewTrade(advert.getNewTradeTagId());
            orientationPackageFeatureDo.setNewTradeInAppTag(advert.getNewTradeInAppTag());
            orientationPackageFeatureDo.setAdvertInAppTag(advert.getAdvertInAppTag());
            orientationPackageFeatureDo.setNewTradeDayOrderRank(consumerDo.getNewTradeDayOrderRank());
            orientationPackageFeatureDo.setLastOperatingNewTrade(consumerDo.getLastOperatingNewTrade());
            orientationPackageFeatureDo.setNewTradeLastGmtCreateTime(consumerDo.getNewTradeLastGmtCreateTime());
            Optional.ofNullable(advertStatFeatureMap.get(advertId)).ifPresent(advertStatFeatureDo -> {
                orientationPackageFeatureDo.setAdvertCtr(advertStatFeatureDo.getAdvertCtr());
                orientationPackageFeatureDo.setAdvertCvr(advertStatFeatureDo.getAdvertCvr());
                orientationPackageFeatureDo.setAdvertAppCtr(advertStatFeatureDo.getAdvertAppCtr());
                orientationPackageFeatureDo.setAdvertAppCvr(advertStatFeatureDo.getAdvertAppCvr());
                orientationPackageFeatureDo.setAdvertSlotCtr(advertStatFeatureDo.getAdvertSlotCtr());
                orientationPackageFeatureDo.setAdvertSlotCvr(advertStatFeatureDo.getAdvertSlotCvr());
                orientationPackageFeatureDo.setAdvertActivityCtr(advertStatFeatureDo.getAdvertActivityCtr());
                orientationPackageFeatureDo.setAdvertActivityCvr(advertStatFeatureDo.getAdvertActivityCvr());
            });
            Set<Material> materials = orientationPackage.getMaterials();
            if (materials.isEmpty()) {
                FeatureIndex orientationPackageFeatureIndex = FeatureIndex.newBuilder().advertId(advertId).packageId(packageId).build();
                Map<String, String> dynamicMapMap = this.getDynamicMapMap(staticFeatureDo, orientationPackageFeatureDo, staticFeatureMap);
                finalFeatureMap.put(orientationPackageFeatureIndex, dynamicMapMap);
                return;
            }
            materials.forEach(materialDto -> {
                Long materialId = materialDto.getId();
                FeatureIndex orientationPackageMaterialFeatureIndex = FeatureIndex.newBuilder().advertId(advertId).packageId(packageId).materialId(materialId).build();
                FeatureDo materialFeatureDo = this.copyAdvertFeature(orientationPackageFeatureDo);
                materialFeatureDo.setMaterialId(materialId.toString());
                materialFeatureDo.setAtmosphere(materialDto.getAtmosphere());
                materialFeatureDo.setBackgroundColour(materialDto.getBackgroundColour());
                materialFeatureDo.setIfPrevalent(String.valueOf(materialDto.getPrevalent()));
                materialFeatureDo.setDescribeKeywords(materialDto.getInterception());
                materialFeatureDo.setDynamicEffect(materialDto.getCarton());
                materialFeatureDo.setBodyElement(materialDto.getBodyElement());
                materialFeatureDo.setMaterialTags(materialDto.getTags().stream().filter(Objects::nonNull).collect(Collectors.joining(",")));
                Map<String, String> dynamicMap = this.getDynamicMapMap(staticFeatureDo, materialFeatureDo, staticFeatureMap);
                finalFeatureMap.put(orientationPackageMaterialFeatureIndex, dynamicMap);
            });
        }));
        return finalFeatureMap;
    }

    private FeatureDo getFeatureDo(ConsumerDo consumerDo, AppDo appDo, ActivityDo activityDo, RequestDo requestDo) {
        try {
            DBTimeProfile.enter((String)"consumerFeatureBo.getFeatureDo");
            FeatureDo featureDo = this.consumerFeatureBo.getFeatureDo(consumerDo, appDo, activityDo, requestDo);
            return featureDo;
        }
        catch (Exception e) {
            throw new RecommendEngineException("consumerFeatureBo.getFeatureDo happened error", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private IModel getModel(ModelKeyEnum modelKey) {
        try {
            if (modelKey.getOnline().booleanValue()) {
                if (modelKey.getModelType().equals((Object)ModelType.FFM)) {
                    return (IModel)this.onlineFFMModelCache.get((Object)modelKey);
                }
                if (modelKey.getModelType().equals((Object)ModelType.CODER)) {
                    return (IModel)this.onlineCODERModelCache.get((Object)modelKey);
                }
                return (IModel)this.onlineFMModelCache.get((Object)modelKey);
            }
            return (IModel)this.offlineFMModelCache.get((Object)modelKey);
        }
        catch (Exception e) {
            this.logger.warn("get model happened error ,the model key is {} ,{}", (Object)modelKey, (Object)e);
            return null;
        }
    }

    private Optional<IModel> loadFMModel(ModelKeyEnum modelKeyEnum) {
        try {
            DBTimeProfile.enter((String)"loadFMModel");
            Optional<IModel> optional = Optional.ofNullable(modelKeyEnum).map(modelKey -> (String)this.nezhaStringRedisTemplate.opsForValue().get((Object)ModelKey.getLastModelNewKey((String)modelKey.getIndex()))).map(StringZIP::unzipString).map(json -> (FM)JSON.parseObject((String)json, FM.class));
            return optional;
        }
        catch (Exception e) {
            this.logger.error("load loadFMModel error,modelKey:{}", (Object)modelKeyEnum);
            throw new RecommendEngineException("load model exception", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Optional<IModel> loadFFMModel(ModelKeyEnum modelKeyEnum) {
        try {
            DBTimeProfile.enter((String)"loadFFMModel");
            Optional<IModel> optional = Optional.ofNullable(modelKeyEnum).map(modelKey -> (String)this.nezhaStringRedisTemplate.opsForValue().get((Object)ModelKey.getLastModelNewKey((String)modelKey.getIndex()))).map(StringZIP::unzipString).map(json -> (FFM)JSON.parseObject((String)json, FFM.class));
            return optional;
        }
        catch (Exception e) {
            this.logger.error("load loadFFMModel error,modelKey:{}", (Object)modelKeyEnum);
            throw new RecommendEngineException("load model exception", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Optional<IModel> loadCODERModel(ModelKeyEnum modelKeyEnum) {
        try {
            DBTimeProfile.enter((String)"loadCODERModel");
            Optional<IModel> optional = Optional.ofNullable(modelKeyEnum).map(modelKey -> (String)this.nezhaStringRedisTemplate.opsForValue().get((Object)ModelKey.getLastModelNewKey((String)modelKey.getIndex()))).map(StringZIP::unzipString).map(json -> (CODER)JSON.parseObject((String)json, CODER.class));
            return optional;
        }
        catch (Exception e) {
            this.logger.error("load loadCODERModel error,modelKey:{}", (Object)modelKeyEnum);
            throw new RecommendEngineException("load model exception", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private FeatureDo copyAdvertFeature(FeatureDo advertFeatureDo) {
        FeatureDo featureDo = new FeatureDo();
        featureDo.setAdvertId(advertFeatureDo.getAdvertId());
        featureDo.setAccountId(advertFeatureDo.getAccountId());
        featureDo.setMatchTagNums(advertFeatureDo.getMatchTagNums());
        featureDo.setTradeId2(advertFeatureDo.getTradeId2());
        featureDo.setAdvertTags(advertFeatureDo.getAdvertTags());
        featureDo.setTimes(advertFeatureDo.getTimes());
        featureDo.setOperatingResource(advertFeatureDo.getOperatingResource());
        featureDo.setBankEndType(advertFeatureDo.getBankEndType());
        featureDo.setAdvertCtr(advertFeatureDo.getAdvertCtr());
        featureDo.setAdvertCvr(advertFeatureDo.getAdvertCvr());
        featureDo.setAdvertAppCtr(advertFeatureDo.getAdvertAppCtr());
        featureDo.setAdvertAppCvr(advertFeatureDo.getAdvertAppCvr());
        featureDo.setAdvertSlotCtr(advertFeatureDo.getAdvertSlotCtr());
        featureDo.setAdvertSlotCvr(advertFeatureDo.getAdvertSlotCvr());
        featureDo.setAdvertActivityCtr(advertFeatureDo.getAdvertActivityCtr());
        featureDo.setAdvertActivityCvr(advertFeatureDo.getAdvertActivityCvr());
        return featureDo;
    }

    private Map<String, String> getDynamicMapMap(FeatureDo staticFeatureDo, FeatureDo advertFeatureDo, Map<String, String> staticMap) {
        Map dynamicMap = FeatureParse.generateFeatureMapDynamic((FeatureDo)advertFeatureDo, (FeatureDo)staticFeatureDo);
        dynamicMap.putAll(staticMap);
        return dynamicMap;
    }

    public void afterPropertiesSet() throws Exception {
        if ("dev".equals(this.active)) {
            return;
        }
        this.logger.info("start init predict model");
        long start = System.currentTimeMillis();
        Map<Boolean, List<ModelKeyEnum>> modelKeyMap = Arrays.stream(ModelKeyEnum.values()).collect(Collectors.partitioningBy(ModelKeyEnum::getOnline));
        for (ModelKeyEnum modelKey : modelKeyMap.get(false)) {
            try {
                this.offlineFMModelCache.get((Object)modelKey);
            }
            catch (Exception e) {
                this.logger.info("{}", (Object)modelKey);
            }
        }
        for (ModelKeyEnum modelKey : modelKeyMap.get(true)) {
            try {
                this.onlineFMModelCache.get((Object)modelKey);
            }
            catch (Exception e) {
                this.logger.info("{}", (Object)modelKey);
            }
        }
        this.logger.info("init predict model finish,spend {} ms", (Object)(System.currentTimeMillis() - start));
    }
}

