/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr.impl;

import cn.com.duiba.nezha.engine.biz.domain.AdvertBaseStatDo;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatFeatureDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertStatFeatureService;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertStatFeatureServiceImpl
implements AdvertStatFeatureService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertStatFeatureServiceImpl.class);
    private static final String ADVERT_DIM = "ADVERT";
    private static final String ADVERT_APP_DIM = "ADVERT_APP";
    private static final String ADVERT_SLOT_DIM = "ADVERT_SLOT";
    private static final String ADVERT_ACTIVITY_DIM = "ADVERT_ACTIVITY_DIM";
    @Resource
    private StringRedisTemplate nezhaStringRedisTemplate;
    private LoadingCache<String, AdvertBaseStatDo> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(3000000L).build((CacheLoader)new CacheLoader<String, AdvertBaseStatDo>(){

        public AdvertBaseStatDo load(String key) {
            throw new UnsupportedOperationException("not suppose single query");
        }

        public Map<String, AdvertBaseStatDo> loadAll(Iterable<? extends String> keys) {
            return StringRedisHelper.of((StringRedisTemplate)AdvertStatFeatureServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, AdvertBaseStatDo.class, AdvertBaseStatDo::new);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, AdvertStatFeatureDo> get(Long appId, Long slotId, Long activityId, Collection<Advert> adverts) {
        HashMap<Long, AdvertStatFeatureDo> advertId2FeatureDoMap = new HashMap<Long, AdvertStatFeatureDo>();
        try {
            DBTimeProfile.enter((String)"AdvertStatFeatureService.get");
            HashMap<Long, Map<String, String>> advertId2MultiDimKey = new HashMap<Long, Map<String, String>>(adverts.size());
            HashSet<String> allKeys = new HashSet<String>(adverts.size() * 4);
            for (Advert advert : adverts) {
                Long id = advert.getId();
                Map<String, String> multiDimKey = this.getMultiDimKey(appId, slotId, activityId, id);
                advertId2MultiDimKey.put(id, multiDimKey);
                allKeys.addAll(multiDimKey.values());
            }
            ImmutableMap keyFeatureMap = this.cache.getAll(allKeys);
            if (MapUtils.isEmpty((Map)keyFeatureMap)) {
                HashMap<Long, AdvertStatFeatureDo> hashMap = advertId2FeatureDoMap;
                return hashMap;
            }
            advertId2FeatureDoMap = new HashMap(keyFeatureMap.size());
            for (Advert advert : adverts) {
                Long id = advert.getId();
                Map multiDimKey = (Map)advertId2MultiDimKey.get(id);
                AdvertStatFeatureDo featureDo = new AdvertStatFeatureDo((AdvertBaseStatDo)keyFeatureMap.get(multiDimKey.get(ADVERT_DIM)), (AdvertBaseStatDo)keyFeatureMap.get(multiDimKey.get(ADVERT_APP_DIM)), (AdvertBaseStatDo)keyFeatureMap.get(multiDimKey.get(ADVERT_SLOT_DIM)), (AdvertBaseStatDo)keyFeatureMap.get(multiDimKey.get(ADVERT_ACTIVITY_DIM)));
                advertId2FeatureDoMap.put(id, featureDo);
            }
        }
        catch (Exception e) {
            LOGGER.error("get statistic feature error:{}", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
        return advertId2FeatureDoMap;
    }

    private Map<String, String> getMultiDimKey(Long appId, Long slotId, Long activityId, Long advertId) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(ADVERT_DIM, RedisKeyUtil.advertStatFeatureKey(null, null, null, (Long)advertId));
        map.put(ADVERT_APP_DIM, RedisKeyUtil.advertStatFeatureKey((Long)appId, null, null, (Long)advertId));
        map.put(ADVERT_SLOT_DIM, RedisKeyUtil.advertStatFeatureKey(null, null, (Long)slotId, (Long)advertId));
        map.put(ADVERT_ACTIVITY_DIM, RedisKeyUtil.advertStatFeatureKey(null, (Long)activityId, null, (Long)advertId));
        return map;
    }
}

