/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.engine.impl;

import cn.com.duiba.nezha.engine.api.dto.RecomMaterialDto;
import cn.com.duiba.nezha.engine.api.dto.ReqAdvertMaterialDto;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AdvertMaterialRcmdCtrStatEntity;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertMaterialCtrByStatService;
import cn.com.duiba.nezha.engine.biz.service.advert.engine.AdvertMaterialRecommendEngineService;
import cn.com.duiba.nezha.engine.biz.service.advert.merge.AdvertMaterialMergeService;
import cn.com.duiba.nezha.engine.biz.service.advert.rerank.AdvertMaterialReRankService;
import cn.com.duiba.nezha.engine.biz.service.advert.strategy.AdvertMaterialRcmdStrategyService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertMaterialResortGroupVo;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertMaterialResortVo;
import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertMaterialRecommendEngineServiceImpl
implements AdvertMaterialRecommendEngineService {
    private static final Logger logger = LoggerFactory.getLogger(AdvertMaterialRecommendEngineServiceImpl.class);
    private static Random random = new Random();
    @Autowired
    AdvertMaterialCtrByStatService advertMaterialCtrByStatService;
    @Autowired
    AdvertMaterialMergeService advertMaterialMergeService;
    @Autowired
    AdvertMaterialReRankService advertMaterialReRankService;
    @Autowired
    AdvertMaterialRcmdStrategyService advertMaterialRcmdStrategyService;

    @Override
    public Long recommendMaterial(ReqAdvertMaterialDto req) {
        AdvertMaterialResortVo advertMaterialResortVo;
        Long materialId = null;
        String reqId = System.currentTimeMillis() + "-" + random.nextInt(1000);
        if (!this.paramCheck(req)) {
            logger.warn("req is invalid");
            throw new RecommendEngineException("req is invalid");
        }
        List<AdvertMaterialRcmdCtrStatEntity> materialCtrEntityList = this.advertMaterialCtrByStatService.getMaterialList(req.getAppId(), req.getAdvertId(), req.getOldMaterialList(), req.getNewMaterialList());
        List<AdvertMaterialResortGroupVo> materialGroupVoList = this.advertMaterialMergeService.getMergeMaterialMap(materialCtrEntityList, req.getOldMaterialList(), req.getNewMaterialList());
        List<AdvertMaterialResortGroupVo> materialResortGroupVoList = this.advertMaterialReRankService.reRank(materialGroupVoList, req.getOldMaterialTraffic(), req.getOldMaterialRatio());
        if (logger.isDebugEnabled()) {
            logger.debug("{},materialResortGroupVoList = {}", (Object)reqId, (Object)JSON.toJSONString(materialResortGroupVoList));
        }
        if (AssertUtil.isNotEmpty((Object)(advertMaterialResortVo = this.advertMaterialRcmdStrategyService.getMaterial(materialResortGroupVoList)))) {
            materialId = advertMaterialResortVo.getMaterialId();
        }
        logger.debug("{},rsp={}", (Object)reqId, (Object)materialId);
        return materialId;
    }

    @Override
    public RecomMaterialDto newRecommendMaterial(ReqAdvertMaterialDto req) {
        AdvertMaterialResortVo advertMaterialResortVo;
        Long materialId = null;
        Long groupId = null;
        String reqId = System.currentTimeMillis() + "-" + random.nextInt(1000);
        if (!this.paramCheck(req)) {
            logger.warn("req is invalid");
            throw new RecommendEngineException("req is invalid");
        }
        List<AdvertMaterialRcmdCtrStatEntity> materialCtrEntityList = this.advertMaterialCtrByStatService.getMaterialList(req.getAppId(), req.getAdvertId(), req.getOldMaterialList(), req.getNewMaterialList());
        List<AdvertMaterialResortGroupVo> materialGroupVoList = this.advertMaterialMergeService.getMergeMaterialMap(materialCtrEntityList, req.getOldMaterialList(), req.getNewMaterialList());
        List<AdvertMaterialResortGroupVo> materialResortGroupVoList = this.advertMaterialReRankService.reRank(materialGroupVoList, req.getOldMaterialTraffic(), req.getOldMaterialRatio());
        if (logger.isDebugEnabled()) {
            logger.debug("{},materialResortGroupVoList = {}", (Object)reqId, (Object)JSON.toJSONString(materialResortGroupVoList));
        }
        if (AssertUtil.isNotEmpty((Object)(advertMaterialResortVo = this.advertMaterialRcmdStrategyService.getMaterial(materialResortGroupVoList)))) {
            materialId = advertMaterialResortVo.getMaterialId();
            groupId = advertMaterialResortVo.getGroupId();
        }
        logger.debug("{}, groupId= {}, materialId= {}", new Object[]{reqId, groupId, materialId});
        return new RecomMaterialDto(groupId.longValue(), materialId.longValue());
    }

    private boolean paramCheck(ReqAdvertMaterialDto req) {
        try {
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{req})) {
                logger.error(" paramCheck 0 error, req = [{}], please check the req ", (Object)req);
                return false;
            }
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{req.getAppId(), req.getAdvertId(), req.getOldMaterialRatio(), req.getOldMaterialTraffic()})) {
                logger.error(" paramCheck 1 error, req = [{}], please check the req ", (Object)req);
                return false;
            }
            if (AssertUtil.isAllEmpty((Object[])new Object[]{req.getOldMaterialList(), req.getNewMaterialList()})) {
                logger.error("paramCheck 2 error, req = [{}], please check the req ", (Object)req);
                return false;
            }
            if (req.getOldMaterialTraffic() > 100L || req.getOldMaterialRatio() > 100L) {
                logger.error("paramCheck 3 error, req = [{}], please check the req ", (Object)req);
                return false;
            }
        }
        catch (Exception e) {
            logger.error("paramCheck happened error :{}", (Throwable)e);
            return false;
        }
        return true;
    }
}

