/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.feature.impl;

import cn.com.duiba.nezha.engine.biz.domain.ConsumerFeatureDO;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ConsumerFeatureService;
import cn.com.duiba.nezha.engine.common.utils.HBaseResultCreater;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;

@Service
public class ConsumerFeatureServiceImpl
implements ConsumerFeatureService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerFeatureServiceImpl.class);
    private static final String TABLE_NAME = "consumer_order_feature";
    private static final byte[] FAMILY = "cf".getBytes();
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Long DEFAULT_ORDER_COUNT = 0L;
    private static final Map<String, List<String>> staticQueries = ImmutableMap.of((Object)"cf", (Object)Lists.newArrayList((Object[])new String[]{"order_cnt", "first_order_time", "last_order_id", "last_order_time", "is_billing", "last_activity_id"}));
    @Autowired
    private HbaseTemplate hbaseTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ConsumerFeatureDO> getFeatures(List<String> rowKeys) {
        List keys = rowKeys.stream().distinct().collect(Collectors.toList());
        HashMap<String, ConsumerFeatureDO> record = new HashMap<String, ConsumerFeatureDO>(keys.size());
        try {
            DBTimeProfile.enter((String)"ConsumerFeatureService.getFeatures");
            Map map = (Map)this.hbaseTemplate.execute(TABLE_NAME, table -> {
                byte[] currentDayColumnName = LocalDate.now().format(DATE_TIME_FORMATTER).getBytes();
                List gets = keys.stream().map(rowKey -> {
                    Get get = new Get(rowKey.getBytes());
                    for (Map.Entry<String, List<String>> entry : staticQueries.entrySet()) {
                        byte[] family = entry.getKey().getBytes();
                        List<String> qualifiers = entry.getValue();
                        for (String qualifier : qualifiers) {
                            get.addColumn(family, qualifier.getBytes());
                        }
                    }
                    get.addColumn(FAMILY, currentDayColumnName);
                    return get;
                }).collect(Collectors.toList());
                DBTimeProfile.enter((String)"getFeaturesFromHBase");
                Result[] results = table.get(gets);
                DBTimeProfile.release();
                for (int i = 0; i < results.length; ++i) {
                    Result result = results[i];
                    String rowKey2 = (String)keys.get(i);
                    HBaseResultCreater.of((Result)result, ConsumerFeatureDO.class).build().ifPresent(feature -> {
                        Long currentDayOrderCount = Optional.ofNullable(this.getValue(result, FAMILY, currentDayColumnName)).orElse(DEFAULT_ORDER_COUNT);
                        feature.setCurrentDayOrderCount(currentDayOrderCount);
                        record.put(rowKey2, (ConsumerFeatureDO)feature);
                    });
                }
                return record;
            });
            return map;
        }
        catch (Exception e) {
            LOGGER.error("query consumer feature error:{} ", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
        return record;
    }

    private Long getValue(Result result, byte[] family, byte[] column) {
        if (result == null) {
            return null;
        }
        byte[] value = result.getValue(family, column);
        if (value == null || value.length == 0) {
            return null;
        }
        return Bytes.toLong((byte[])value);
    }
}

