/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.merge;

import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceControl;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceResult;
import cn.com.duiba.nezha.alg.common.model.pacing.AutoMatchInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.CtrInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.CvrInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.Pacing;
import cn.com.duiba.nezha.alg.common.model.pacing.StatInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.TimeInfo;
import cn.com.duiba.nezha.alg.common.model.qscore.Qscore;
import cn.com.duiba.nezha.alg.common.model.qscore.QualityInfo;
import cn.com.duiba.nezha.engine.api.enums.ChargeTypeEnum;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.FeatureIndex;
import cn.com.duiba.nezha.engine.biz.domain.FloorPriceFeatureIndex;
import cn.com.duiba.nezha.engine.biz.domain.RequestDo;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.domain.advert.StatisticDataGetter;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AdvertStatisticMergeEntity;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.DataHandleBo;
import cn.com.duiba.nezha.engine.biz.service.advert.TrusteeshipRecommendService;
import cn.com.duiba.nezha.engine.biz.service.advert.floorprice.FloorPriceService;
import cn.com.duiba.nezha.engine.biz.service.advert.support.AdvertSupportService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertStatDimWeightVo;
import cn.com.duiba.nezha.engine.biz.vo.advert.PacingResult;
import cn.com.duiba.nezha.engine.common.utils.FormatUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.collect.Sets;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertDataMergeService
extends CacheService {
    private static final Logger logger = LoggerFactory.getLogger(AdvertDataMergeService.class);
    private static final Integer SYSTEM_MANAGED = 2;
    @Autowired
    private DataHandleBo dataHandleBo;
    @Autowired
    private AdvertSupportService advertSupportService;
    @Autowired
    private TrusteeshipRecommendService trusteeshipRecommendService;
    @Autowired
    private FloorPriceService floorPriceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OrientationPackage> dataMerge(AdvertRecommendRequestVo advertRecommendRequestVo) {
        try {
            Set<OrientationPackage> orientationPackages = advertRecommendRequestVo.getAdvertOrientationPackages();
            DBTimeProfile.enter((String)("dataMerge: " + orientationPackages.size()));
            orientationPackages = this.trusteeshipRecommendService.recommend(orientationPackages, advertRecommendRequestVo);
            AppDo appDo = advertRecommendRequestVo.getAppDo();
            Long slotId = appDo.getSlotId();
            this.advertSupportService.support(orientationPackages, slotId);
            advertRecommendRequestVo.setAdvertOrientationPackages(orientationPackages);
            this.dataHandleBo.handleSmartShopData(orientationPackages);
            Long appId = appDo.getId();
            Long activityId = advertRecommendRequestVo.getActivityDo().getOperatingId();
            this.dataHandleBo.handleSmartShopWhiteBlackData(orientationPackages, appId, slotId, activityId);
            Map<Long, Advert> advertMap = advertRecommendRequestVo.getAdvertMap();
            AdvertStatDimWeightVo advertStatDimWeightVo = advertRecommendRequestVo.getAdvertStatDimWeightVo();
            double statCtrWeight = advertStatDimWeightVo.getStatCtrWeight();
            double preCtrWeight = advertStatDimWeightVo.getPreCtrWeight();
            double statCvrWeight = advertStatDimWeightVo.getStatCvrWeight();
            double preCvrWeight = advertStatDimWeightVo.getPreCvrWeight();
            Map<FeatureIndex, Double> predictCtr = advertRecommendRequestVo.getPredictCtr();
            Map<FeatureIndex, Double> predictCvr = advertRecommendRequestVo.getPredictCvr();
            Map<Long, Integer> userAdvertBehaviorMap = advertRecommendRequestVo.getUserAdvertBehaviorMap();
            orientationPackages.forEach(orientationPackage -> {
                Long advertId = orientationPackage.getAdvertId();
                Advert advert = (Advert)advertMap.get(advertId);
                Long packageId = orientationPackage.getId();
                FeatureIndex featureIndex = orientationPackage.getMaterials().stream().findAny().map(material -> new FeatureIndex(advertId, packageId, material.getId())).orElse(new FeatureIndex(advertId, packageId));
                Double statCtr = orientationPackage.getStatCtr();
                Double preCtr = predictCtr.getOrDefault(featureIndex, 0.0);
                Double ctr = this.getAdvertCtr(statCtr, statCtrWeight, preCtr, preCtrWeight, advert.isNew());
                Double statCvr = orientationPackage.getStatCvr();
                Double preCvr = predictCvr.getOrDefault(featureIndex, 0.0);
                Double cvr = this.getAdvertCvr(statCvr, statCvrWeight, preCvr, preCvrWeight, advert.isNew());
                Long clickFee = orientationPackage.getClickFee();
                Long convertCost = orientationPackage.getConvertCost();
                Double factor = orientationPackage.getAdjustPriceFactor();
                if (orientationPackage.getFeeWeightFactor() != null) {
                    factor = factor * orientationPackage.getFeeWeightFactor();
                }
                Long finalFee = this.calculateFinalFee(orientationPackage.isCpa(), factor, cvr, clickFee, convertCost);
                orientationPackage.setCtr(ctr);
                orientationPackage.setCvr(cvr);
                orientationPackage.setPreCtr(preCtr);
                orientationPackage.setPreCvr(preCvr);
                orientationPackage.setFinalFee(finalFee);
                orientationPackage.setUserBehavior(userAdvertBehaviorMap.getOrDefault(advertId, 0));
                PacingResult pacing = this.pacing(advert, (OrientationPackage)orientationPackage);
                orientationPackage.setGiveUp(pacing.getGiveUp());
                orientationPackage.setFlowTag(pacing.getTag());
            });
            Set<OrientationPackage> giveUpRescurePackage = this.trusteeshipRecommendService.giveUpRescurePackage(orientationPackages);
            orientationPackages.removeAll(giveUpRescurePackage);
            Set<OrientationPackage> floorPriceGiveUpSet = this.floorPriceGiveUp(advertRecommendRequestVo, orientationPackages);
            orientationPackages.removeAll(floorPriceGiveUpSet);
            Map<Long, Double> ctrReconstructionFactorMap = advertRecommendRequestVo.getCtrReconstructionFactorMap();
            Map<Long, Double> cvrReconstructionFactorMap = advertRecommendRequestVo.getCvrReconstructionFactorMap();
            Boolean advertMultiDimScoreEffective = advertRecommendRequestVo.getAdvertMultiDimScoreEffective();
            DBTimeProfile.enter((String)"calculate rankScore");
            List<OrientationPackage> list = orientationPackages.stream().peek(orientationPackage -> {
                Long advertId = orientationPackage.getAdvertId();
                Integer chargeType = orientationPackage.getChargeType();
                Advert advert = (Advert)advertMap.get(advertId);
                Double ctr = orientationPackage.getCtr();
                Double cvr = orientationPackage.getCvr();
                Long finalFee = orientationPackage.getFinalFee();
                Double tagWeight = advert.getWeight();
                Double discountRate = advert.getDiscountRate();
                Double ctrReconstructionFactor = ctrReconstructionFactorMap.getOrDefault(advertId, 1.0);
                Double cvrReconstructionFactor = cvrReconstructionFactorMap.getOrDefault(advertId, 1.0);
                double qScore = this.getScore(finalFee, chargeType, ctr, cvr, advertMultiDimScoreEffective);
                double rankScore = this.getRankScore(ctrReconstructionFactor, cvrReconstructionFactor, finalFee, tagWeight, qScore, discountRate);
                Double supportWeight = orientationPackage.getSupportWeight();
                orientationPackage.setSupportWeight(supportWeight);
                orientationPackage.setSupportSuccess(!supportWeight.equals(1.0));
                orientationPackage.setqScore(qScore);
                orientationPackage.setRankScore(rankScore *= supportWeight.doubleValue());
            }).collect(Collectors.toList());
            return list;
        }
        finally {
            DBTimeProfile.release();
            DBTimeProfile.release();
        }
    }

    public Set<OrientationPackage> floorPriceGiveUp(AdvertRecommendRequestVo advertRecommendRequestVo, Set<OrientationPackage> orientationPackages) {
        Set<Object> resultGiveUpSet = Sets.newHashSet();
        try {
            List<OrientationPackage> packages;
            RequestDo requestDo = advertRecommendRequestVo.getRequestDo();
            AppDo appDo = advertRecommendRequestVo.getAppDo();
            Boolean floorPriceWhiteListOff = requestDo.getFloorPriceWhiteListOff();
            List<OrientationPackage> floorPricePackages = packages = orientationPackages.stream().filter(orientationPackage -> ChargeTypeEnum.CPA.getValue().equals(orientationPackage.getChargeType())).filter(orientationPackage -> SYSTEM_MANAGED.equals(orientationPackage.getPackageType())).collect(Collectors.toList());
            if (floorPriceWhiteListOff.booleanValue()) {
                floorPricePackages = packages.stream().filter(OrientationPackage::getFloorPriceWhilteAdvert).collect(Collectors.toList());
            }
            if (CollectionUtil.isEmpty(floorPricePackages)) {
                return resultGiveUpSet;
            }
            Map<FloorPriceFeatureIndex, Long> finalFeeMap = floorPricePackages.stream().collect(Collectors.toMap(orientationPackage -> FloorPriceFeatureIndex.conver(orientationPackage, appDo), OrientationPackage::getFinalFee));
            Map<OrientationPackage, FloorPriceFeatureIndex> indexOrientationPackageMap = floorPricePackages.stream().collect(Collectors.toMap(Function.identity(), orientationPackage -> FloorPriceFeatureIndex.conver(orientationPackage, appDo)));
            Map<FloorPriceFeatureIndex, BasePriceResult> basePriceResultMap = this.floorPriceService.getFloorPriceFactor(appDo, floorPricePackages);
            this.setGiveUpProbsToLog(orientationPackages, indexOrientationPackageMap, basePriceResultMap);
            Integer biddingAdvertNum = orientationPackages.size();
            Map giveUpControl = BasePriceControl.giveUpControl(basePriceResultMap, finalFeeMap, (Integer)biddingAdvertNum);
            if (MapUtil.isNullOrEmpty((Map)giveUpControl)) {
                return resultGiveUpSet;
            }
            resultGiveUpSet = orientationPackages.stream().filter(orientationPackage -> {
                FloorPriceFeatureIndex floorPriceFeatureIndex = (FloorPriceFeatureIndex)indexOrientationPackageMap.get(orientationPackage);
                if (floorPriceFeatureIndex != null) {
                    return giveUpControl.getOrDefault(floorPriceFeatureIndex, false);
                }
                return false;
            }).collect(Collectors.toSet());
        }
        catch (Exception e) {
            logger.warn("floorPrice giveUp error!", (Throwable)e);
        }
        return resultGiveUpSet;
    }

    private void setGiveUpProbsToLog(Set<OrientationPackage> orientationPackages, Map<OrientationPackage, FloorPriceFeatureIndex> indexOrientationPackageMap, Map<FloorPriceFeatureIndex, BasePriceResult> basePriceResultMap) {
        orientationPackages.forEach(orientationPackage -> {
            BasePriceResult result;
            FloorPriceFeatureIndex floorPriceFeatureIndex = (FloorPriceFeatureIndex)indexOrientationPackageMap.get(orientationPackage);
            if (floorPriceFeatureIndex != null && (result = (BasePriceResult)basePriceResultMap.get(floorPriceFeatureIndex)) != null) {
                orientationPackage.setGiveUpProb5(result.getGiveUpProb5());
                orientationPackage.setGiveUpProb10(result.getGiveUpProb10());
            }
        });
    }

    private Long calculateFinalFee(Boolean cpa, Double factor, double cvr, Long clickFee, Long convertCost) {
        if (!cpa.booleanValue()) {
            return clickFee;
        }
        Long finalFee = Math.round((double)convertCost.longValue() * cvr * factor);
        if (finalFee.equals(0L)) {
            finalFee = 1L;
        }
        return finalFee;
    }

    private double getRankScore(double ctrReconstructionFactor, double cvrReconstructionFactor, Long fee, double tagWeight, double qScore, double discountRate) {
        return (double)fee.longValue() * qScore * tagWeight * discountRate * ctrReconstructionFactor * cvrReconstructionFactor;
    }

    private PacingResult pacing(Advert advert, OrientationPackage orientationPackage) {
        try {
            Integer cvrType = orientationPackage.getCvrType();
            TimeInfo timeInfo = new TimeInfo();
            timeInfo.setHourBudgetFee(orientationPackage.getHourlyBudgetFees());
            timeInfo.setHourBudgetExp(orientationPackage.getHourlyBudgetCounts());
            timeInfo.setPackageBudget(Optional.ofNullable(orientationPackage.getBudget()).map(Long::doubleValue).orElse(-1.0));
            timeInfo.setHourCtr(orientationPackage.getHourlyCtr());
            timeInfo.setHourCvr(orientationPackage.getHourlyCvr());
            timeInfo.setHourClk(orientationPackage.getHourlyClick());
            timeInfo.setHourExp(orientationPackage.getHourlyLaunch());
            timeInfo.setHourFee(orientationPackage.getHourlyConsume());
            StatInfo adCtrStatInfo = this.convert(advert, StatisticData::getCtr);
            StatInfo adCvrStatInfo = this.convert(advert, statisticData -> statisticData.getCvr(cvrType));
            StatInfo adClickStatInfo = this.convert(advert, statisticData -> statisticData.getChargeClickCount().doubleValue());
            StatInfo pkgCtrStatInfo = this.convert(orientationPackage, StatisticData::getCtr);
            StatInfo pkgCvrStatInfo = this.convert(orientationPackage, statisticData -> statisticData.getCvr(cvrType));
            StatInfo pkgClickStatInfo = this.convert(orientationPackage, statisticData -> statisticData.getChargeClickCount().doubleValue());
            AdvertStatisticMergeEntity tagStatisticData = orientationPackage.getTagStatisticData();
            StatInfo tagCvrStatInfo = this.getStatInfo(tagStatisticData);
            CtrInfo ctrInfo = new CtrInfo();
            ctrInfo.setCtr(orientationPackage.getCtr());
            ctrInfo.setAdCtrInfo(adCtrStatInfo);
            ctrInfo.setOrientCtrInfo(pkgCtrStatInfo);
            CvrInfo cvrInfo = new CvrInfo();
            cvrInfo.setCvr(orientationPackage.getCvr());
            cvrInfo.setAdCvrInfo(adCvrStatInfo);
            cvrInfo.setOrientCvrInfo(pkgCvrStatInfo);
            cvrInfo.setCompeterCvrInfo(tagCvrStatInfo);
            OrientInfo orientInfo = new OrientInfo();
            orientInfo.setAdvertId(advert.getId());
            orientInfo.setOrientId(orientationPackage.getId());
            orientInfo.setManagered(orientationPackage.isWeakTarget().booleanValue());
            orientInfo.setChargeType(orientationPackage.getChargeType());
            orientInfo.setTarget(orientationPackage.getConvertCost());
            orientInfo.setFee(orientationPackage.getFinalFee());
            orientInfo.setFactor(orientationPackage.getAdjustPriceFactor());
            orientInfo.setQuailityLevel(orientationPackage.getQualityLevel().intValue());
            OrientInfo.Type type = new OrientInfo.Type(orientInfo);
            type.setChargeType(orientationPackage.getChargeType());
            int pid = 0;
            if (orientationPackage.getSmartShop().booleanValue()) {
                pid |= 4;
            }
            type.setPid(Integer.valueOf(pid));
            type.setPackageType(orientationPackage.getUserBehavior());
            orientInfo.setType(type);
            AutoMatchInfo autoMatchInfo = new AutoMatchInfo();
            Optional<StatisticData> optionalStatDo = orientationPackage.getSmartShopStatisticData();
            Long convert = optionalStatDo.map(statisticData -> statisticData.getConvertCount(cvrType)).orElse(0L);
            Long cost = optionalStatDo.map(StatisticData::getTotalConsume).orElse(0L);
            Long launch = optionalStatDo.map(StatisticData::getLaunchCount).orElse(0L);
            Long click = optionalStatDo.map(StatisticData::getChargeClickCount).orElse(0L);
            autoMatchInfo.setConvertCost(orientationPackage.getConvertCost());
            autoMatchInfo.setConvert(convert);
            autoMatchInfo.setClick(click);
            autoMatchInfo.setCost(cost);
            autoMatchInfo.setLaunch(launch);
            orientInfo.setAutoMatchInfo(autoMatchInfo);
            Optional.ofNullable(orientationPackage.getTodayStatisticData()).map(StatisticData::getTotalConsume).map(Long::doubleValue).ifPresent(arg_0 -> ((OrientInfo)orientInfo).setOrientCostG1d(arg_0));
            boolean needGiveUp = new Pacing().pacing(orientInfo, cvrInfo, ctrInfo, adClickStatInfo, pkgClickStatInfo, timeInfo);
            PacingResult pacingResult = PacingResult.newBuilder().giveUp(needGiveUp).tag(0L).build();
            Optional.ofNullable(orientInfo.getAutoMatchInfo()).map(AutoMatchInfo::getEffectLog).map(AutoMatchInfo.EffectLog::getTag).ifPresent(pacingResult::setTag);
            return pacingResult;
        }
        catch (Exception e) {
            logger.warn("pacing error:{}", (Throwable)e);
            return PacingResult.DEFAULT;
        }
    }

    private StatInfo convert(StatisticDataGetter statisticDataGetter, Function<StatisticData, Double> function) {
        StatInfo statInfo = new StatInfo();
        statInfo.setApp1d(function.apply(statisticDataGetter.getTodayAppStatisticData()));
        statInfo.setApp1h(function.apply(statisticDataGetter.getHourAppStatisticData()));
        statInfo.setApp7d(function.apply(statisticDataGetter.getRecently7DayAppStatisticData()));
        statInfo.setG1d(function.apply(statisticDataGetter.getTodayStatisticData()));
        statInfo.setG1h(function.apply(statisticDataGetter.getHourStatisticData()));
        statInfo.setG7d(function.apply(statisticDataGetter.getRecently7DayStatisticData()));
        return statInfo;
    }

    private Double getAdvertCtr(double statCtr, double statCtrWeight, double preCtr, double preCtrWeight, boolean newAddAdStatus) {
        double ret = preCtr < 1.0E-4 ? statCtr : (newAddAdStatus ? 0.5 * preCtr + 0.5 * statCtr : (statCtrWeight * statCtr + preCtrWeight * preCtr) / (statCtrWeight + preCtrWeight));
        return FormatUtil.doubleFormat((Double)ret, (int)6);
    }

    private Double getAdvertCvr(double statCvr, double statCvrWeight, double preCvr, double preCvrWeight, boolean newAddAdStatus) {
        double ret;
        if (preCvr < 1.0E-4) {
            ret = statCvr;
        } else if (newAddAdStatus) {
            ret = 0.5 * preCvr + 0.5 * statCvr;
        } else {
            ret = (statCvrWeight * statCvr + preCvrWeight * preCvr) / (statCvrWeight + preCvrWeight);
            ret = Math.min(ret, statCvr * 1.5);
        }
        return FormatUtil.doubleFormat((Double)ret, (int)6);
    }

    private double getScore(Long finalFee, Integer chargeType, Double ctr, Double cvr, Boolean advertMultiDimScoreEffective) {
        double score = ctr;
        if (!BooleanUtils.isTrue((Boolean)advertMultiDimScoreEffective)) {
            return score;
        }
        try {
            Qscore qscore = new Qscore();
            QualityInfo qualityInfo = new QualityInfo();
            qualityInfo.setType(chargeType);
            qualityInfo.setCtr(ctr);
            qualityInfo.setCvr(cvr);
            qualityInfo.setTarget(Double.valueOf(finalFee.doubleValue()));
            score = qscore.getQscore(qualityInfo);
        }
        catch (Exception e) {
            logger.warn("calculate qScore error :{}", (Throwable)e);
        }
        return score;
    }

    private StatInfo getStatInfo(AdvertStatisticMergeEntity advertStatisticMergeEntity) {
        StatInfo statInfo = new StatInfo();
        statInfo.setApp1h(advertStatisticMergeEntity.getAppCurrentlyHour());
        statInfo.setApp1d(advertStatisticMergeEntity.getAppCurrentlyDay());
        statInfo.setApp7d(advertStatisticMergeEntity.getAppRecently7Day());
        statInfo.setG1h(advertStatisticMergeEntity.getGlobalCurrentlyHour());
        statInfo.setG1d(advertStatisticMergeEntity.getGlobalCurrentlyDay());
        statInfo.setG7d(advertStatisticMergeEntity.getGlobalRecently7Day());
        return statInfo;
    }
}

