/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.strategy;

import cn.com.duiba.nezha.engine.api.enums.ResultCodeEnum;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.support.Roulette;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertMaterialResortGroupVo;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertMaterialResortVo;
import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdvertMaterialRcmdStrategyService {
    private static final Logger logger = LoggerFactory.getLogger(AdvertMaterialRcmdStrategyService.class);

    public AdvertMaterialResortVo getMaterial(List<AdvertMaterialResortGroupVo> inputVoList) {
        AdvertMaterialResortVo advertMaterialResortVo = null;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{inputVoList})) {
            logger.warn("getMaterialId param cheak invalid", (Object)ResultCodeEnum.PARAMS_INVALID.getDesc());
            return advertMaterialResortVo;
        }
        try {
            HashMap<AdvertMaterialResortGroupVo, Long> groupPollingMap = new HashMap<AdvertMaterialResortGroupVo, Long>();
            for (AdvertMaterialResortGroupVo vo : inputVoList) {
                groupPollingMap.put(vo, vo.getMaterialGroupTraffic());
            }
            AdvertMaterialResortGroupVo advertMaterialResortGroupVo = (AdvertMaterialResortGroupVo)Roulette.longMap(groupPollingMap);
            HashMap<AdvertMaterialResortVo, Double> materialPollingMap = new HashMap<AdvertMaterialResortVo, Double>();
            for (AdvertMaterialResortVo vo : advertMaterialResortGroupVo.getMaterialResortVoList()) {
                materialPollingMap.put(vo, vo.getWeight());
            }
            advertMaterialResortVo = (AdvertMaterialResortVo)Roulette.doubleMap(materialPollingMap);
            long groupId = advertMaterialResortGroupVo.getMaterialGroupId();
            advertMaterialResortVo.setGroupId(groupId);
        }
        catch (Exception e) {
            logger.error("getMaterial happened error:{}", (Throwable)e);
            throw new RecommendEngineException("getMaterial  happend error", e);
        }
        return advertMaterialResortVo;
    }
}

