/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.support;

import cn.com.duiba.nezha.engine.common.utils.AssertUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Standardize {
    private static final Logger logger = LoggerFactory.getLogger(Standardize.class);

    private Standardize() {
        throw new IllegalAccessError("Standardize class");
    }

    public static <T> Map<T, Double> mapValueIntervalStd(Map<T, Double> map, Double sMin, Double sMax) {
        ArrayList<Double> mapValueList = new ArrayList<Double>();
        HashMap<T, Double> retMap = new HashMap<T, Double>();
        if (AssertUtil.isEmpty(map) || sMin == null || sMax == null || sMin >= sMax) {
            logger.warn("mapValueIntervalStd param is invalid", (Object)"params invalid");
            return null;
        }
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            mapValueList.add(entry.getValue());
        }
        Double mapMaxValue = (Double)Collections.max(mapValueList);
        Double mapMinValue = (Double)Collections.min(mapValueList);
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            retMap.put(entry.getKey(), Standardize.dataStd(entry.getValue(), mapMinValue, mapMaxValue, sMin, sMax));
        }
        return retMap;
    }

    public static <T> Map<T, Double> mapValueNormalized(Map<T, Double> map) {
        HashMap<T, Double> retMap = new HashMap<T, Double>();
        if (map == null || map.size() == 0) {
            logger.warn("Standardize.dataStd() param check invalid");
            return null;
        }
        Double mapValueSum = 0.0;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            mapValueSum = mapValueSum + Math.max(entry.getValue(), 0.0);
        }
        if (mapValueSum > 0.0) {
            for (Map.Entry<T, Double> entry : map.entrySet()) {
                retMap.put(entry.getKey(), Math.max(entry.getValue(), 0.0) / mapValueSum);
            }
        }
        return retMap;
    }

    public static <T> Map<T, Double> mapValueLong2Double(Map<T, Long> map) {
        HashMap<T, Double> retMap = new HashMap<T, Double>();
        if (map == null || map.size() == 0) {
            logger.warn("Standardize.dataStd() param check invalid");
            return null;
        }
        for (Map.Entry<T, Long> entry : map.entrySet()) {
            Long value = entry.getValue();
            if (value == null) continue;
            retMap.put(entry.getKey(), (double)entry.getValue().longValue() + 0.0);
        }
        return retMap;
    }

    public static Double dataStd(Double x, Double xMin, Double xMax, Double sMin, Double sMax) {
        Double ret = null;
        try {
            ret = Math.abs(xMax - xMin) < 1.0E-6 ? sMax : Double.valueOf((x - xMin) * (sMax - sMin) / (xMax - xMin) + sMin);
        }
        catch (Exception e) {
            logger.error("dataStd happened error:{}", (Throwable)e);
        }
        return ret;
    }
}

