package cn.com.duiba.nezha.engine.biz.bo.advert.impl;

import cn.com.duiba.nezha.engine.api.enums.StatDataTypeEnum;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertStatAssociationBo;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatDo;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertStatService;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;

import static cn.com.duiba.nezha.engine.api.enums.StatDataTypeEnum.*;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AdvertStatAssociationBoImpl.java , v 0.1 2017/12/14 下午5:18 ZhouFeng Exp $
 */
@Service
public class AdvertStatAssociationBoImpl implements AdvertStatAssociationBo {

    private static final ImmutableMap<StatDataTypeEnum, Function<AdvertStatDo, Double>> DATA_TYPE_FUNCTION_MAP =
            ImmutableMap.of(
                    CTR, (AdvertStatDo stat) -> Optional.ofNullable(stat.getCtr()).orElse(0D),
                    CVR, (AdvertStatDo stat) -> Optional.ofNullable(stat.getCvr()).orElse(0D),
                    CLICK, (AdvertStatDo stat) -> stat.getChargeCnt().doubleValue(),
                    EXPOSURE, (AdvertStatDo stat) -> stat.getLaunchCnt().doubleValue(),
                    FEE, (AdvertStatDo stat) -> stat.getChargeFees().doubleValue()
            );


    @Autowired
    private AdvertStatService advertStatService;


    @Override
    public Map<Long, StatisticData> get7DayStat(Set<Long> appIds, Long advertId, Map<Long, Long> advertId2PkgId) {

        if (advertId2PkgId == null) {
            advertId2PkgId = Collections.emptyMap();
        }

        Set<AdvertStatService.Query> queries = new HashSet<>(appIds.size());
        Map<Long, AdvertStatService.Query> appId2QueryMap = new HashMap<>(appIds.size());
        for (Long appId : appIds) {
            AdvertStatService.Query query =  AdvertStatService.Query.newBuilder()
                    .appId(appId)
                    .advertId(advertId)
                    .packageId(advertId2PkgId.get(advertId))
                    .build();
            queries.add(query);
            appId2QueryMap.put(appId, query);
        }


        Map<AdvertStatService.Query, StatisticData> r7DayStat = advertStatService.get7DayStat(queries);

        return MapUtils.translate(appId2QueryMap, r7DayStat);

    }
}



