package cn.com.duiba.nezha.engine.biz.bo.advert;

import cn.com.duiba.nezha.alg.alg.alg.AutoBiddingAlg;
import cn.com.duiba.nezha.alg.alg.vo.AutoBiddingDo;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.AutoBiddingFactorIndex;
import cn.com.duiba.nezha.engine.biz.domain.OrientationPackageAdjustDiDO;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.HBaseResultCreater;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: AdvertAutoBiddingFactorService
 * Function: 深度优化调整因子 业务类
 * Date:     2019/4/24 0024 下午 16:40
 */
@Service
public class AdvertAutoBiddingFactorService extends CacheService {

    private static final String TABLE_NAME = "tuia_orientation_package_app_backend_adjust_di";
    private static final byte[] FAMILY = "cf".getBytes();

    @Autowired
    private HbaseTemplate hbaseTemplate;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");


    /**
     * 广告id+配置id+应用id+cvrtype+depthCvrType 的深度调价因子
     */
    private LoadingCache<AutoBiddingFactorIndex, AutoBiddingDo> autoBiddingFactorCache = CacheBuilder.newBuilder()
            .expireAfterWrite(1L, TimeUnit.MINUTES)
            .build(new CacheLoader<AutoBiddingFactorIndex, AutoBiddingDo>() {
                @Override
                public AutoBiddingDo load(AutoBiddingFactorIndex key) throws Exception {
                    return   getAllAutoBiddingFactor(Lists.newArrayList(key)).get(key);
                }

                @Override
                public Map<AutoBiddingFactorIndex, AutoBiddingDo> loadAll(Iterable<? extends AutoBiddingFactorIndex> keys) {
                    return getAllAutoBiddingFactor(keys);
                }
            });


    /**
     * 查询hbase拿到 对应的 配置数据
     *
     * @param keys
     * @return
     */
    private Map<AutoBiddingFactorIndex, AutoBiddingDo> getOrientationPackageAdjustDis(Iterable<? extends AutoBiddingFactorIndex> keys) {

        //1、构建hbase rowkey 包括 广告维度 + 广告-应用维度
        Map<Boolean, List<String>> isAdvertRowkeysMap = getRowKeys(keys);

        List<String> advertRowKeys = isAdvertRowkeysMap.get(true);
        List<String> appRowKeys = isAdvertRowkeysMap.get(false);

        List<String> allKeys = Lists.newArrayListWithCapacity(advertRowKeys.size() + appRowKeys.size());
        allKeys.addAll(advertRowKeys);
        allKeys.addAll(appRowKeys);

        // 用来接收 hbase查询出的数据
        List<OrientationPackageAdjustDiDO> advertAdjustDiDOS = Lists.newArrayListWithCapacity(advertRowKeys.size());
        List<OrientationPackageAdjustDiDO> advertAppAdjustDiDOS = Lists.newArrayListWithCapacity(appRowKeys.size());

        try {

            // 先查询出所有数据
            hbaseTemplate.execute(TABLE_NAME, table -> {
                List<Get> gets = allKeys.stream().map(rowKey -> new Get(rowKey.getBytes())).collect(Collectors.toList());
                DBTimeProfile.enter("hbaseResourceGet");
                Result[] results = table.get(gets);

                for (int i = 0; i < results.length; i++) {
                    Result result = results[i];

                    String rowKey = allKeys.get(i);
                    //将result 转成 Do
                    Optional<OrientationPackageAdjustDiDO> optionalDo = HBaseResultCreater.of(result, OrientationPackageAdjustDiDO.class).build();
                    //广告 大盘维度
                    if (advertRowKeys.contains(rowKey)) {
                        optionalDo.ifPresent(orientationPackageAdjustDiDO -> {
                            advertAdjustDiDOS.add(orientationPackageAdjustDiDO);
                        });
                    } else {
                        //广告 媒体维度
                        optionalDo.ifPresent(orientationPackageAdjustDiDO -> {
                            advertAppAdjustDiDOS.add(orientationPackageAdjustDiDO);
                        });
                    }
                }
                return null;
            });
            // 处理 映射 缓存 key -> 对应OrientationPackageAdjustDi实体
            return handleOrientationPackageAdjustDis(keys, advertAdjustDiDOS, advertAppAdjustDiDOS);

        } catch (Exception e) {
            logger.error("getOrientationPackageAdjustDis feature error:{} ", e);
        } finally {
            DBTimeProfile.release();
        }
        return Maps.newHashMap();
    }


    /**
     * @param keys
     * @param advertAdjustDiDOS    广告维度
     * @param advertAppAdjustDiDOS 广告+媒体维度
     * @return
     */
    private Map<AutoBiddingFactorIndex, AutoBiddingDo> handleOrientationPackageAdjustDis(Iterable<? extends AutoBiddingFactorIndex> keys,
                                                                                         List<OrientationPackageAdjustDiDO> advertAdjustDiDOS,
                                                                                         List<OrientationPackageAdjustDiDO> advertAppAdjustDiDOS) {
        Map<AutoBiddingFactorIndex, AutoBiddingDo> resultMap = Maps.newHashMap();
        keys.forEach(index -> {
            Long advertId = index.getAdvertId();
            Long packageId = index.getPackageId();
            Long appId = index.getAppId();
            Long cvrType = index.getCvrType();
            Long depthCvrType = index.getDepthCvrType();
            Long convertCost = index.getConvertCost();


            OrientationPackageAdjustDiDO advertAppDOKey = OrientationPackageAdjustDiDO.newBuilder().advertId(advertId).appId(appId).baseType(cvrType).secondSubType(depthCvrType).build();
            OrientationPackageAdjustDiDO advertDOKey = OrientationPackageAdjustDiDO.newBuilder().advertId(advertId).appId(0L).baseType(cvrType).secondSubType(depthCvrType).build();

            AutoBiddingDo autoBiddingDo = new AutoBiddingDo();
            autoBiddingDo.setAdvertId(advertId);
            autoBiddingDo.setPlanId(packageId);
            autoBiddingDo.setAppId(appId);
            autoBiddingDo.setBaseType(cvrType);
            autoBiddingDo.setSecondSubType(depthCvrType);
            autoBiddingDo.setaFee(convertCost);


            // 获取该广告媒体数据下标 已经重写 equls 方法
            Integer advertAppIndex = advertAppAdjustDiDOS.indexOf(advertAppDOKey);
            // 获取该广告大盘数据 下标
            Integer advertIndex = advertAdjustDiDOS.indexOf(advertDOKey);

            if (-1 != advertAppIndex) {
                OrientationPackageAdjustDiDO advertAppPackageAdjustDiDO = advertAppAdjustDiDOS.get(advertAppIndex);
                autoBiddingDo.setAdAndappBCvr(advertAppPackageAdjustDiDO.getbCvr());
                autoBiddingDo.setAdAndappBasePv(advertAppPackageAdjustDiDO.getBasePv());
            }
            if (-1 != advertIndex) {
                OrientationPackageAdjustDiDO advertPackageAdjustDiDO = advertAdjustDiDOS.get(advertIndex);
                autoBiddingDo.setAdBCvr(advertPackageAdjustDiDO.getbCvr());
                autoBiddingDo.setAdBasePv(advertPackageAdjustDiDO.getBasePv());
            }
            resultMap.put(index, autoBiddingDo);
        });

        return resultMap;
    }

    /**
     * 组装不同的 hbasekeys
     *
     * @param indexs
     * @return
     */
    private Map<Boolean, List<String>> getRowKeys(Iterable<? extends AutoBiddingFactorIndex> indexs) {
        List advertRowKeys = Lists.newArrayList();
        List appRowKeys = Lists.newArrayList();
        Map<Boolean, List<String>> isAdvertRowkeysMap = Maps.newHashMap();
        for (AutoBiddingFactorIndex index : indexs) {
            //'advertId_appId_baseType_subType' 表示广告媒体数据
            String advertAppkey = index.getAdvertId() + "_" + index.getAppId() + "_" + index.getCvrType() + "_" + index.getDepthCvrType();
            String appRowKey = DigestUtils.md5DigestAsHex(advertAppkey.getBytes()).substring(0, 4) + "-" + advertAppkey;
            appRowKeys.add(appRowKey);

            //'advertId_0_baseType_subType' 表示广告大盘数据
            String advertkey = index.getAdvertId() + "_0_" + index.getCvrType() + "_" + index.getDepthCvrType();
            String advertRowKey = DigestUtils.md5DigestAsHex(advertkey.getBytes()).substring(0, 4) + "-" + advertkey;
            advertRowKeys.add(advertRowKey);

        }
        isAdvertRowkeysMap.put(true, advertRowKeys);
        isAdvertRowkeysMap.put(false, appRowKeys);
        return isAdvertRowkeysMap;
    }

    public static void main(String[] args) {
        String advertAppkey = "38722_0_2_10";
        String appRowKey = DigestUtils.md5DigestAsHex(advertAppkey.getBytes()).substring(0, 4) + "-" + advertAppkey;
        System.out.println(appRowKey);
    }
    /**
     * 加载 深度调价系数
     *
     * @param keys
     * @return
     */
    private Map<AutoBiddingFactorIndex, AutoBiddingDo> getAllAutoBiddingFactor(Iterable<? extends AutoBiddingFactorIndex> keys) {
        try {
            //获取所有的 深度调价数据
            Map<AutoBiddingFactorIndex, AutoBiddingDo> autoBiddingDoMap =
                    CatUtils.executeInCatTransaction(() -> getOrientationPackageAdjustDis(keys),
                    "Hbase","getAllAutoBiddingFactor");
            //调用算法接口拿到缓存数据
            List<AutoBiddingDo> autoBiddingDos = AutoBiddingAlg.getFactorBatch(Lists.newArrayList(autoBiddingDoMap.values()));
            if (CollectionUtils.isNotEmpty(autoBiddingDos)) {
                // 将算法返回的结果构建为 AutoBiddingDo --> 深度调价因子
                return autoBiddingDos.stream().collect(Collectors.toMap(autoBiddingDo -> {
                    Long advertId = autoBiddingDo.getAdvertId();
                    Long appId = autoBiddingDo.getAppId();
                    Long packageId = autoBiddingDo.getPlanId();
                    Long secondSubType = autoBiddingDo.getSecondSubType();
                    Long baseType = autoBiddingDo.getBaseType();

                    AutoBiddingFactorIndex factorIndex = AutoBiddingFactorIndex.newBuilder().packageId(packageId).advertId(advertId)
                            .cvrType(baseType).depthCvrType(secondSubType).appId(appId).build();

                    return factorIndex;
                }, Function.identity()));
            }
        } catch (Throwable throwable) {
            logger.error("getAllAutoBiddingFactor happend error {}", throwable);
        }
        return Maps.newHashMap();
    }

    public void setAutoBiddingNewFee(AdvertRecommendRequestVo advertRecommendRequestVo) {
        try {
            AppDo appDo = advertRecommendRequestVo.getAppDo();
            Long appId = appDo.getId();
            //该功能只对CPA 配置 且 depthCvrType不为空生效 并且 没有手动设置过 媒体出价 eg ：重点媒体 、 分媒体。。
            Set<OrientationPackage> advertOrientationPackages = advertRecommendRequestVo.getAdvertOrientationPackages().stream()
                    .filter(OrientationPackage::isCpa)
                    .filter(dto -> dto.getDepthCvrType() != null)
                    .filter(dto -> !dto.getManuallyConvertCost())
                    .collect(Collectors.toSet());

            List<AutoBiddingFactorIndex> allIndex = Lists.newArrayListWithCapacity(advertOrientationPackages.size());

            //遍历配置 构建 广告id+配置id+应用id+cvrtype+depthCvrType 的key
            for (OrientationPackage advertOrientationPackage : advertOrientationPackages) {
                Long advertId = advertOrientationPackage.getAdvertId();
                Long packageId = advertOrientationPackage.getId();
                Integer cvrType = advertOrientationPackage.getCvrType();
                Integer depthCvrType = advertOrientationPackage.getDepthCvrType();
                Long convertCost = advertOrientationPackage.getConvertCost();

                AutoBiddingFactorIndex autoBiddingFactorIndex = AutoBiddingFactorIndex.newBuilder().advertId(advertId).packageId(packageId)
                        .appId(appId).cvrType(cvrType.longValue()).depthCvrType(depthCvrType.longValue()).convertCost(convertCost).build();
                allIndex.add(autoBiddingFactorIndex);
            }
            //获取所有配置的 深度调价系数
            Map<AutoBiddingFactorIndex, AutoBiddingDo> autoBiddingDoMap = autoBiddingFactorCache.getAll(allIndex);
            //根据 调价系数  设置新媒体 出价
            handleNewAfeeByAutoBiddingFactor(advertOrientationPackages, autoBiddingDoMap, appId);

        } catch (Exception e) {
            logger.error("setAutoBiddingFactor happened error:{}", e);
        }
    }

    /**
     * 根据 index 取出 调价系数 计算出 一个 新的媒体出价
     * @param advertOrientationPackages
     * @param autoBiddingDoMap
     * @param appId
     */
    private void handleNewAfeeByAutoBiddingFactor(Set<OrientationPackage> advertOrientationPackages, Map<AutoBiddingFactorIndex, AutoBiddingDo> autoBiddingDoMap, Long appId) {
        advertOrientationPackages.forEach(advertOrientationPackage -> {
            Long advertId = advertOrientationPackage.getAdvertId();
            Long packageId = advertOrientationPackage.getId();
            Integer cvrType = advertOrientationPackage.getCvrType();
            Integer depthCvrType = advertOrientationPackage.getDepthCvrType();
            AutoBiddingFactorIndex autoBiddingFactorIndex = AutoBiddingFactorIndex.newBuilder().advertId(advertId).packageId(packageId)
                    .appId(appId).cvrType(cvrType.longValue()).depthCvrType(depthCvrType.longValue()).build();

            AutoBiddingDo autoBiddingDo = autoBiddingDoMap.get(autoBiddingFactorIndex);

            if (autoBiddingDo != null) {
                Double autoBiddingFactor = Optional.ofNullable(autoBiddingDo.getAppAfeeFactor()).orElse(1.0D);

                Long oldConvertCost = advertOrientationPackage.getConvertCost();
                // 运算取整
                Long newConvertCost =  BigDecimal.valueOf(oldConvertCost * autoBiddingFactor).longValue();
                advertOrientationPackage.setConvertCost(newConvertCost);
                advertOrientationPackage.setAutoBiddingFactor(autoBiddingFactor);
                advertOrientationPackage.setControlWeight(autoBiddingDo.getControlWeight());
            }
        });
    }

}
