package cn.com.duiba.nezha.engine.biz.domain;

import java.util.Objects;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: AutoBiddingIndex
 * Function: 深度优化 索引
 * Date:     2019/4/24 0024 下午 16:12
 */
public class AutoBiddingFactorIndex {

    /**
     * 广告
     */
    private Long advertId;


    /**
     * 配置ID
     */
    private Long packageId;


    /**
     * 媒体ID
     */
    private Long appId;


    /**
     * 投放目标类型
     */
    private Long cvrType;

    /**
     * 辅助目标类型
     */
    private Long depthCvrType;

    /**
     *    转化成本
     */
    private Long convertCost;

    private AutoBiddingFactorIndex(Builder builder) {
        setAdvertId(builder.advertId);
        setPackageId(builder.packageId);
        setAppId(builder.appId);
        setCvrType(builder.cvrType);
        setDepthCvrType(builder.depthCvrType);
        setConvertCost(builder.convertCost);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(AutoBiddingFactorIndex copy) {
        Builder builder = new Builder();
        builder.advertId = copy.getAdvertId();
        builder.packageId = copy.getPackageId();
        builder.appId = copy.getAppId();
        builder.cvrType = copy.getCvrType();
        builder.depthCvrType = copy.getDepthCvrType();
        builder.convertCost = copy.getConvertCost();
        return builder;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getCvrType() {
        return cvrType;
    }

    public void setCvrType(Long cvrType) {
        this.cvrType = cvrType;
    }

    public Long getDepthCvrType() {
        return depthCvrType;
    }

    public void setDepthCvrType(Long depthCvrType) {
        this.depthCvrType = depthCvrType;
    }

    public Long getConvertCost() {
        return convertCost;
    }

    public void setConvertCost(Long convertCost) {
        this.convertCost = convertCost;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutoBiddingFactorIndex)) {
            return false;
        }
        AutoBiddingFactorIndex that = (AutoBiddingFactorIndex) o;
        return Objects.equals(getAdvertId(), that.getAdvertId()) &&
                Objects.equals(getPackageId(), that.getPackageId()) &&
                Objects.equals(getAppId(), that.getAppId()) &&
                Objects.equals(getCvrType(), that.getCvrType()) &&
                Objects.equals(getDepthCvrType(), that.getDepthCvrType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getAdvertId(), getPackageId(), getAppId(), getCvrType(), getDepthCvrType());
    }


    public static final class Builder {
        private Long advertId;
        private Long packageId;
        private Long appId;
        private Long cvrType;
        private Long depthCvrType;
        private Long convertCost;

        private Builder() {
        }

        public Builder advertId(Long val) {
            advertId = val;
            return this;
        }

        public Builder packageId(Long val) {
            packageId = val;
            return this;
        }

        public Builder appId(Long val) {
            appId = val;
            return this;
        }

        public Builder cvrType(Long val) {
            cvrType = val;
            return this;
        }

        public Builder depthCvrType(Long val) {
            depthCvrType = val;
            return this;
        }

        public Builder convertCost(Long val) {
            convertCost = val;
            return this;
        }

        public AutoBiddingFactorIndex build() {
            return new AutoBiddingFactorIndex(this);
        }
    }

    @Override
    public String toString() {
        return "AutoBiddingFactorIndex{" +
                "advertId=" + advertId +
                ", packageId=" + packageId +
                ", appId=" + appId +
                ", cvrType=" + cvrType +
                ", depthCvrType=" + depthCvrType +
                ", convertCost=" + convertCost +
                '}';
    }
}
