package cn.com.duiba.nezha.engine.biz.service.advert;

import bsh.util.JConsole;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.engine.api.enums.PredictCorrectType;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertAutoBiddingFactorService;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertBudgetSmoothService;
import cn.com.duiba.nezha.engine.biz.constant.GlobalConstant;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerDo;
import cn.com.duiba.nezha.engine.biz.domain.CorrectResult;
import cn.com.duiba.nezha.engine.biz.domain.FeatureIndex;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.advert.Material;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.enums.RecommendMaterialType;
import cn.com.duiba.nezha.engine.biz.remoteservice.impl.advert.RemoteAdvertRecommendServiceImpl;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertPredictCorrectService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertPredictService;
import cn.com.duiba.nezha.engine.biz.service.advert.material.AdvertMaterialService;
import cn.com.duiba.nezha.engine.biz.service.advert.merge.AdvertDataMergeService;
import cn.com.duiba.nezha.engine.biz.service.advert.rerank.AdvertReRankService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;

import static cn.com.duiba.nezha.alg.model.enums.PredictResultType.CTR;
import static cn.com.duiba.nezha.alg.model.enums.PredictResultType.CVR;
import static java.util.stream.Collectors.toMap;
import static java.util.stream.Collectors.toSet;

public abstract class AbstractAdvertRecommendService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAdvertRecommendService.class);
    @Resource
    private AdvertReRankService advertReRankService;

    @Resource
    private AdvertDataMergeService advertDataMergeService;

    @Autowired
    private AdvertMaterialService advertMaterialService;

    @Autowired
    private AdvertPredictCorrectService advertPredictCorrectService;

    @Autowired
    private AdvertPredictService advertPredictService;

    @Autowired
    private AdvertBudgetSmoothService advertBudgetSmoothService;
    @Autowired
    private AdvertAutoBiddingFactorService advertAutoBiddingFactorService;


    /**
     * 准备策略参数
     */
    public abstract void prepareStrategyParameter(AdvertRecommendRequestVo advertRecommendRequestVo);


    public List<OrientationPackage> recommend(AdvertRecommendRequestVo advertRecommendRequestVo) throws Throwable {

        Map<Long, Advert> advertMap = advertRecommendRequestVo.getAdvertMap();
        Collection<Advert> adverts = advertMap.values();

        Long appId = advertRecommendRequestVo.getAppDo().getId();

        Integer adxLoadType = advertRecommendRequestVo.getRequestDo().getAdxLoadType();

        // 如果需要预估
        Map<PredictResultType, Map<FeatureIndex, Double>> predictValueMap = new HashMap<>();
        if (advertRecommendRequestVo.getNeedPredict()) {

            // 需要预估cvr的广告
            Set<Advert> needPredictCvrAdverts = adverts.stream().filter(Advert::hasCvrData).collect(toSet());

            // 预估类型对应的广告列表
            Map<PredictResultType, Collection<Advert>> needPredictAdvertMap = new HashMap<>();
            needPredictAdvertMap.put(CTR, adverts);
            needPredictAdvertMap.put(CVR, needPredictCvrAdverts);

            // 进行预估  获取广告+配置 或 广告+配置+素材的预估CTR和CVR
            predictValueMap = advertPredictService.predict(advertRecommendRequestVo, needPredictAdvertMap);

            // 获取预估ctr
            Map<FeatureIndex, Double> predictCtrMap = predictValueMap.get(CTR);
            Map<FeatureIndex, Double> predictCvrMap = predictValueMap.get(CVR);
            advertRecommendRequestVo.setPredictCtr(predictCtrMap);
            advertRecommendRequestVo.setPredictCvr(predictCvrMap);

        }
        CatUtils.executeInCatTransaction(() -> {
            //预算平滑 就是为了 放弃一部分配置
            advertBudgetSmoothService.getNewBudgetSmooth(appId, advertRecommendRequestVo.getAdvertOrientationPackages(),adxLoadType);
            return null;
        },"recommend", "advertBudgetSmoothService#getNewBudgetSmooth");


        // 进行素材选择(只选择一个)
        RecommendMaterialType recommendMaterialType = advertRecommendRequestVo.getRecommendMaterialType();
        Map<FeatureIndex, Double> predictCtrMap = predictValueMap.getOrDefault(CTR, new HashMap<>());
        Map<FeatureIndex, Double> predictCvrMap = predictValueMap.getOrDefault(CVR, new HashMap<>());
        CatUtils.executeInCatTransaction(() -> {
            this.handleTestMaterial(adverts, appId, recommendMaterialType, predictCtrMap, predictCvrMap);
            return null;
        },"recommend", "abstractAdvertRecommendService#handleTestMaterial");

        // 进行纠偏和重构
        PredictCorrectType predictCorrectType = advertRecommendRequestVo.getPredictCorrectType();
        if (!predictCorrectType.equals(PredictCorrectType.NONE)
                && recommendMaterialType.equals(RecommendMaterialType.NONE)) {
            // 纠偏
            CorrectResult correctResult = advertPredictCorrectService.correct(advertRecommendRequestVo, predictValueMap);

            Map<PredictResultType, Map<Long, Double>> reconstructionFactorMap = correctResult.getReconstructionFactorMap();
            Map<PredictResultType, Map<Long, Double>> correctionFactorMap = correctResult.getCorrectionFactorMap();

            // CTR 重构系数
            Map<Long, Double> ctrReconstructionFactorMap = reconstructionFactorMap.getOrDefault(CTR, new HashMap<>());
            Map<Long, Double> ctrCorrectionFactorMap = correctionFactorMap.getOrDefault(CTR, new HashMap<>());

            // CVR 重构系数
            Map<Long, Double> cvrReconstructionFactorMap = reconstructionFactorMap.getOrDefault(CVR, new HashMap<>());
            Map<Long, Double> cvrCorrectionFactorMap = correctionFactorMap.getOrDefault(CVR, new HashMap<>());

            advertRecommendRequestVo.setCtrReconstructionFactorMap(ctrReconstructionFactorMap);
            advertRecommendRequestVo.setCvrReconstructionFactorMap(cvrReconstructionFactorMap);
            advertRecommendRequestVo.setCtrCorrectionFactorMap(ctrCorrectionFactorMap);
            advertRecommendRequestVo.setCvrCorrectionFactorMap(cvrCorrectionFactorMap);
        }

        // 设置用户行为
        ConsumerDo consumerDo = advertRecommendRequestVo.getConsumerDo();
        Map<Long, Integer> userAdvertBehaviorMap = this.userAdvertBehavior(adverts, consumerDo);
        advertRecommendRequestVo.setUserAdvertBehaviorMap(userAdvertBehaviorMap);

        CatUtils.executeInCatTransaction(() -> {
            // 为每个配置 设置 深度优化 新的 媒体出价
            advertAutoBiddingFactorService.setAutoBiddingNewFee(advertRecommendRequestVo);
            return null;
        },"recommend", "advertAutoBiddingFactorService#setAutoBiddingNewFee");


        // 数据融合
        List<OrientationPackage> orientationPackages = CatUtils.executeInCatTransaction(() -> advertDataMergeService.dataMerge(advertRecommendRequestVo),"recommend", "advertDataMergeService#dataMerge");
        // 排序
        return CatUtils.executeInCatTransaction(() -> advertReRankService.newReRank(orientationPackages, appId),"recommend", "advertReRankService#reRank");


    }


    /**
     * 处理试投素材
     * 对于配置包进行素材筛选
     * 如果广告命中了试投素材.
     * 则投放试投素材
     *
     * @param adverts               广告列表
     * @param appId                 媒体id
     * @param recommendMaterialType 素材推荐类型
     * @param predictCtrMap         ctr预估
     * @param predictCvrMap         cvr预估
     */
    public void handleTestMaterial(Collection<Advert> adverts,
                                   Long appId,
                                   RecommendMaterialType recommendMaterialType,
                                   Map<FeatureIndex, Double> predictCtrMap,
                                   Map<FeatureIndex, Double> predictCvrMap) {

        // 如果不进行素材推荐.则直接返回
        if (recommendMaterialType.equals(RecommendMaterialType.NONE)) {
            return;
        }

        Set<Long> advertIds = adverts.stream().map(Advert::getId).collect(toSet());
        Map<Long, List<Long>> materialRankList = new HashMap<>();
        if (recommendMaterialType.equals(RecommendMaterialType.STATIC)) {
            materialRankList.putAll(advertMaterialService.getMaterialRankList(appId, advertIds));
        }
        adverts.stream()
                .map(Advert::getOrientationPackages)
                .flatMap(Collection::stream)
                .forEach(orientationPackage -> {
                    Long advertId = orientationPackage.getAdvertId();
                    Long packageId = orientationPackage.getId();

                    // 如果是素材优选,则只选一个素材
                    if (recommendMaterialType.equals(RecommendMaterialType.STATIC)) {
                        orientationPackage.setMaterials(this.selectMaterial(orientationPackage, materialRankList));
                    } else {
                        // 如果是素材改造,则根据ctr,和cvr来选取一个素材
                        Boolean cpa = orientationPackage.isCpa();
                        Set<Material> bestMaterial = orientationPackage.getMaterials()
                                .stream()
                                .max(Comparator.comparing(material -> {
                                    Long materialId = material.getId();
                                    FeatureIndex featureIndex = new FeatureIndex(advertId, packageId, materialId);
                                    Double ctrValue = predictCtrMap.getOrDefault(featureIndex, 0D);
                                    Double cvrValue = predictCvrMap.getOrDefault(featureIndex, 0D);
                                    if (cpa) {
                                        return ctrValue * cvrValue;
                                    } else {
                                        return ctrValue;
                                    }
                                }))
                                .map(Collections::singleton)
                                .orElseGet(HashSet::new);
                        orientationPackage.setMaterials(bestMaterial);
                    }
                });
    }

    /**
     * 为配置包选取一个素材
     *
     * @param orientationPackage 配置包
     * @param materialRankList   广告对应的素材列表
     * @return 单个素材的集合(可能为kong)
     */
    private Set<Material> selectMaterial(OrientationPackage orientationPackage, Map<Long, List<Long>> materialRankList) {
        Set<Material> materials = orientationPackage.getMaterials();

        if (materials.isEmpty()) {
            return new HashSet<>();
        }

        List<Long> materialIds = materialRankList.get(orientationPackage.getAdvertId());
        // 从推荐的素材列表中获取一个素材.如果没有.则从请求列表中随机选取一个

        Map<Long, Material> collect = materials.stream().collect(toMap(Material::getId, Function.identity()));
        Set<Long> requestMaterials = collect.keySet();
        Material finalMaterial = materialIds
                .stream()
                .filter(requestMaterials::contains)
                .findAny()
                .map(collect::get)
                .orElse(new ArrayList<>(materials).get(new Random().nextInt(materials.size())));
        return Collections.singleton(finalMaterial);
    }


    private Map<Long, Integer> userAdvertBehavior(Collection<Advert> adverts, ConsumerDo consumerDo) {

        Map<Long, Integer> advertBehaviorMap = new HashMap<>(adverts.size());

        String clickInterestedTags = consumerDo.getClickInterestedTags();
        String clickUninterestedTags = consumerDo.getClickUninterestedTags();
        String convertInterestedTags = consumerDo.getConvertInterestedTags();
        String convertUninterestedTags = consumerDo.getConvertUninterestedTags();

        Splitter splitter = GlobalConstant.SPLITTER;

        Set<String> clickInterestedTagSet = StringUtils.isEmpty(clickInterestedTags) ? Collections.emptySet() :
                new HashSet<>(splitter.splitToList(clickInterestedTags));
        Set<String> clickUninterestedTagSet = StringUtils.isEmpty(clickUninterestedTags) ? Collections.emptySet() :
                new HashSet<>(splitter.splitToList(clickUninterestedTags));
        Set<String> convertInterestedTagSet = StringUtils.isEmpty(convertInterestedTags) ? Collections.emptySet() :
                new HashSet<>(splitter.splitToList(convertInterestedTags));
        Set<String> convertUninterestedTagSet = StringUtils.isEmpty(convertUninterestedTags) ? Collections.emptySet() :
                new HashSet<>(splitter.splitToList(convertUninterestedTags));


        for (Advert advert : adverts) {

            String matchTags = advert.getMatchTags();
            Set<String> matchTagNumSet = StringUtils.isEmpty(matchTags) ? Collections.emptySet() :
                    new HashSet<>(splitter.splitToList(matchTags));

            int type = getType(clickInterestedTagSet, clickUninterestedTagSet, convertInterestedTagSet,
                    convertUninterestedTagSet, matchTagNumSet);

            advertBehaviorMap.put(advert.getId(), type);

        }


        return advertBehaviorMap;
    }

    private int getType(Set<String> clickInterestedTagSet, Set<String> clickUninterestedTagSet, Set<String>
            convertInterestedTagSet, Set<String> convertUninterestedTagSet, Set<String> matchTagNumSet) {
        int type = 0;

        if (CollectionUtils.isNotEmpty(Sets.intersection(clickInterestedTagSet, matchTagNumSet))) {
            type |= 0b1000;
        }

        if (CollectionUtils.isNotEmpty(Sets.intersection(clickUninterestedTagSet, matchTagNumSet))) {
            type |= 0b100;
        }

        if (CollectionUtils.isNotEmpty(Sets.intersection(convertInterestedTagSet, matchTagNumSet))) {
            type |= 0b10;
        }

        if (CollectionUtils.isNotEmpty(Sets.intersection(convertUninterestedTagSet, matchTagNumSet))) {
            type |= 0b1;
        }
        return type;
    }
}
