package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;

import static java.util.stream.Collectors.toList;

/**
 * 智能采买相关的类
 */
@Service
public class AdvertSmartShopService extends CacheService {

    private LoadingCache<String, Integer> blackWhiteCache = CacheBuilder.newBuilder()
            .expireAfterWrite(5, TimeUnit.MINUTES)
            .build(new CacheLoader<String, Integer>() {
                @Override
                public Integer load(String key) {
                    throw new UnsupportedOperationException("not support single query");
                }

                @Override
                public Map<String, Integer> loadAll(Iterable<? extends String> keys) {

                    List<String> keyList = StreamSupport.stream(keys.spliterator(), false).collect(toList());

                    Map<String, Integer> blackWhiteMap = new HashMap<>(keyList.size());

                    DBTimeProfile.enter("load blackWhiteCache " + keyList.size());

                    List<String> values = nezhaStringRedisTemplate.opsForValue().multiGet(keyList);

                    DBTimeProfile.release();

                    convert(keyList, blackWhiteMap, values);

                    return blackWhiteMap;

                }
            });


    private void convert(List<String> collect, Map<String, Integer> blackWhiteMap, List<String> values) {
        for (int index = 0; index < collect.size(); index++) {
            String key = collect.get(index);
            String value = values.get(index);

            Integer qualityLevel = Optional.ofNullable(value)
                    .map(v -> {
                        switch (v) {
                            case "b1":
                                return 1;
                            case "b2":
                                return 2;
                            case "b3":
                                return 3;
                            case "w":
                                return 8;
                            default:
                                return 16;
                        }
                    }).orElse(0);

            blackWhiteMap.put(key, qualityLevel);
        }
    }


    public void handlePackageQualityLevelLevel(Set<OrientationPackage> orientationPackages, Long appId, Long slotId, Long activityId) {
        try {

            DBTimeProfile.enter("loadBlackWhite");
            List<String> allKeys = new ArrayList<>(orientationPackages.size() * 2);
            Map<OrientationPackage, String> oldKeyMap = new HashMap<>(orientationPackages.size());
            Map<OrientationPackage, String> newKeyMap = new HashMap<>(orientationPackages.size());
            orientationPackages.forEach(orientationPackage -> {
                Long advertId = orientationPackage.getAdvertId();
                Long packageId = orientationPackage.getId();
                String oldBlackWhiteKey = RedisKeyUtil.getBlackWhiteKey(appId, slotId, activityId, packageId, advertId);
                String newBlackWhiteKey = RedisKeyUtil.getNewBlackWhiteKey(advertId, packageId);
                allKeys.add(oldBlackWhiteKey);
                allKeys.add(newBlackWhiteKey);
                oldKeyMap.put(orientationPackage, oldBlackWhiteKey);
                newKeyMap.put(orientationPackage, newBlackWhiteKey);
            });
            Map<String, Integer> all = blackWhiteCache.getAll(allKeys);

            orientationPackages.forEach(orientationPackage ->
                    orientationPackage.setQualityLevel(
                            Optional.ofNullable(all.get(newKeyMap.get(orientationPackage)))
                                    .orElse(all.get(oldKeyMap.get(orientationPackage)))
                    )
            );


        } catch (Exception e) {
            logger.error("load blackWhite error :{}", e);
        } finally {
            DBTimeProfile.release();
        }
    }
}
